/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metamodel;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.metamodel.EmbeddableTypeImpl;
import org.datanucleus.api.jpa.metamodel.EntityTypeImpl;
import org.datanucleus.api.jpa.metamodel.ManagedTypeImpl;
import org.datanucleus.api.jpa.metamodel.MappedSuperclassTypeImpl;
import org.datanucleus.api.jpa.metamodel.TypeImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelImpl
implements Metamodel {
    MetaDataManager mmgr;
    ClassLoaderResolver clr;
    Map<String, EntityType<?>> entityTypes = new HashMap();
    Map<String, MappedSuperclassTypeImpl<?>> mappedSuperTypes = new HashMap();
    Map<String, EmbeddableType<?>> embeddedTypes = new HashMap();
    Map<String, Type<?>> basicTypes = new HashMap();

    public MetamodelImpl(MetaDataManager mmgr) {
        this.mmgr = mmgr;
        this.clr = mmgr.getNucleusContext().getClassLoaderResolver(null);
        FileMetaData[] filemds = mmgr.getFileMetaData();
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        for (int i = 0; i < filemds.length; ++i) {
            for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                PackageMetaData pmd = filemds[i].getPackage(j);
                for (int k = 0; k < pmd.getNoOfClasses(); ++k) {
                    ManagedTypeImpl type;
                    ClassMetaData cmd = pmd.getClass(k);
                    Class cls = clr.classForName(cmd.getFullClassName());
                    EmbeddableTypeImpl managedType = null;
                    if (cmd.isEmbeddedOnly()) {
                        managedType = type = new EmbeddableTypeImpl(cls, (AbstractClassMetaData)cmd, this);
                        this.embeddedTypes.put(cmd.getFullClassName(), (EmbeddableType<?>)type);
                    } else if (cmd.isAbstract()) {
                        managedType = type = new MappedSuperclassTypeImpl(cls, (AbstractClassMetaData)cmd, this);
                        this.mappedSuperTypes.put(cmd.getFullClassName(), (MappedSuperclassTypeImpl<?>)type);
                    } else {
                        managedType = type = new EntityTypeImpl(cls, (AbstractClassMetaData)cmd, this);
                        this.entityTypes.put(cmd.getFullClassName(), (EntityType<?>)type);
                    }
                    Class metaCls = null;
                    try {
                        metaCls = clr.classForName(cmd.getFullClassName() + "_");
                        Field[] metaFields = metaCls.getFields();
                        if (metaFields == null || metaFields.length <= 0) continue;
                        for (int l = 0; l < metaFields.length; ++l) {
                            Field fld = metaFields[l];
                            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(fld.getName());
                            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                            Attribute attr = managedType.getAttribute(fld.getName());
                            try {
                                fld.set(null, attr);
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    catch (ClassNotResolvedException cnre) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        EmbeddableType<?> type = this.embeddedTypes.get(cls.getName());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Type " + cls.getName() + " is not a known embeddable type");
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        HashSet results = new HashSet();
        results.addAll(this.embeddedTypes.values());
        return results;
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        EntityType<?> type = this.entityTypes.get(cls.getName());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Type " + cls.getName() + " is not a known entity type");
    }

    public Set<EntityType<?>> getEntities() {
        HashSet results = new HashSet();
        results.addAll(this.entityTypes.values());
        return results;
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        EmbeddableType<?> type = this.entityTypes.get(cls.getName());
        if (type != null) {
            return type;
        }
        type = this.embeddedTypes.get(cls.getName());
        if (type != null) {
            return type;
        }
        type = (EmbeddableType<?>)this.mappedSuperTypes.get(cls.getName());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Type " + cls.getName() + " is not a known managed type");
    }

    public Set<ManagedType<?>> getManagedTypes() {
        HashSet results = new HashSet();
        results.addAll(this.entityTypes.values());
        results.addAll(this.embeddedTypes.values());
        results.addAll(this.mappedSuperTypes.values());
        return results;
    }

    public <X> Type<X> getType(Class<X> cls) {
        try {
            return this.managedType(cls);
        }
        catch (IllegalArgumentException ex) {
            if (this.basicTypes.containsKey(cls.getName())) {
                return this.basicTypes.get(cls.getName());
            }
            TypeImpl<X> basic = new TypeImpl<X>(cls);
            this.basicTypes.put(cls.getName(), basic);
            return basic;
        }
    }
}

