/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.datanucleus.api.jpa.JPAAdapter;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.exceptions.NoPersistenceUnitException;
import org.datanucleus.api.jpa.exceptions.NoPersistenceXmlException;
import org.datanucleus.api.jpa.exceptions.NotProviderException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;

public class PersistenceProviderImpl
implements PersistenceProvider,
ProviderUtil {
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo unitInfo, Map properties) {
        try {
            JPAEntityManagerFactory emf = new JPAEntityManagerFactory(unitInfo, properties);
            return emf;
        }
        catch (NotProviderException npe) {
            return null;
        }
        catch (NoPersistenceUnitException npue) {
            return null;
        }
        catch (NoPersistenceXmlException npxe) {
            return null;
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String unitName, Map properties) {
        try {
            JPAEntityManagerFactory emf = new JPAEntityManagerFactory(unitName, properties);
            return emf;
        }
        catch (NotProviderException npe) {
            return null;
        }
        catch (NoPersistenceUnitException npue) {
            return null;
        }
        catch (NoPersistenceXmlException npxe) {
            return null;
        }
    }

    public LoadState isLoadedWithoutReference(Object entity, String memberName) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        JPAAdapter adapter = new JPAAdapter();
        ExecutionContext ec = adapter.getExecutionContext(entity);
        if (ec == null) {
            return LoadState.UNKNOWN;
        }
        ObjectProvider sm = ec.findObjectProvider(entity);
        if (sm == null) {
            return LoadState.UNKNOWN;
        }
        String[] loadedFields = sm.getLoadedFieldNames();
        if (loadedFields != null) {
            for (int i = 0; i < loadedFields.length; ++i) {
                if (!loadedFields[i].equals(memberName)) continue;
                return LoadState.LOADED;
            }
        }
        return LoadState.NOT_LOADED;
    }

    public LoadState isLoadedWithReference(Object entity, String memberName) {
        return this.isLoadedWithoutReference(entity, memberName);
    }

    public LoadState isLoaded(Object entity) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        JPAAdapter adapter = new JPAAdapter();
        ExecutionContext ec = adapter.getExecutionContext(entity);
        if (ec == null) {
            return LoadState.UNKNOWN;
        }
        ObjectProvider sm = ec.findObjectProvider(entity);
        if (sm == null) {
            return LoadState.UNKNOWN;
        }
        boolean allLoaded = true;
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(entity.getClass(), ec.getClassLoaderResolver());
        int[] dfgFieldNumbers = cmd.getDFGMemberPositions();
        for (int i = 0; i < dfgFieldNumbers.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(dfgFieldNumbers[i]);
            String[] loadedFields = sm.getLoadedFieldNames();
            boolean memberLoaded = false;
            if (loadedFields != null) {
                for (int j = 0; j < loadedFields.length; ++j) {
                    if (!loadedFields[j].equals(mmd.getName())) continue;
                    memberLoaded = true;
                    break;
                }
            }
            if (memberLoaded) continue;
            allLoaded = false;
            break;
        }
        return allLoaded ? LoadState.LOADED : LoadState.NOT_LOADED;
    }

    public ProviderUtil getProviderUtil() {
        return this;
    }
}

