/*
 * (c) Copyright 2013 by Volker Bergmann. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted under the terms of the
 * GNU General Public License (GPL).
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * WITHOUT A WARRANTY OF ANY KIND. ALL EXPRESS OR IMPLIED CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
 * HEREBY EXCLUDED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package org.databene.platform.xls;

import org.databene.benerator.DefaultPlatformDescriptor;

/**
 * XLS platform descriptor.<br/><br/>
 * Created: 24.01.2013 17:41:59
 * @since 0.8.0
 * @author Volker Bergmann
 */
public class PlatformDescriptor extends DefaultPlatformDescriptor {
	
	private static boolean formattedByDefault = false;
	private static String collectionReferencePrefix = "tab:";
	
	public PlatformDescriptor() {
		super(PlatformDescriptor.class.getName());
	}
	
	public static boolean isFormattedByDefault() {
		return formattedByDefault;
	}
	
	public static void setFormattedByDefault(boolean formattedByDefault) {
		PlatformDescriptor.formattedByDefault = formattedByDefault;
	}
	
	public static String getCollectionReferencePrefix() {
		return collectionReferencePrefix;
	}
	
	public static void setCollectionReferencePrefix(String collectionReferencePrefix) {
		PlatformDescriptor.collectionReferencePrefix = collectionReferencePrefix;
	}
	
}
