/*
 * (c) Copyright 2011-2013 by Volker Bergmann. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted under the terms of the
 * GNU General Public License (GPL).
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * WITHOUT A WARRANTY OF ANY KIND. ALL EXPRESS OR IMPLIED CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
 * HEREBY EXCLUDED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package org.databene.benerator.engine;

import org.databene.benerator.wrapper.ProductWrapper;

/**
 * Sub context version of the {@link BeneratorContext}.<br/><br/>
 * Created: 02.09.2011 14:35:59
 * @since 0.7.0
 * @author Volker Bergmann
 */
public class DefaultBeneratorSubContext extends AbstractBeneratorSubContext {
	
	private ProductWrapper<?> currentProduct;

	public DefaultBeneratorSubContext(String productName, BeneratorContext parent) {
		super(productName, parent);
	}
	
	@Override
	public ProductWrapper<?> getCurrentProduct() {
		return currentProduct;
	}

	@Override
	public void setCurrentProduct(ProductWrapper<?> currentProduct) {
		this.currentProduct = currentProduct;
	}
	
	@Override
	public BeneratorContext createSubContext(String productName) {
		return new DefaultBeneratorSubContext(productName, this);
	}

}
