/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css.saxon.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.AbstractRuleBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.daisy.braille.css.InlineStyle;
import org.daisy.braille.css.SelectorImpl;
import org.daisy.braille.css.SimpleInlineStyle;
import org.daisy.common.stax.BaseURIAwareXMLStreamReader;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.common.transform.InputValue;
import org.daisy.common.transform.Mult;
import org.daisy.common.transform.SingleInSingleOutXMLTransformer;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.transform.XMLInputValue;
import org.daisy.common.transform.XMLOutputValue;
import org.daisy.pipeline.braille.css.impl.BrailleCssSerializer;
import org.daisy.pipeline.braille.css.saxon.impl.InvalidTableException;

public class TableAsList
extends SingleInSingleOutXMLTransformer {
    private static final String XMLNS_CSS = "http://www.daisy.org/ns/pipeline/braille-css";
    private static final QName _STYLE = new QName("style");
    private static final QName _ID = new QName("id");
    private static final String XMLNS_HTML = "http://www.w3.org/1999/xhtml";
    private static final String XMLNS_DTB = "http://www.daisy.org/z3986/2005/dtbook/";
    private static final String TABLE = "table";
    private static final String THEAD = "thead";
    private static final String TFOOT = "tfoot";
    private static final String TBODY = "tbody";
    private static final String TR = "tr";
    private static final String TD = "td";
    private static final String TH = "th";
    private static final String COLGROUP = "colgroup";
    private static final String COL = "col";
    private static final QName _HEADERS = new QName("headers");
    private static final QName _SCOPE = new QName("scope");
    private static final QName _AXIS = new QName("axis");
    private static final QName _ROWSPAN = new QName("rowspan");
    private static final QName _COLSPAN = new QName("colspan");
    private static final QName CSS_TABLE_HEADER_POLICY = new QName("http://www.daisy.org/ns/pipeline/braille-css", "table-header-policy", "css");
    private static final QName CSS_TABLE_BY = new QName("http://www.daisy.org/ns/pipeline/braille-css", "table-by", "css");
    private static final QName CSS_LIST_ITEM = new QName("http://www.daisy.org/ns/pipeline/braille-css", "list-item", "css");
    private static final QName CSS_LIST_HEADER = new QName("http://www.daisy.org/ns/pipeline/braille-css", "list-header", "css");
    private static final QName CSS_ID = new QName("http://www.daisy.org/ns/pipeline/braille-css", "id", "css");
    private static final QName CSS_FLOW = new QName("http://www.daisy.org/ns/pipeline/braille-css", "flow", "css");
    private static final Splitter HEADERS_SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();
    private static final Splitter AXIS_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    final List<String> axes;
    private List<XMLStreamWriterHelper.WriterEvent> writeActionsBefore;
    private List<XMLStreamWriterHelper.WriterEvent> writeActionsAfter;
    private List<TableCell> cells;
    private Set<CellCoordinates> coveredCoordinates;
    private static final List<TableCell> emptyList = new ArrayList<TableCell>();
    private final Map<String, TableByStyle> tableByStyles = new HashMap<String, TableByStyle>();
    private ListItemStyle listHeaderStyle = new ListItemStyle();
    private static final Comparator<TableCell> sortByRow = new Comparator<TableCell>(){

        @Override
        public int compare(TableCell c1, TableCell c2) {
            return new Integer(c1.row).compareTo(c2.row);
        }
    };
    private static final Comparator<TableCell> sortByColumn = new Comparator<TableCell>(){

        @Override
        public int compare(TableCell c1, TableCell c2) {
            return new Integer(c1.col).compareTo(c2.col);
        }
    };
    private static final Comparator<TableCell> sortByRowType = new Comparator<TableCell>(){

        @Override
        public int compare(TableCell c1, TableCell c2) {
            return c1.rowType.compareTo(c2.rowType);
        }
    };
    private static final Comparator<TableCell> sortByRowAndThenColumn = TableAsList.compose(sortByRow, sortByColumn);
    private static final Comparator<TableCell> sortByColumnAndThenRow = TableAsList.compose(sortByColumn, sortByRow);

    TableAsList(String axes) {
        this.axes = new ArrayList<String>(AXIS_SPLITTER.splitToList((CharSequence)axes));
        if (this.axes.remove("auto") && !this.axes.isEmpty()) {
            throw new RuntimeException();
        }
    }

    public Runnable transform(XMLInputValue<?> source, XMLOutputValue<?> result, InputValue<?> params) throws IllegalArgumentException {
        if (source == null || result == null) {
            throw new IllegalArgumentException();
        }
        return () -> this.transform(source.ensureSingleItem().mult(2), result.asXMLStreamWriter());
    }

    private void transform(Mult<? extends XMLInputValue<?>> source, BaseURIAwareXMLStreamWriter writer) throws TransformerException {
        BaseURIAwareXMLStreamReader reader = ((XMLInputValue)source.get()).asXMLStreamReader();
        try {
            this.writeActionsBefore = new ArrayList<XMLStreamWriterHelper.WriterEvent>();
            this.writeActionsAfter = new ArrayList<XMLStreamWriterHelper.WriterEvent>();
            this.cells = new ArrayList<TableCell>();
            this.coveredCoordinates = new HashSet<CellCoordinates>();
            List<XMLStreamWriterHelper.WriterEvent> writeActions = this.writeActionsBefore;
            int depth = 0;
            TableCell withinCell = null;
            TableCell.RowType rowType = TableCell.RowType.TBODY;
            int rowGroup = 1;
            int row = 1;
            int col = 1;
            String namespace = null;
            LinkedList<SimpleInlineStyle> inheritedStyle = new LinkedList<SimpleInlineStyle>();
            block13: while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        int i;
                        int i2;
                        QName name = reader.getName();
                        boolean isCell = false;
                        if (++depth == 1) {
                            if (!this.isHTMLorDTBookElement(TABLE, name)) {
                                throw new RuntimeException("Expected table element (html|dtb).");
                            }
                            if (XMLNS_HTML.equals(name.getNamespaceURI())) {
                                namespace = XMLNS_HTML;
                            } else if (XMLNS_DTB.equals(name.getNamespaceURI())) {
                                namespace = XMLNS_DTB;
                            }
                        } else {
                            if (this.isHTMLorDTBookElement(THEAD, name) || this.isHTMLorDTBookElement(TFOOT, name) || this.isHTMLorDTBookElement(TBODY, name) || this.isHTMLorDTBookElement(TR, name)) {
                                rowType = this.isHTMLorDTBookElement(THEAD, name) ? TableCell.RowType.THEAD : (this.isHTMLorDTBookElement(TFOOT, name) ? TableCell.RowType.TFOOT : (this.isHTMLorDTBookElement(TBODY, name) ? TableCell.RowType.TBODY : rowType));
                                String style = null;
                                for (i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
                                    if (!_STYLE.equals(reader.getAttributeName(i2))) continue;
                                    style = reader.getAttributeValue(i2);
                                    break;
                                }
                                inheritedStyle.push(new SimpleInlineStyle(style, inheritedStyle.isEmpty() ? null : (SimpleInlineStyle)inheritedStyle.peek()));
                                break;
                            }
                            if (this.isHTMLorDTBookElement(COLGROUP, name) || this.isHTMLorDTBookElement(COL, name)) {
                                throw new RuntimeException("Elements colgroup and col not supported yet.");
                            }
                        }
                        if (this.isHTMLorDTBookElement(TD, name) || this.isHTMLorDTBookElement(TH, name)) {
                            isCell = true;
                            withinCell = new TableCell();
                            withinCell.row = row;
                            withinCell.col = col;
                            withinCell.rowGroup = rowGroup;
                            withinCell.rowType = rowType;
                            withinCell.ns = namespace;
                            this.setCovered(row, col);
                            this.cells.add(withinCell);
                            if (this.isHTMLorDTBookElement(TH, name)) {
                                withinCell.type = TableCell.CellType.TH;
                            }
                            String style = null;
                            for (i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
                                if (!_STYLE.equals(reader.getAttributeName(i2))) continue;
                                style = reader.getAttributeValue(i2);
                                break;
                            }
                            withinCell.style = new SimpleInlineStyle(style, inheritedStyle.isEmpty() ? null : (SimpleInlineStyle)inheritedStyle.peek());
                            writeActions = withinCell.content;
                        } else {
                            if (withinCell != null) {
                                String flow = "normal";
                                for (i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
                                    if (!CSS_FLOW.equals(reader.getAttributeName(i2))) continue;
                                    flow = reader.getAttributeValue(i2);
                                    break;
                                }
                                if (!"normal".equals(flow)) {
                                    writeActions.add(TableAsList.writeElementOnce((XMLStreamReader)reader));
                                    break;
                                }
                            }
                            writeActions.add(w -> XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)w, (QName)name));
                        }
                        for (i = 0; i < reader.getNamespaceCount(); ++i) {
                            String prf = reader.getNamespacePrefix(i);
                            String ns = reader.getNamespaceURI(i);
                            writeActions.add(w -> w.writeNamespace(prf, ns));
                        }
                        for (i = 0; i < reader.getAttributeCount(); ++i) {
                            QName attrName = reader.getAttributeName(i);
                            String attrValue = reader.getAttributeValue(i);
                            if (CSS_ID.equals(attrName)) {
                                WriteOnlyOnce writeOnlyOnce = new WriteOnlyOnce();
                                writeOnlyOnce.add(w -> XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)attrName, (String)attrValue));
                                writeActions.add(writeOnlyOnce);
                                continue;
                            }
                            if (CSS_TABLE_HEADER_POLICY.equals(attrName)) {
                                if (!isCell) continue;
                                if ("once".equals(attrValue)) {
                                    withinCell.headerPolicy = TableCell.HeaderPolicy.ONCE;
                                    continue;
                                }
                                if ("always".equals(attrValue)) {
                                    withinCell.headerPolicy = TableCell.HeaderPolicy.ALWAYS;
                                    continue;
                                }
                                if ("front".equals(attrValue)) {
                                    withinCell.headerPolicy = TableCell.HeaderPolicy.FRONT;
                                    continue;
                                }
                                throw new RuntimeException("Expected value once|always for table-header-policy property but got " + attrValue);
                            }
                            if (isCell && _HEADERS.equals(attrName)) {
                                withinCell.headers = HEADERS_SPLITTER.splitToList((CharSequence)attrValue);
                                continue;
                            }
                            if (isCell && _SCOPE.equals(attrName)) {
                                if ("row".equals(attrValue)) {
                                    withinCell.scope = TableCell.Scope.ROW;
                                    continue;
                                }
                                if (COL.equals(attrValue)) {
                                    withinCell.scope = TableCell.Scope.COL;
                                    continue;
                                }
                                if (COLGROUP.equals(attrValue) || "rowgroup".equals(attrValue)) {
                                    throw new RuntimeException("Value " + attrValue + " for scope attribute not supported yet.");
                                }
                                throw new RuntimeException("Expected value col|row|colgroup|rowgroup for scope attribute but got " + attrValue);
                            }
                            if (isCell && _AXIS.equals(attrName)) {
                                withinCell.axis = AXIS_SPLITTER.splitToList((CharSequence)attrValue);
                                continue;
                            }
                            if (isCell && _ROWSPAN.equals(attrName)) {
                                try {
                                    withinCell.rowspan = Integer.parseInt(attrValue);
                                    if (withinCell.rowspan < 0) {
                                        throw new InvalidTableException("Invalid rowspan: " + attrValue);
                                    }
                                    if (withinCell.rowspan == 0) {
                                        throw new RuntimeException("rowspan 0 not supported yet.");
                                    }
                                }
                                catch (NumberFormatException e) {
                                    throw new InvalidTableException("Invalid rowspan: " + attrValue);
                                }
                                for (int m = 1; m < withinCell.rowspan; ++m) {
                                    for (int n = 0; n < withinCell.colspan; ++n) {
                                        this.setCovered(row + m, col + n);
                                    }
                                }
                                continue;
                            }
                            if (isCell && _COLSPAN.equals(attrName)) {
                                try {
                                    withinCell.colspan = Integer.parseInt(attrValue);
                                    if (withinCell.colspan < 0) {
                                        throw new InvalidTableException("Invalid colspan: " + attrValue);
                                    }
                                    if (withinCell.colspan == 0) {
                                        throw new RuntimeException("colspan 0 not supported yet.");
                                    }
                                }
                                catch (NumberFormatException e) {
                                    throw new InvalidTableException("Invalid colspan: " + attrValue);
                                }
                                for (int m = 0; m < withinCell.rowspan; ++m) {
                                    for (int n = 1; n < withinCell.colspan; ++n) {
                                        this.setCovered(row + m, col + n);
                                    }
                                }
                                continue;
                            }
                            if (isCell && _ID.equals(attrName)) {
                                withinCell.id = attrValue;
                                continue;
                            }
                            if (depth == 1 && _STYLE.equals(attrName)) {
                                InlineStyle style = new InlineStyle(attrValue);
                                ArrayList<Object> builder = new ArrayList<Object>();
                                for (RuleBlock block : style) {
                                    if (block instanceof InlineStyle.RuleMainBlock) {
                                        builder.add(style.getMainStyle());
                                        continue;
                                    }
                                    if (block instanceof InlineStyle.RuleRelativeBlock) {
                                        InlineStyle.RuleRelativeBlock ruleblock = (InlineStyle.RuleRelativeBlock)block;
                                        List selector = ruleblock.getSelector();
                                        if (selector.size() <= 0) continue;
                                        if (((Selector)selector.get(0)).size() > 0) {
                                            if (((Selector)selector.get(0)).get(0) instanceof SelectorImpl.PseudoElementImpl) {
                                                SelectorImpl.PseudoElementImpl pseudo = (SelectorImpl.PseudoElementImpl)((Selector)selector.get(0)).get(0);
                                                if ("list-header".equals(pseudo.getName())) {
                                                    if (!pseudo.getPseudoClasses().isEmpty()) continue;
                                                    this.addListHeaderStyle(new ListItemStyle(TableAsList.rest(ruleblock)));
                                                    continue;
                                                }
                                                if ("table-by".equals(pseudo.getName())) {
                                                    String axis = pseudo.getArguments()[0];
                                                    if (!pseudo.getPseudoClasses().isEmpty()) continue;
                                                    if (pseudo.hasStackedPseudoElement()) {
                                                        pseudo = pseudo.getStackedPseudoElement();
                                                        ruleblock = (InlineStyle.RuleRelativeBlock)TableAsList.rest(ruleblock);
                                                        if ("list-item".equals(pseudo.getName())) {
                                                            this.getTableByStyle(axis).addListItemStyle(pseudo.getPseudoClasses(), new ListItemStyle(TableAsList.rest(ruleblock)));
                                                            continue;
                                                        }
                                                        if ("list-header".equals(pseudo.getName())) {
                                                            if (!pseudo.getPseudoClasses().isEmpty()) continue;
                                                            this.getTableByStyle(axis).addListHeaderStyle(new ListItemStyle(TableAsList.rest(ruleblock)));
                                                            continue;
                                                        }
                                                        this.getTableByStyle(axis).addRuleBlock((RuleBlock<Rule<?>>)ruleblock);
                                                        continue;
                                                    }
                                                    this.getTableByStyle(axis).addRuleBlock(TableAsList.rest(ruleblock));
                                                    continue;
                                                }
                                                builder.add(ruleblock);
                                                continue;
                                            }
                                            builder.add(ruleblock);
                                            continue;
                                        }
                                        builder.add(ruleblock);
                                        continue;
                                    }
                                    throw new RuntimeException("Unexpected style " + block);
                                }
                                String newStyle = BrailleCssSerializer.serializeRuleBlockList(builder);
                                if (newStyle.isEmpty()) continue;
                                writeActions.add(w -> XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)attrName, (String)newStyle));
                                continue;
                            }
                            if (isCell && _STYLE.equals(attrName)) continue;
                            writeActions.add(w -> XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)attrName, (String)attrValue));
                        }
                        continue block13;
                    }
                    case 4: {
                        String chars = reader.getText();
                        writeActions.add(w -> w.writeCharacters(chars));
                        break;
                    }
                    case 2: {
                        QName name = reader.getName();
                        --depth;
                        if (this.isHTMLorDTBookElement(THEAD, name) || this.isHTMLorDTBookElement(TFOOT, name) || this.isHTMLorDTBookElement(TBODY, name)) {
                            inheritedStyle.pop();
                            ++rowGroup;
                            break;
                        }
                        if (this.isHTMLorDTBookElement(TR, name)) {
                            inheritedStyle.pop();
                            ++row;
                            col = 1;
                            while (this.isCovered(row, col)) {
                                ++col;
                            }
                            continue block13;
                        }
                        if (this.isHTMLorDTBookElement(TD, name) || this.isHTMLorDTBookElement(TH, name)) {
                            withinCell = null;
                            writeActions = this.writeActionsAfter;
                            while (this.isCovered(row, col)) {
                                ++col;
                            }
                            continue block13;
                        }
                        writeActions.add(w -> w.writeEndElement());
                        break;
                    }
                }
            }
            ArrayList<TableCell> moreCells = new ArrayList<TableCell>();
            for (TableCell c : this.cells) {
                TableCell dup;
                int i;
                int span;
                if (TableAsList.isHeader(c)) continue;
                if (c.rowspan > 1) {
                    span = c.rowspan;
                    c.rowspan = 1;
                    for (i = 1; i < span; ++i) {
                        dup = c.clone();
                        dup.row = c.row + i;
                        moreCells.add(dup);
                    }
                }
                if (c.colspan <= 1) continue;
                span = c.colspan;
                c.colspan = 1;
                for (i = 1; i < span; ++i) {
                    dup = c.clone();
                    dup.col = c.col + i;
                    moreCells.add(dup);
                }
            }
            this.cells.addAll(moreCells);
            Collections.sort(this.cells, TableAsList.compose(sortByRowType, sortByRow, sortByColumn));
            rowGroup = 0;
            row = 0;
            rowGroup = 0;
            int newRowGroup = 0;
            row = 0;
            int newRow = 0;
            for (TableCell c : this.cells) {
                if (c.rowGroup != rowGroup) {
                    rowGroup = c.rowGroup;
                    ++newRowGroup;
                }
                if (c.row != row) {
                    row = c.row;
                }
                c.rowGroup = newRowGroup;
                c.row = ++newRow;
            }
            this.write((XMLStreamWriter)writer);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidTableException e) {
            String message = "Table structure broken: " + e.getMessage();
            throw new TransformerException((Throwable)new RuntimeException(message, new RuntimeException(message + ":\n" + TableAsList.elementToString((XMLInputValue)source.get()))));
        }
        catch (RuntimeException e) {
            String message = "Error happened while processing table";
            throw new TransformerException((Throwable)new RuntimeException(message, new RuntimeException(message + ":\n" + TableAsList.elementToString((XMLInputValue)source.get()), e)));
        }
    }

    private boolean isHTMLorDTBookElement(String element, QName name) {
        return (XMLNS_HTML.equals(name.getNamespaceURI()) || XMLNS_DTB.equals(name.getNamespaceURI())) && name.getLocalPart().equalsIgnoreCase(element);
    }

    private void setCovered(int row, int col) {
        CellCoordinates coords = new CellCoordinates(row, col);
        if (this.coveredCoordinates.contains(coords)) {
            throw new InvalidTableException("cells overlap");
        }
        this.coveredCoordinates.add(coords);
    }

    private boolean isCovered(int row, int col) {
        return this.coveredCoordinates.contains(new CellCoordinates(row, col));
    }

    private void write(XMLStreamWriter writer) throws XMLStreamException {
        for (XMLStreamWriterHelper.WriterEvent action : this.writeActionsBefore) {
            action.writeTo(writer);
        }
        ArrayList<TableCell> dataCells = new ArrayList<TableCell>();
        for (TableCell c : this.cells) {
            if (TableAsList.isHeader(c)) continue;
            dataCells.add(c);
        }
        new TableCellGroup(dataCells, this.axes.iterator()).write(writer);
        for (XMLStreamWriterHelper.WriterEvent action : this.writeActionsAfter) {
            action.writeTo(writer);
        }
    }

    private static void writeStyleAttribute(XMLStreamWriter writer, PseudoElementStyle style) throws XMLStreamException {
        if (!style.isEmpty()) {
            XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_STYLE, (String)style.toString());
        }
    }

    public void addListHeaderStyle(ListItemStyle style) {
        this.listHeaderStyle = this.listHeaderStyle.mergeWith(style);
    }

    public TableByStyle getTableByStyle(String axis) {
        TableByStyle style = this.tableByStyles.get(axis);
        if (style == null) {
            style = new TableByStyle();
            this.tableByStyles.put(axis, style);
        }
        return style;
    }

    public ListItemStyle getListHeaderStyle() {
        return this.listHeaderStyle;
    }

    private static final Predicate<Selector.PseudoClass> matchesPosition(final int position, final int elementCount) {
        return new Predicate<Selector.PseudoClass>(){

            public boolean apply(Selector.PseudoClass pseudo) {
                if (pseudo instanceof SelectorImpl.PseudoClassImpl) {
                    return ((SelectorImpl.PseudoClassImpl)pseudo).matchesPosition(position, elementCount);
                }
                return false;
            }
        };
    }

    private List<TableCell> findHeaders(TableCell cell, boolean firstLeftThenUpward) {
        ArrayList<TableCell> headers = new ArrayList<TableCell>();
        if (TableAsList.isHeader(cell)) {
            headers.add(cell);
        }
        this.findHeaders(headers, 0, cell, firstLeftThenUpward);
        return headers;
    }

    private int findHeaders(List<TableCell> headers, int index, TableCell cell, boolean firstLeftThenUpward) {
        if (cell.headers != null) {
            for (String id : cell.headers) {
                index = this.recurAddHeader(headers, index, this.getById(id), firstLeftThenUpward);
            }
            return index;
        }
        ArrayList<TableCell> rowHeaders = new ArrayList<TableCell>();
        ArrayList<TableCell> colHeaders = new ArrayList<TableCell>();
        for (TableCell h : this.cells) {
            if (h == cell || h.scope == null) continue;
            switch (h.scope) {
                case ROW: {
                    if (h.row > cell.row + cell.rowspan - 1 || cell.row > h.row + h.rowspan - 1) break;
                    rowHeaders.add(h);
                    break;
                }
                case COL: {
                    if (h.col > cell.col + cell.colspan - 1 || cell.col > h.col + h.colspan - 1) break;
                    colHeaders.add(h);
                }
            }
        }
        Collections.sort(rowHeaders, sortByColumnAndThenRow);
        for (TableCell h : rowHeaders) {
            index = this.recurAddHeader(headers, index, h, firstLeftThenUpward);
        }
        Collections.sort(colHeaders, sortByRowAndThenColumn);
        for (TableCell h : colHeaders) {
            index = this.recurAddHeader(headers, index, h, firstLeftThenUpward);
        }
        if (!TableAsList.isHeader(cell)) {
            int direction = firstLeftThenUpward ? 0 : 1;
            block12: while (true) {
                switch (direction) {
                    case 0: {
                        int l;
                        TableCell c;
                        boolean foundHeader;
                        int j;
                        int i;
                        int k = 0;
                        block13: for (i = 0; i < cell.rowspan; ++i) {
                            j = cell.col - 1;
                            while (j > 0) {
                                foundHeader = false;
                                c = this.getByCoordinates(cell.row + i, j);
                                if (c != null && TableAsList.isHeader(c)) {
                                    foundHeader = true;
                                    if (c.scope == null) {
                                        l = this.recurAddHeader(headers, index, c, firstLeftThenUpward) - index;
                                        k += l;
                                        if (l > 1) {
                                            continue block13;
                                        }
                                    }
                                } else if (foundHeader) continue block13;
                                if (c == null) {
                                    --j;
                                    continue;
                                }
                                j -= c.colspan;
                            }
                        }
                        index += k;
                        if (!firstLeftThenUpward) break block12;
                    }
                    case 1: {
                        int l;
                        TableCell c;
                        boolean foundHeader;
                        int j;
                        int i;
                        int k = 0;
                        block15: for (i = 0; i < cell.colspan; ++i) {
                            j = cell.row - 1;
                            while (j > 0) {
                                foundHeader = false;
                                c = this.getByCoordinates(j, cell.col + i);
                                if (c != null && TableAsList.isHeader(c)) {
                                    foundHeader = true;
                                    if (c.scope == null) {
                                        l = this.recurAddHeader(headers, index, c, firstLeftThenUpward) - index;
                                        k += l;
                                        if (l > 1) {
                                            continue block15;
                                        }
                                    }
                                } else if (foundHeader) continue block15;
                                if (c == null) {
                                    --j;
                                    continue;
                                }
                                j -= c.rowspan;
                            }
                        }
                        index += k;
                        if (firstLeftThenUpward) break block12;
                        --direction;
                        continue block12;
                    }
                    default: {
                        continue block12;
                    }
                }
                break;
            }
        }
        return index;
    }

    private int recurAddHeader(List<TableCell> headers, int index, TableCell header, boolean firstLeftThenUpward) {
        if (!headers.contains(header)) {
            headers.add(index, header);
            index = this.findHeaders(headers, index, header, firstLeftThenUpward);
            ++index;
        }
        return index;
    }

    private TableCell getById(String id) {
        for (TableCell c : this.cells) {
            if (!id.equals(c.id)) continue;
            return c;
        }
        throw new InvalidTableException("No element found with id " + id);
    }

    private TableCell getByCoordinates(int row, int col) {
        for (TableCell c : this.cells) {
            if (c.row > row || c.row + c.rowspan - 1 < row || c.col > col || c.col + c.colspan - 1 < col) continue;
            return c;
        }
        return null;
    }

    private static boolean isHeader(TableCell cell) {
        return cell.type == TableCell.CellType.TH || cell.axis != null || cell.scope != null;
    }

    @SafeVarargs
    private static final <T> Comparator<T> compose(final Comparator<T> ... comparators) {
        return new Comparator<T>(){

            @Override
            public int compare(T x1, T x2) {
                for (Comparator comparator : comparators) {
                    int result = comparator.compare(x1, x2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XMLStreamWriterHelper.WriterEvent writeElementOnce(XMLStreamReader reader) throws XMLStreamException {
        WriteOnlyOnce list = new WriteOnlyOnce();
        int depth = 0;
        try {
            while (true) {
                switch (reader.getEventType()) {
                    case 1: {
                        int i;
                        QName name = reader.getName();
                        ++depth;
                        list.add(w -> XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)w, (QName)name));
                        for (i = 0; i < reader.getNamespaceCount(); ++i) {
                            String prf = reader.getNamespacePrefix(i);
                            String ns = reader.getNamespaceURI(i);
                            list.add(w -> w.writeNamespace(prf, ns));
                        }
                        for (i = 0; i < reader.getAttributeCount(); ++i) {
                            QName attrName = reader.getAttributeName(i);
                            String attrValue = reader.getAttributeValue(i);
                            list.add(w -> XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)attrName, (String)attrValue));
                        }
                        break;
                    }
                    case 4: {
                        String chars = reader.getText();
                        list.add(w -> w.writeCharacters(chars));
                        break;
                    }
                    case 2: {
                        QName name = reader.getName();
                        list.add(w -> w.writeEndElement());
                        if (--depth != 0) break;
                        return list;
                    }
                }
                reader.next();
            }
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("coding error");
        }
    }

    private static RuleBlock<Rule<?>> rest(InlineStyle.RuleRelativeBlock rule) {
        List<Object> combinedSelector = rule.getSelector();
        if (combinedSelector.size() == 0 || ((Selector)combinedSelector.get(0)).size() == 0) {
            throw new RuntimeException("coding error");
        }
        Selector.SelectorPart first = (Selector.SelectorPart)((Selector)combinedSelector.get(0)).get(0);
        if (first instanceof SelectorImpl.PseudoElementImpl) {
            AbstractRuleBlock newRule;
            List rest = combinedSelector.subList(1, combinedSelector.size());
            SelectorImpl.PseudoElementImpl pseudo = (SelectorImpl.PseudoElementImpl)first;
            if (pseudo.hasStackedPseudoElement()) {
                combinedSelector = new ArrayList<Object>();
                Selector selector = (Selector)new SelectorImpl().unlock();
                selector.add((Object)pseudo.getStackedPseudoElement());
                combinedSelector.add(selector);
                combinedSelector.addAll(rest);
                newRule = new InlineStyle.RuleRelativeBlock(combinedSelector);
            } else {
                combinedSelector = pseudo.getCombinedSelectors();
                newRule = combinedSelector.isEmpty() ? new AbstractRuleBlock() : new InlineStyle.RuleRelativeBlock(combinedSelector);
            }
            newRule.replaceAll((List)rule);
            return newRule;
        }
        throw new RuntimeException("not implemented");
    }

    private static String elementToString(XMLInputValue<?> element) {
        XMLStreamWriterHelper.ToStringWriter xml = new XMLStreamWriterHelper.ToStringWriter(){
            int skipElement = 0;

            public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                if (this.skipElement > 0) {
                    ++this.skipElement;
                    return;
                }
                if (TableAsList.XMLNS_CSS.equals(namespaceURI)) {
                    ++this.skipElement;
                    return;
                }
                super.writeStartElement(prefix, localName, namespaceURI);
            }

            public void writeEndElement() throws XMLStreamException {
                if (this.skipElement > 0) {
                    --this.skipElement;
                    return;
                }
                super.writeEndElement();
            }

            public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
                if (this.skipElement > 0) {
                    return;
                }
                if (TableAsList.XMLNS_CSS.equals(namespaceURI)) {
                    return;
                }
                if ("style".equals(localName)) {
                    return;
                }
                super.writeAttribute(prefix, namespaceURI, localName, value);
            }

            public void writeCharacters(String text) throws XMLStreamException {
                if (this.skipElement > 0) {
                    return;
                }
                super.writeCharacters(text);
            }
        };
        BaseURIAwareXMLStreamReader r = element.asXMLStreamReader();
        try {
            if (r.next() != 1) {
                throw new IllegalArgumentException();
            }
            XMLStreamWriterHelper.writeElement((XMLStreamWriter)xml, (XMLStreamReader)r);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return xml.toString();
    }

    private static class WriteOnlyOnce
    extends ArrayList<XMLStreamWriterHelper.WriterEvent>
    implements XMLStreamWriterHelper.WriterEvent {
        private WriteOnlyOnce() {
        }

        public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((XMLStreamWriterHelper.WriterEvent)i.next()).writeTo(writer);
                i.remove();
            }
        }
    }

    private static class CellCoordinates {
        private final int row;
        private final int col;

        private CellCoordinates(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.col;
            result = 31 * result + this.row;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellCoordinates other = (CellCoordinates)obj;
            if (this.col != other.col) {
                return false;
            }
            return this.row == other.row;
        }
    }

    private static class TableCell {
        int rowGroup;
        int row;
        int col;
        CellType type = CellType.TD;
        RowType rowType = RowType.TBODY;
        HeaderPolicy headerPolicy = HeaderPolicy.ONCE;
        String id;
        List<String> headers;
        Scope scope = null;
        List<String> axis;
        int rowspan = 1;
        int colspan = 1;
        String ns;
        SimpleInlineStyle style = null;
        List<XMLStreamWriterHelper.WriterEvent> content = new ArrayList<XMLStreamWriterHelper.WriterEvent>();
        private AtomicReference<Boolean> written = new AtomicReference<Boolean>(false);

        private TableCell() {
        }

        public void write(XMLStreamWriter writer) throws XMLStreamException {
            String styleAttr;
            Iterator<String> it;
            StringBuilder s;
            writer.writeStartElement(this.ns, this.type == CellType.TD ? TableAsList.TD : TableAsList.TH);
            if (this.axis != null) {
                s = new StringBuilder();
                it = this.axis.iterator();
                while (it.hasNext()) {
                    s.append(it.next());
                    if (!it.hasNext()) continue;
                    s.append(",");
                }
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_AXIS, (String)s.toString());
            }
            if (this.id != null && !this.written.get().booleanValue()) {
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_ID, (String)this.id);
                this.written.set(true);
            }
            if (this.headers != null) {
                s = new StringBuilder();
                it = this.headers.iterator();
                while (it.hasNext()) {
                    s.append(it.next());
                    if (!it.hasNext()) continue;
                    s.append(" ");
                }
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_HEADERS, (String)s.toString());
            }
            if (this.style != null && (styleAttr = BrailleCssSerializer.toString(this.style)) != null && !"".equals(styleAttr)) {
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_STYLE, (String)styleAttr);
            }
            for (XMLStreamWriterHelper.WriterEvent action : this.content) {
                action.writeTo(writer);
            }
            writer.writeEndElement();
        }

        public TableCell clone() {
            TableCell clone = new TableCell();
            clone.rowGroup = this.rowGroup;
            clone.row = this.row;
            clone.col = this.col;
            clone.type = this.type;
            clone.rowType = this.rowType;
            clone.headerPolicy = this.headerPolicy;
            clone.id = this.id;
            clone.headers = this.headers;
            clone.scope = this.scope;
            clone.axis = this.axis;
            clone.rowspan = this.rowspan;
            clone.colspan = this.colspan;
            clone.ns = this.ns;
            clone.style = (SimpleInlineStyle)this.style.clone();
            clone.content.addAll(this.content);
            clone.written = this.written;
            return clone;
        }

        public String toString() {
            XMLStreamWriterHelper.ToStringWriter xml = new XMLStreamWriterHelper.ToStringWriter();
            try {
                this.write((XMLStreamWriter)xml);
            }
            catch (Exception e) {
                throw new RuntimeException("coding error", e);
            }
            StringBuilder s = new StringBuilder();
            s.append("TableCell{" + this.row + "," + this.col + "}[").append(xml).append("]");
            return s.toString();
        }

        static enum Scope {
            COL,
            ROW;

        }

        static enum HeaderPolicy {
            ALWAYS,
            ONCE,
            FRONT;

        }

        static enum RowType {
            THEAD,
            TBODY,
            TFOOT;

        }

        static enum CellType {
            TD,
            TH;

        }
    }

    private static class ListItemStyle
    extends PseudoElementStyle {
        public ListItemStyle() {
        }

        public ListItemStyle(RuleBlock<Rule<?>> ruleblock) {
            this.addRuleBlock(ruleblock);
        }

        public ListItemStyle mergeWith(ListItemStyle style) {
            for (RuleBlock r : style.ruleBlocks.values()) {
                this.addRuleBlock(r);
            }
            return this;
        }
    }

    private static class TableByStyle
    extends PseudoElementStyle {
        private final Map<List<Selector.PseudoClass>, ListItemStyle> listItemStyles = new LinkedHashMap<List<Selector.PseudoClass>, ListItemStyle>();
        private ListItemStyle listHeaderStyle = new ListItemStyle();

        public void addListItemStyle(List<Selector.PseudoClass> pseudo, ListItemStyle style) {
            if (!this.listItemStyles.containsKey(pseudo)) {
                this.listItemStyles.put(pseudo, style);
            } else {
                this.listItemStyles.put(pseudo, this.listItemStyles.get(pseudo).mergeWith(style));
            }
        }

        public void addListHeaderStyle(ListItemStyle style) {
            this.listHeaderStyle = this.listHeaderStyle.mergeWith(style);
        }

        public ListItemStyle getListItemStyle(Predicate<Selector.PseudoClass> matcher) {
            ListItemStyle style = new ListItemStyle();
            block0: for (List<Selector.PseudoClass> pseudoClasses : this.listItemStyles.keySet()) {
                for (Selector.PseudoClass pseudoClass : pseudoClasses) {
                    if (matcher.apply((Object)pseudoClass)) continue;
                    continue block0;
                }
                style = style.mergeWith(this.listItemStyles.get(pseudoClasses));
            }
            return style;
        }

        public ListItemStyle getListHeaderStyle() {
            return this.listHeaderStyle;
        }
    }

    private static class PseudoElementStyle {
        protected final Map<List<Selector>, RuleBlock<Rule<?>>> ruleBlocks = new HashMap();

        private PseudoElementStyle() {
        }

        public void addRuleBlock(RuleBlock<Rule<?>> ruleblock) {
            if (!ruleblock.isEmpty()) {
                InlineStyle.RuleRelativeBlock r;
                List selector = null;
                if (ruleblock instanceof InlineStyle.RuleRelativeBlock) {
                    selector = ((InlineStyle.RuleRelativeBlock)ruleblock).getSelector();
                }
                if (this.ruleBlocks.containsKey(selector)) {
                    r = this.ruleBlocks.get(selector);
                } else {
                    r = selector != null ? new InlineStyle.RuleRelativeBlock(selector) : new AbstractRuleBlock();
                    r.unlock();
                }
                r.addAll(ruleblock);
                this.ruleBlocks.put(selector, (RuleBlock<Rule<?>>)r);
            }
        }

        public boolean isEmpty() {
            return this.ruleBlocks.isEmpty();
        }

        public String toString() {
            return BrailleCssSerializer.serializeRuleBlockList(this.ruleBlocks.values());
        }
    }

    private class TableCellGroup
    extends TableCellCollection {
        private final TableCellGroup parent;
        private final TableCell groupingHeader;
        private final String groupingAxis;
        private final TableCellGroup precedingSibling;
        private final boolean hasSubGroups;
        private final String subGroupingAxis;
        private final List<TableCellCollection> children;
        private final boolean rowApplied;
        private final boolean columnAppliedBeforeRow;
        private List<TableCell> newlyAppliedHeaders;
        private List<TableCell> appliedHeaders;
        private List<TableCell> newlyDeferredHeaders;
        private List<TableCell> deferredHeaders;
        private List<TableCell> newlyRenderedOrPromotedHeaders;
        private List<TableCell> newlyPromotedHeaders;
        private List<TableCell> newlyRenderedHeaders;

        private TableCellGroup(List<TableCell> cells, Iterator<String> nextAxes) {
            this(cells, nextAxes, null, null, null, null, false, false);
        }

        private TableCellGroup(List<TableCell> cells, Iterator<String> nextAxes, TableCellGroup parent, TableCell groupingHeader, String groupingAxis, TableCellGroup precedingSibling, boolean rowApplied, boolean columnAppliedBeforeRow) {
            this.parent = parent;
            this.groupingHeader = groupingHeader;
            this.groupingAxis = groupingAxis;
            this.precedingSibling = precedingSibling;
            this.rowApplied = rowApplied;
            this.columnAppliedBeforeRow = columnAppliedBeforeRow;
            this.children = this.groupCellsBy(cells, nextAxes);
            this.hasSubGroups = !this.children.isEmpty() && this.children.get(0) instanceof TableCellGroup;
            this.subGroupingAxis = this.hasSubGroups ? ((TableCellGroup)this.children.get((int)0)).groupingAxis : null;
        }

        private List<TableCellCollection> groupCellsBy(List<TableCell> cells, Iterator<String> axes) {
            TableCellCollection transferChild;
            String firstAxis = axes.hasNext() ? axes.next() : null;
            ImmutableList nextAxes = ImmutableList.copyOf(axes);
            TableCellCollection tableCellCollection = transferChild = this.precedingSibling != null && this.precedingSibling.newlyAppliedHeaders().isEmpty() && this.newlyAppliedHeaders().isEmpty() ? this.precedingSibling.children.get(this.precedingSibling.children.size() - 1) : null;
            if (firstAxis != null) {
                ArrayList<TableCellCollection> children;
                LinkedHashMap<TableCell, ArrayList<TableCell>> categories = new LinkedHashMap<TableCell, ArrayList<TableCell>>();
                ArrayList<TableCell> uncategorized = null;
                for (TableCell c : cells) {
                    boolean categorized = false;
                    for (TableCell h : TableAsList.this.findHeaders(c, !this.columnAppliedBeforeRow)) {
                        if (h.axis == null || !h.axis.contains(firstAxis)) continue;
                        ArrayList<TableCell> category = (ArrayList<TableCell>)categories.get(h);
                        if (category == null) {
                            category = new ArrayList<TableCell>();
                            categories.put(h, category);
                        }
                        category.add(c);
                        categorized = true;
                    }
                    if (categorized) continue;
                    if (uncategorized == null) {
                        uncategorized = new ArrayList<TableCell>();
                    }
                    uncategorized.add(c);
                }
                if (!categories.isEmpty()) {
                    children = new ArrayList<TableCellCollection>();
                    TableCellGroup child = null;
                    if (transferChild instanceof TableCellGroup) {
                        child = (TableCellGroup)transferChild;
                    }
                    for (TableCell tableCell : categories.keySet()) {
                        child = new TableCellGroup((List)categories.get(tableCell), nextAxes.iterator(), this, tableCell, firstAxis, child, this.rowApplied, this.columnAppliedBeforeRow);
                        children.add(child);
                    }
                    if (uncategorized != null) {
                        child = new TableCellGroup(uncategorized, nextAxes.iterator(), this, null, firstAxis, child, this.rowApplied, this.columnAppliedBeforeRow);
                        children.add(child);
                    }
                    return children;
                }
                if ("row".equals(firstAxis)) {
                    children = new ArrayList();
                    LinkedHashMap<Integer, ArrayList<TableCell>> rows = new LinkedHashMap<Integer, ArrayList<TableCell>>();
                    for (TableCell tableCell : cells) {
                        ArrayList<TableCell> row = (ArrayList<TableCell>)rows.get(tableCell.row);
                        if (row == null) {
                            row = new ArrayList<TableCell>();
                            rows.put(tableCell.row, row);
                        }
                        row.add(tableCell);
                    }
                    TableCellGroup child = null;
                    if (transferChild instanceof TableCellGroup) {
                        child = (TableCellGroup)transferChild;
                    }
                    for (ArrayList<TableCell> row : rows.values()) {
                        child = new TableCellGroup(row, nextAxes.iterator(), this, null, firstAxis, child, true, this.columnAppliedBeforeRow);
                        children.add(child);
                    }
                    return children;
                }
                if ("column".equals(firstAxis) || TableAsList.COL.equals(firstAxis)) {
                    children = new ArrayList();
                    LinkedHashMap<Integer, ArrayList<TableCell>> columns = new LinkedHashMap<Integer, ArrayList<TableCell>>();
                    for (TableCell tableCell : cells) {
                        ArrayList<TableCell> column = (ArrayList<TableCell>)columns.get(tableCell.col);
                        if (column == null) {
                            column = new ArrayList<TableCell>();
                            columns.put(tableCell.col, column);
                        }
                        column.add(tableCell);
                    }
                    Object child = null;
                    if (transferChild instanceof TableCellGroup) {
                        child = (TableCellGroup)transferChild;
                    }
                    for (ArrayList<TableCell> column : columns.values()) {
                        child = new TableCellGroup(column, nextAxes.iterator(), this, null, firstAxis, (TableCellGroup)child, this.rowApplied, !this.rowApplied);
                        children.add((TableCellCollection)child);
                    }
                    return children;
                }
                if ("row-group".equals(firstAxis)) {
                    children = new ArrayList();
                    LinkedHashMap<Integer, ArrayList<TableCell>> rowGroups = new LinkedHashMap<Integer, ArrayList<TableCell>>();
                    for (TableCell tableCell : cells) {
                        ArrayList<TableCell> rowGroup = (ArrayList<TableCell>)rowGroups.get(tableCell.rowGroup);
                        if (rowGroup == null) {
                            rowGroup = new ArrayList<TableCell>();
                            rowGroups.put(tableCell.rowGroup, rowGroup);
                        }
                        rowGroup.add(tableCell);
                    }
                    Object child = null;
                    if (transferChild instanceof TableCellGroup) {
                        child = (TableCellGroup)transferChild;
                    }
                    for (ArrayList<TableCell> rowGroup : rowGroups.values()) {
                        child = new TableCellGroup(rowGroup, nextAxes.iterator(), this, null, firstAxis, (TableCellGroup)child, this.rowApplied, this.columnAppliedBeforeRow);
                        children.add((TableCellCollection)child);
                    }
                    return children;
                }
                return this.groupCellsBy(cells, nextAxes.iterator());
            }
            ArrayList<TableCellCollection> children = new ArrayList<TableCellCollection>();
            SingleTableCell child = null;
            if (transferChild instanceof SingleTableCell) {
                child = (SingleTableCell)transferChild;
            }
            for (TableCell c : cells) {
                child = new SingleTableCell(c, this, child, this.columnAppliedBeforeRow);
                children.add(child);
            }
            return children;
        }

        public List<TableCell> newlyAppliedHeaders() {
            if (this.newlyAppliedHeaders == null) {
                this.newlyAppliedHeaders = new ArrayList<TableCell>();
                if (this.groupingHeader != null) {
                    for (TableCell h : TableAsList.this.findHeaders(this.groupingHeader, !this.columnAppliedBeforeRow)) {
                        if (this.previouslyAppliedHeaders().contains(h)) continue;
                        this.newlyAppliedHeaders.add(h);
                    }
                }
            }
            return this.newlyAppliedHeaders;
        }

        private List<TableCell> previouslyAppliedHeaders() {
            if (this.parent != null) {
                return this.parent.appliedHeaders();
            }
            return emptyList;
        }

        public List<TableCell> appliedHeaders() {
            if (this.appliedHeaders == null) {
                this.appliedHeaders = new ArrayList<TableCell>();
                this.appliedHeaders.addAll(this.previouslyAppliedHeaders());
                this.appliedHeaders.addAll(this.newlyAppliedHeaders());
            }
            return this.appliedHeaders;
        }

        private List<TableCell> newlyDeferredHeaders() {
            if (this.newlyDeferredHeaders == null) {
                this.newlyDeferredHeaders = new ArrayList<TableCell>();
                int i = this.newlyAppliedHeaders().size() - 1;
                while (i >= 0 && this.newlyAppliedHeaders().get((int)i).headerPolicy == TableCell.HeaderPolicy.ALWAYS) {
                    this.newlyDeferredHeaders.add(0, this.newlyAppliedHeaders().get(i--));
                }
            }
            return this.newlyDeferredHeaders;
        }

        private List<TableCell> deferredHeaders() {
            if (this.deferredHeaders == null) {
                this.deferredHeaders = new ArrayList<TableCell>();
                if (this.newlyRenderedOrPromotedHeaders().isEmpty()) {
                    this.deferredHeaders.addAll(this.previouslyDeferredHeaders());
                }
                this.deferredHeaders.addAll(this.newlyDeferredHeaders());
            }
            return this.deferredHeaders;
        }

        private List<TableCell> previouslyDeferredHeaders() {
            if (this.parent != null) {
                return this.parent.deferredHeaders();
            }
            return emptyList;
        }

        private List<TableCell> newlyRenderedOrPromotedHeaders() {
            if (this.newlyRenderedOrPromotedHeaders == null) {
                int i;
                this.newlyRenderedOrPromotedHeaders = new ArrayList<TableCell>();
                for (i = this.newlyAppliedHeaders().size() - 1; i >= 0 && this.newlyAppliedHeaders().get((int)i).headerPolicy == TableCell.HeaderPolicy.ALWAYS; --i) {
                }
                if (i >= 0) {
                    Iterator lastAppliedHeaders = (this.precedingSibling != null ? this.precedingSibling.newlyAppliedHeaders() : emptyList).iterator();
                    boolean canOmit = true;
                    for (TableCell h : this.previouslyDeferredHeaders()) {
                        this.newlyRenderedOrPromotedHeaders.add(h);
                        canOmit = false;
                    }
                    for (int j = 0; j <= i; ++j) {
                        TableCell h;
                        h = this.newlyAppliedHeaders().get(j);
                        if (canOmit && h.headerPolicy != TableCell.HeaderPolicy.ALWAYS && lastAppliedHeaders.hasNext() && ((TableCell)lastAppliedHeaders.next()).equals(h)) continue;
                        this.newlyRenderedOrPromotedHeaders.add(h);
                        canOmit = false;
                    }
                }
            }
            return this.newlyRenderedOrPromotedHeaders;
        }

        @Override
        public List<TableCell> newlyPromotedHeaders() {
            if (this.newlyPromotedHeaders == null) {
                int i;
                this.newlyPromotedHeaders = new ArrayList<TableCell>();
                for (i = this.newlyRenderedOrPromotedHeaders().size() - 1; i >= 0 && this.newlyRenderedOrPromotedHeaders().get((int)i).headerPolicy != TableCell.HeaderPolicy.FRONT; --i) {
                }
                while (i >= 0) {
                    this.newlyPromotedHeaders.add(0, this.newlyRenderedOrPromotedHeaders().get(i--));
                }
            }
            return this.newlyPromotedHeaders;
        }

        @Override
        public List<TableCell> newlyRenderedHeaders() {
            if (this.newlyRenderedHeaders == null) {
                this.newlyRenderedHeaders = new ArrayList<TableCell>();
                int i = this.newlyRenderedOrPromotedHeaders().size() - 1;
                while (i >= 0 && this.newlyRenderedOrPromotedHeaders().get((int)i).headerPolicy != TableCell.HeaderPolicy.FRONT) {
                    this.newlyRenderedHeaders.add(0, this.newlyRenderedOrPromotedHeaders().get(i--));
                }
            }
            return this.newlyRenderedHeaders;
        }

        @Override
        public void write(XMLStreamWriter writer) {
            try {
                if (this.hasSubGroups) {
                    XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)CSS_TABLE_BY);
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_AXIS, (String)this.subGroupingAxis);
                    TableAsList.writeStyleAttribute(writer, TableAsList.this.getTableByStyle(this.subGroupingAxis));
                }
                ArrayList<List<TableCell>> promotedHeaders = null;
                int i = 0;
                for (TableCellCollection c : this.children) {
                    if (c instanceof TableCellGroup) {
                        TableCellGroup g = (TableCellGroup)c;
                        int j = 0;
                        for (TableCellCollection cc : g.children) {
                            if (!cc.newlyPromotedHeaders().isEmpty()) {
                                if (promotedHeaders == null) {
                                    if (i == 0 && j == 0) {
                                        XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)CSS_LIST_HEADER);
                                        TableAsList.writeStyleAttribute(writer, TableAsList.this.getTableByStyle(g.groupingAxis).getListHeaderStyle());
                                        if (g.hasSubGroups) {
                                            XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)CSS_TABLE_BY);
                                            XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_AXIS, (String)g.subGroupingAxis);
                                            TableAsList.writeStyleAttribute(writer, TableAsList.this.getTableByStyle(g.subGroupingAxis));
                                        }
                                        promotedHeaders = new ArrayList<List<TableCell>>();
                                    } else {
                                        throw new RuntimeException("Some headers of children promoted but not all children have a promoted header.");
                                    }
                                }
                                if (i == 0) {
                                    if (g.hasSubGroups) {
                                        XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)CSS_LIST_ITEM);
                                        Predicate matcher = TableAsList.matchesPosition(j + 1, g.children.size());
                                        TableAsList.writeStyleAttribute(writer, TableAsList.this.getTableByStyle(g.subGroupingAxis).getListItemStyle((Predicate<Selector.PseudoClass>)matcher));
                                    }
                                    for (TableCell h : cc.newlyPromotedHeaders()) {
                                        h.write(writer);
                                    }
                                    if (g.hasSubGroups) {
                                        writer.writeEndElement();
                                    }
                                    promotedHeaders.add(cc.newlyPromotedHeaders());
                                } else if (!((List)promotedHeaders.get(j)).equals(cc.newlyPromotedHeaders())) {
                                    throw new RuntimeException("Headers of children promoted but not the same as promoted headers of sibling groups.");
                                }
                            } else if (promotedHeaders != null) {
                                throw new RuntimeException("Some headers of children promoted but not all children have a promoted header.");
                            }
                            ++j;
                        }
                        if (promotedHeaders != null && promotedHeaders.size() != j) {
                            throw new RuntimeException("Headers of children promoted but not the same as promoted headers of sibling groups.");
                        }
                    } else if (promotedHeaders != null) {
                        throw new RuntimeException("Coding error");
                    }
                    ++i;
                }
                if (promotedHeaders != null) {
                    if (((TableCellGroup)this.children.get((int)0)).hasSubGroups) {
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                i = 0;
                for (TableCellCollection c : this.children) {
                    if (this.hasSubGroups) {
                        XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)CSS_LIST_ITEM);
                        Predicate matcher = TableAsList.matchesPosition(i + 1, this.children.size());
                        TableAsList.writeStyleAttribute(writer, TableAsList.this.getTableByStyle(this.subGroupingAxis).getListItemStyle((Predicate<Selector.PseudoClass>)matcher));
                    }
                    for (TableCell h : c.newlyRenderedHeaders()) {
                        h.write(writer);
                    }
                    c.write(writer);
                    if (this.hasSubGroups) {
                        writer.writeEndElement();
                    }
                    ++i;
                }
                if (this.hasSubGroups) {
                    writer.writeEndElement();
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            XMLStreamWriterHelper.ToStringWriter xml = new XMLStreamWriterHelper.ToStringWriter();
            this.write((XMLStreamWriter)xml);
            StringBuilder s = new StringBuilder();
            s.append("TableCellGroup[header: ").append(this.newlyRenderedHeaders());
            s.append(", children: ").append(this.children);
            s.append(", xml: ").append(xml).append("]");
            return s.toString();
        }
    }

    private class SingleTableCell
    extends TableCellCollection {
        private final TableCell cell;
        private final TableCellGroup parent;
        private final SingleTableCell precedingSibling;
        private final boolean columnAppliedBeforeRow;
        private List<TableCell> newlyAppliedHeaders;
        private List<TableCell> newlyRenderedOrPromotedHeaders;
        private List<TableCell> newlyPromotedHeaders;
        private List<TableCell> newlyRenderedHeaders;

        private SingleTableCell(TableCell cell, TableCellGroup parent, SingleTableCell precedingSibling, boolean columnAppliedBeforeRow) {
            this.cell = cell;
            this.parent = parent;
            this.precedingSibling = precedingSibling;
            this.columnAppliedBeforeRow = columnAppliedBeforeRow;
        }

        public List<TableCell> newlyAppliedHeaders() {
            if (this.newlyAppliedHeaders == null) {
                this.newlyAppliedHeaders = new ArrayList<TableCell>();
                for (TableCell h : TableAsList.this.findHeaders(this.cell, !this.columnAppliedBeforeRow)) {
                    if (this.parent.appliedHeaders().contains(h)) continue;
                    this.newlyAppliedHeaders.add(h);
                }
            }
            return this.newlyAppliedHeaders;
        }

        private List<TableCell> newlyRenderedOrPromotedHeaders() {
            if (this.newlyRenderedOrPromotedHeaders == null) {
                this.newlyRenderedOrPromotedHeaders = new ArrayList<TableCell>();
                Iterator lastAppliedHeaders = (this.precedingSibling != null ? this.precedingSibling.newlyAppliedHeaders() : emptyList).iterator();
                boolean canOmit = true;
                for (TableCell h : this.parent.deferredHeaders()) {
                    this.newlyRenderedOrPromotedHeaders.add(h);
                    canOmit = false;
                }
                for (TableCell h : this.newlyAppliedHeaders()) {
                    if (canOmit && h.headerPolicy != TableCell.HeaderPolicy.ALWAYS && lastAppliedHeaders.hasNext() && ((TableCell)lastAppliedHeaders.next()).equals(h)) continue;
                    this.newlyRenderedOrPromotedHeaders.add(h);
                    canOmit = false;
                }
            }
            return this.newlyRenderedOrPromotedHeaders;
        }

        @Override
        public List<TableCell> newlyPromotedHeaders() {
            if (this.newlyPromotedHeaders == null) {
                int i;
                this.newlyPromotedHeaders = new ArrayList<TableCell>();
                for (i = this.newlyRenderedOrPromotedHeaders().size() - 1; i >= 0 && this.newlyRenderedOrPromotedHeaders().get((int)i).headerPolicy != TableCell.HeaderPolicy.FRONT; --i) {
                }
                while (i >= 0) {
                    this.newlyPromotedHeaders.add(0, this.newlyRenderedOrPromotedHeaders().get(i--));
                }
            }
            return this.newlyPromotedHeaders;
        }

        @Override
        public List<TableCell> newlyRenderedHeaders() {
            if (this.newlyRenderedHeaders == null) {
                this.newlyRenderedHeaders = new ArrayList<TableCell>();
                int i = this.newlyRenderedOrPromotedHeaders().size() - 1;
                while (i >= 0 && this.newlyRenderedOrPromotedHeaders().get((int)i).headerPolicy != TableCell.HeaderPolicy.FRONT) {
                    this.newlyRenderedHeaders.add(0, this.newlyRenderedOrPromotedHeaders().get(i--));
                }
            }
            return this.newlyRenderedHeaders;
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            this.cell.write(writer);
        }

        public String toString() {
            XMLStreamWriterHelper.ToStringWriter xml = new XMLStreamWriterHelper.ToStringWriter();
            try {
                this.write((XMLStreamWriter)xml);
            }
            catch (Exception e) {
                throw new RuntimeException("coding error", e);
            }
            StringBuilder s = new StringBuilder();
            s.append("SingleTableCell[header: ").append(this.newlyRenderedHeaders());
            s.append(", cell: ").append(this.cell);
            s.append(", xml: ").append(xml).append("]");
            return s.toString();
        }
    }

    private abstract class TableCellCollection {
        private TableCellCollection() {
        }

        public abstract List<TableCell> newlyRenderedHeaders();

        public abstract List<TableCell> newlyPromotedHeaders();

        public abstract void write(XMLStreamWriter var1) throws XMLStreamException;
    }
}

