/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.csskit.RuleFactoryImpl;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import cz.vutbr.web.domassign.DeclarationTransformer;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.daisy.braille.css.AnyAtRule;
import org.daisy.braille.css.BrailleCSSDeclarationTransformer;
import org.daisy.braille.css.BrailleCSSParserFactory;
import org.daisy.braille.css.BrailleCSSProperty;
import org.daisy.braille.css.BrailleCSSRuleFactory;
import org.daisy.braille.css.RuleCounterStyle;
import org.daisy.braille.css.RuleTextTransform;
import org.daisy.braille.css.RuleVolume;
import org.daisy.braille.css.RuleVolumeArea;
import org.daisy.braille.css.SelectorImpl;
import org.daisy.braille.css.SimpleInlineStyle;
import org.daisy.braille.css.SupportedBrailleCSS;
import org.daisy.common.file.URLs;
import org.daisy.common.transform.XMLTransformer;
import org.daisy.pipeline.braille.css.SupportedPrintCSS;
import org.daisy.pipeline.braille.css.impl.BrailleCssSerializer;
import org.daisy.pipeline.css.CssCascader;
import org.daisy.pipeline.css.CssPreProcessor;
import org.daisy.pipeline.css.JStyleParserCssCascader;
import org.daisy.pipeline.css.Medium;
import org.daisy.pipeline.css.XsltProcessor;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Element;

@Component(name="BrailleCssCascader", service={CssCascader.class})
public class BrailleCssCascader
implements CssCascader {
    private static final SupportedCSS printCSS = SupportedPrintCSS.getInstance();
    private static DeclarationTransformer printDeclarationTransformer = new DeclarationTransformer(printCSS);
    private static final RuleFactory printRuleFactory = RuleFactoryImpl.getInstance();
    private static final CSSParserFactory printParserFactory = CSSParserFactory.getInstance();
    private static final SupportedCSS brailleCSS = new SupportedBrailleCSS(false, true);
    private static DeclarationTransformer brailleDeclarationTransformer = new BrailleCSSDeclarationTransformer(brailleCSS);
    private static final RuleFactory brailleRuleFactory = new BrailleCSSRuleFactory();
    private static final CSSParserFactory brailleParserFactory = new BrailleCSSParserFactory();
    private static Comparator<Selector.PseudoElement> pseudoElementComparator = new Comparator<Selector.PseudoElement>(){

        @Override
        public int compare(Selector.PseudoElement e1, Selector.PseudoElement e2) {
            return e1.toString().compareTo(e2.toString());
        }
    };
    private static final Pattern FUNCTION = Pattern.compile("(nth|nth-last)\\(([1-9][0-9]*)\\)");

    public boolean supportsMedium(Medium medium) {
        switch (medium.getType()) {
            case EMBOSSED: 
            case PRINT: {
                return true;
            }
        }
        return false;
    }

    public XMLTransformer newInstance(Medium medium, String defaultStylesheet, URIResolver uriResolver, CssPreProcessor preProcessor, XsltProcessor xsltProcessor, QName attributeName) {
        switch (medium.getType()) {
            case EMBOSSED: {
                return new Transformer(uriResolver, preProcessor, xsltProcessor, defaultStylesheet, medium, attributeName, brailleParserFactory, brailleRuleFactory, brailleCSS, brailleDeclarationTransformer);
            }
            case PRINT: {
                return new Transformer(uriResolver, preProcessor, xsltProcessor, defaultStylesheet, medium, attributeName, printParserFactory, printRuleFactory, printCSS, printDeclarationTransformer);
            }
        }
        throw new IllegalArgumentException("medium not supported: " + medium);
    }

    private static <T extends Comparable<? super T>> Iterable<T> sort(Iterable<T> iterable) {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        for (Comparable x : iterable) {
            list.add(x);
        }
        Collections.sort(list);
        return list;
    }

    private static <T> Iterable<T> sort(Iterable<T> iterable, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>();
        for (T x : iterable) {
            list.add(x);
        }
        Collections.sort(list, comparator);
        return list;
    }

    private static void insertStyle(StringBuilder builder, NodeData nodeData) {
        ArrayList keys = new ArrayList(nodeData.getPropertyNames());
        keys.remove("page");
        Collections.sort(keys);
        for (String key : keys) {
            builder.append(key).append(": ");
            Term value = nodeData.getValue(key, true);
            if (value != null) {
                builder.append(BrailleCssSerializer.toString(value));
            } else {
                CSSProperty prop = nodeData.getProperty(key);
                builder.append(prop);
            }
            builder.append("; ");
        }
    }

    private static void pseudoElementToString(StringBuilder builder, Selector.PseudoElement elem) {
        if (elem instanceof SelectorImpl.PseudoElementImpl) {
            builder.append("&").append(elem);
            return;
        }
        builder.append("&::").append(elem.getName());
        String[] args = elem.getArguments();
        if (args.length > 0) {
            StringBuilder s = new StringBuilder();
            Iterator<String> it = Arrays.asList(args).iterator();
            while (it.hasNext()) {
                s.append(it.next());
                if (!it.hasNext()) continue;
                s.append(", ");
            }
            builder.append("(").append((CharSequence)s).append(")");
        }
    }

    private static void insertPseudoStyle(StringBuilder builder, NodeData nodeData, Selector.PseudoElement elem, Map<String, Map<String, RulePage>> pageRules) {
        BrailleCssCascader.pseudoElementToString(builder, elem);
        builder.append(" { ");
        BrailleCssCascader.insertStyle(builder, nodeData);
        Map<String, RulePage> pageRule = BrailleCssCascader.getPageRule(nodeData, pageRules);
        if (pageRule != null) {
            BrailleCssCascader.insertPageStyle(builder, pageRule, false);
        }
        builder.append("} ");
    }

    private static void insertPageStyle(StringBuilder builder, Map<String, RulePage> pageRule, boolean topLevel) {
        for (RulePage r : pageRule.values()) {
            BrailleCssCascader.insertPageStyle(builder, r, topLevel);
        }
    }

    private static void insertPageStyle(StringBuilder builder, RulePage pageRule, boolean topLevel) {
        builder.append("@page");
        String pseudo = pageRule.getPseudo();
        if (pseudo != null && !"".equals(pseudo)) {
            builder.append(":").append(pseudo);
        }
        builder.append(" { ");
        for (Declaration decl : Iterables.filter((Iterable)pageRule, Declaration.class)) {
            BrailleCssCascader.insertDeclaration(builder, decl);
        }
        for (RuleMargin margin : Iterables.filter((Iterable)pageRule, RuleMargin.class)) {
            BrailleCssCascader.insertMarginStyle(builder, margin);
        }
        builder.append("} ");
    }

    private static void insertMarginStyle(StringBuilder builder, RuleMargin ruleMargin) {
        builder.append("@").append(ruleMargin.getMarginArea()).append(" { ");
        BrailleCssCascader.insertStyle(builder, (NodeData)new SimpleInlineStyle((List)ruleMargin, null, brailleDeclarationTransformer, brailleCSS));
        builder.append("} ");
    }

    private static void insertDeclaration(StringBuilder builder, Declaration decl) {
        StringBuilder s = new StringBuilder();
        Iterator it = decl.iterator();
        while (it.hasNext()) {
            s.append(BrailleCssSerializer.toString((Term)it.next()));
            if (!it.hasNext()) continue;
            s.append(" ");
        }
        builder.append(decl.getProperty()).append(": ").append((CharSequence)s).append("; ");
    }

    private static Map<String, RulePage> getPageRule(NodeData nodeData, Map<String, Map<String, RulePage>> pageRules) {
        BrailleCSSProperty.Page pageProperty = nodeData != null ? (BrailleCSSProperty.Page)nodeData.getProperty("page", false) : null;
        String name = pageProperty != null ? (pageProperty == BrailleCSSProperty.Page.identifier ? (String)((TermIdent)nodeData.getValue(TermIdent.class, "page", false)).getValue() : pageProperty.toString()) : null;
        if (name != null) {
            return BrailleCssCascader.getPageRule(name, pageRules);
        }
        return null;
    }

    private static Map<String, RulePage> getPageRule(String name, Map<String, Map<String, RulePage>> pageRules) {
        Map<String, RulePage> auto = pageRules == null ? null : pageRules.get("auto");
        Map<String, RulePage> named = null;
        if (!name.equals("auto")) {
            named = pageRules.get(name);
        }
        HashMap<String, RulePage> result = new HashMap<String, RulePage>();
        HashSet<String> pseudos = new HashSet<String>();
        if (named != null) {
            pseudos.addAll(named.keySet());
        }
        if (auto != null) {
            pseudos.addAll(auto.keySet());
        }
        for (String pseudo : pseudos) {
            RulePage r;
            boolean noPseudo = "".equals(pseudo);
            ArrayList<RulePage> from = new ArrayList<RulePage>();
            if (named != null) {
                r = named.get(pseudo);
                if (r != null) {
                    from.add(r);
                }
                if (!noPseudo && (r = named.get("")) != null) {
                    from.add(r);
                }
            }
            if (auto != null) {
                r = auto.get(pseudo);
                if (r != null) {
                    from.add(r);
                }
                if (!noPseudo && (r = auto.get("")) != null) {
                    from.add(r);
                }
            }
            result.put(pseudo, BrailleCssCascader.makePageRule(name, noPseudo ? null : pseudo, from));
        }
        return result;
    }

    private static RulePage makePageRule(String name, String pseudo, List<RulePage> from) {
        RulePage pageRule = brailleRuleFactory.createPage().setName(name).setPseudo(pseudo);
        for (RulePage f : from) {
            for (Rule r : f) {
                if (r instanceof Declaration) {
                    Declaration d = (Declaration)r;
                    String property = d.getProperty();
                    if (BrailleCssCascader.getDeclaration(pageRule, property) != null) continue;
                    pageRule.add((Object)r);
                    continue;
                }
                if (!(r instanceof RuleMargin)) continue;
                RuleMargin m = (RuleMargin)r;
                String marginArea = m.getMarginArea();
                RuleMargin marginRule = BrailleCssCascader.getRuleMargin(pageRule, marginArea);
                if (marginRule == null) {
                    marginRule = brailleRuleFactory.createMargin(marginArea);
                    pageRule.add((Object)marginRule);
                    marginRule.replaceAll((List)m);
                    continue;
                }
                for (Declaration d : m) {
                    if (BrailleCssCascader.getDeclaration(marginRule, d.getProperty()) != null) continue;
                    marginRule.add((Object)d);
                }
            }
        }
        return pageRule;
    }

    private static Declaration getDeclaration(Collection<? extends Rule<?>> rule, String property) {
        for (Declaration d : Iterables.filter(rule, Declaration.class)) {
            if (!d.getProperty().equals(property)) continue;
            return d;
        }
        return null;
    }

    private static RuleMargin getRuleMargin(Collection<? extends Rule<?>> rule, String marginArea) {
        for (RuleMargin m : Iterables.filter(rule, RuleMargin.class)) {
            if (!m.getMarginArea().equals(marginArea)) continue;
            return m;
        }
        return null;
    }

    private static void insertVolumeStyle(StringBuilder builder, Map<String, RuleVolume> volumeRule, Map<String, Map<String, RulePage>> pageRules) {
        for (Map.Entry<String, RuleVolume> r : volumeRule.entrySet()) {
            BrailleCssCascader.insertVolumeStyle(builder, r, pageRules);
        }
    }

    private static void insertVolumeStyle(StringBuilder builder, Map.Entry<String, RuleVolume> volumeRule, Map<String, Map<String, RulePage>> pageRules) {
        builder.append("@volume");
        String pseudo = volumeRule.getKey();
        if (pseudo != null && !"".equals(pseudo)) {
            builder.append(":").append(pseudo);
        }
        builder.append(" { ");
        for (Declaration decl : Iterables.filter((Iterable)((Iterable)volumeRule.getValue()), Declaration.class)) {
            BrailleCssCascader.insertDeclaration(builder, decl);
        }
        for (RuleVolumeArea volumeArea : Iterables.filter((Iterable)((Iterable)volumeRule.getValue()), RuleVolumeArea.class)) {
            BrailleCssCascader.insertVolumeAreaStyle(builder, volumeArea, pageRules);
        }
        builder.append("} ");
    }

    private static void insertVolumeAreaStyle(StringBuilder builder, RuleVolumeArea ruleVolumeArea, Map<String, Map<String, RulePage>> pageRules) {
        builder.append("@").append(ruleVolumeArea.getVolumeArea().value).append(" { ");
        StringBuilder innerStyle = new StringBuilder();
        Map<String, RulePage> pageRule = null;
        for (Declaration decl : Iterables.filter((Iterable)ruleVolumeArea, Declaration.class)) {
            if ("page".equals(decl.getProperty())) {
                StringBuilder s = new StringBuilder();
                Iterator it = decl.iterator();
                while (it.hasNext()) {
                    s.append(BrailleCssSerializer.toString((Term)it.next()));
                    if (!it.hasNext()) continue;
                    s.append(" ");
                }
                pageRule = BrailleCssCascader.getPageRule(s.toString(), pageRules);
                continue;
            }
            BrailleCssCascader.insertDeclaration(innerStyle, decl);
        }
        if (pageRule != null) {
            BrailleCssCascader.insertPageStyle(innerStyle, pageRule, false);
        }
        builder.append((CharSequence)innerStyle).append("} ");
    }

    private static void insertTextTransformDefinition(StringBuilder builder, RuleTextTransform rule) {
        builder.append("@text-transform");
        String name = rule.getName();
        if (name != null) {
            builder.append(' ').append(name);
        }
        builder.append(" { ");
        for (Declaration decl : rule) {
            if (decl.size() == 1 && decl.get(0) instanceof TermURI) {
                TermURI term = (TermURI)decl.get(0);
                URI uri = URLs.asURI((String)((String)term.getValue()));
                if (!uri.isAbsolute() && !uri.getSchemeSpecificPart().startsWith("/")) {
                    if (term.getBase() != null) {
                        uri = URLs.resolve((URI)URLs.asURI((URL)term.getBase()), (URI)uri);
                    }
                    try {
                        new File(uri);
                        try {
                            uri = new URI("volatile-file", uri.getSchemeSpecificPart(), uri.getFragment());
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                builder.append(decl.getProperty()).append(": ").append("url(\"" + uri + "\")").append("; ");
                continue;
            }
            BrailleCssCascader.insertDeclaration(builder, decl);
        }
        builder.append("} ");
    }

    private static void insertCounterStyleDefinition(StringBuilder builder, RuleCounterStyle rule) {
        String name = rule.getName();
        builder.append("@counter-style ").append(name).append(" { ");
        for (Declaration decl : rule) {
            BrailleCssCascader.insertDeclaration(builder, decl);
        }
        builder.append("} ");
    }

    private static void insertAtRule(StringBuilder builder, AnyAtRule rule) {
        builder.append("@").append(rule.getName()).append(" { ");
        for (Declaration decl : Iterables.filter((Iterable)rule, Declaration.class)) {
            BrailleCssCascader.insertDeclaration(builder, decl);
        }
        for (AnyAtRule r : Iterables.filter((Iterable)rule, AnyAtRule.class)) {
            BrailleCssCascader.insertAtRule(builder, r);
        }
        builder.append("} ");
    }

    private static Map<String, RuleVolume> getVolumeRule(String name, Map<String, Map<String, RuleVolume>> volumeRules) {
        Map<String, RuleVolume> auto = volumeRules.get("auto");
        Map<String, RuleVolume> named = null;
        if (!name.equals("auto")) {
            named = volumeRules.get(name);
        }
        HashMap<String, RuleVolume> result = new HashMap<String, RuleVolume>();
        HashSet<String> pseudos = new HashSet<String>();
        if (named != null) {
            pseudos.addAll(named.keySet());
        }
        if (auto != null) {
            pseudos.addAll(auto.keySet());
        }
        if (pseudos.contains("first") && pseudos.contains("last")) {
            pseudos.add("only");
        }
        for (String pseudo : pseudos) {
            RuleVolume r;
            ArrayList<RuleVolume> from = new ArrayList<RuleVolume>();
            if (named != null) {
                r = named.get(pseudo);
                if (r != null) {
                    from.add(r);
                }
                if ("only".equals(pseudo)) {
                    r = named.get("first");
                    if (r != null) {
                        from.add(r);
                    }
                    if ((r = named.get("last")) != null) {
                        from.add(r);
                    }
                }
                if (!"".equals(pseudo) && (r = named.get("")) != null) {
                    from.add(r);
                }
            }
            if (auto != null) {
                r = auto.get(pseudo);
                if (r != null) {
                    from.add(r);
                }
                if ("only".equals(pseudo)) {
                    r = auto.get("first");
                    if (r != null) {
                        from.add(r);
                    }
                    if ((r = auto.get("last")) != null) {
                        from.add(r);
                    }
                }
                if (!"".equals(pseudo) && (r = auto.get("")) != null) {
                    from.add(r);
                }
            }
            result.put(pseudo, BrailleCssCascader.makeVolumeRule("".equals(pseudo) || "only".equals(pseudo) ? null : pseudo, from));
        }
        return result;
    }

    private static RuleVolume makeVolumeRule(String pseudo, List<RuleVolume> from) {
        Matcher m;
        String arg = null;
        if (pseudo != null && (m = FUNCTION.matcher(pseudo)).matches()) {
            pseudo = m.group(1);
            arg = m.group(2);
        }
        RuleVolume volumeRule = new RuleVolume(pseudo, arg);
        for (RuleVolume f : from) {
            for (Rule r : f) {
                if (r instanceof Declaration) {
                    Declaration d = (Declaration)r;
                    String property = d.getProperty();
                    if (BrailleCssCascader.getDeclaration(volumeRule, property) != null) continue;
                    volumeRule.add(r);
                    continue;
                }
                if (!(r instanceof RuleVolumeArea)) continue;
                RuleVolumeArea a = (RuleVolumeArea)r;
                String volumeArea = a.getVolumeArea().value;
                RuleVolumeArea volumeAreaRule = BrailleCssCascader.getRuleVolumeArea(volumeRule, volumeArea);
                if (volumeAreaRule == null) {
                    volumeAreaRule = new RuleVolumeArea(volumeArea);
                    volumeRule.add((Rule)volumeAreaRule);
                    volumeAreaRule.replaceAll((List)a);
                    continue;
                }
                for (Declaration d : Iterables.filter((Iterable)a, Declaration.class)) {
                    if (BrailleCssCascader.getDeclaration(volumeAreaRule, d.getProperty()) != null) continue;
                    volumeAreaRule.add((Rule)d);
                }
            }
        }
        return volumeRule;
    }

    private static RuleVolumeArea getRuleVolumeArea(Collection<? extends Rule<?>> rule, String volumeArea) {
        for (RuleVolumeArea m : Iterables.filter(rule, RuleVolumeArea.class)) {
            if (!m.getVolumeArea().value.equals(volumeArea)) continue;
            return m;
        }
        return null;
    }

    private static class Transformer
    extends JStyleParserCssCascader {
        private final boolean isBrailleCss;
        private Map<String, Map<String, RulePage>> pageRules = null;
        private Map<String, Map<String, RuleVolume>> volumeRules = null;
        private Iterable<RuleTextTransform> textTransformRules = null;
        private Iterable<RuleCounterStyle> counterStyleRules = null;
        private Iterable<AnyAtRule> otherAtRules = null;

        private Transformer(URIResolver resolver, CssPreProcessor preProcessor, XsltProcessor xsltProcessor, String defaultStyleSheet, Medium medium, QName attributeName, CSSParserFactory parserFactory, RuleFactory ruleFactory, SupportedCSS supportedCss, DeclarationTransformer declarationTransformer) {
            super(resolver, preProcessor, xsltProcessor, defaultStyleSheet, medium, attributeName, parserFactory, ruleFactory, supportedCss, declarationTransformer);
            this.isBrailleCss = medium.getType() == Medium.Type.EMBOSSED;
        }

        /*
         * WARNING - void declaration
         */
        protected String serializeStyle(NodeData mainStyle, Map<Selector.PseudoElement, NodeData> pseudoStyles, Element context) {
            if (this.isBrailleCss && this.pageRules == null) {
                String pseudo;
                String name;
                StyleSheet styleSheet = this.getParsedStyleSheet();
                this.pageRules = new HashMap<String, Map<String, RulePage>>();
                for (RulePage r : Iterables.filter((Iterable)styleSheet, RulePage.class)) {
                    void var9_10;
                    name = (String)MoreObjects.firstNonNull((Object)r.getName(), (Object)"auto");
                    pseudo = (String)MoreObjects.firstNonNull((Object)r.getPseudo(), (Object)"");
                    Map<String, RulePage> map = this.pageRules.get(name);
                    if (map == null) {
                        HashMap hashMap = new HashMap();
                        this.pageRules.put(name, hashMap);
                    }
                    if (var9_10.containsKey(pseudo)) {
                        var9_10.put(pseudo, BrailleCssCascader.makePageRule(name, "".equals(pseudo) ? null : pseudo, (List)ImmutableList.of((Object)r, var9_10.get(pseudo))));
                        continue;
                    }
                    var9_10.put(pseudo, r);
                }
                this.volumeRules = new HashMap<String, Map<String, RuleVolume>>();
                for (RulePage r : Iterables.filter((Iterable)styleSheet, RuleVolume.class)) {
                    void var9_16;
                    name = "auto";
                    pseudo = (String)MoreObjects.firstNonNull((Object)r.getPseudo(), (Object)"");
                    if (pseudo.equals("nth(1)")) {
                        pseudo = "first";
                    } else if (pseudo.equals("nth-last(1)")) {
                        pseudo = "last";
                    }
                    Map<String, RuleVolume> map = this.volumeRules.get(name);
                    if (map == null) {
                        HashMap hashMap = new HashMap();
                        this.volumeRules.put(name, hashMap);
                    }
                    if (var9_16.containsKey(pseudo)) {
                        var9_16.put(pseudo, BrailleCssCascader.makeVolumeRule("".equals(pseudo) ? null : pseudo, (List)ImmutableList.of((Object)r, var9_16.get(pseudo))));
                        continue;
                    }
                    var9_16.put(pseudo, r);
                }
                this.textTransformRules = Iterables.filter((Iterable)styleSheet, RuleTextTransform.class);
                this.counterStyleRules = Iterables.filter((Iterable)styleSheet, RuleCounterStyle.class);
                this.otherAtRules = Iterables.filter((Iterable)styleSheet, AnyAtRule.class);
            }
            StringBuilder style = new StringBuilder();
            if (mainStyle != null) {
                BrailleCssCascader.insertStyle(style, mainStyle);
            }
            for (Selector.PseudoElement pseudo : BrailleCssCascader.sort(pseudoStyles.keySet(), pseudoElementComparator)) {
                NodeData nd = pseudoStyles.get(pseudo);
                if (nd == null) continue;
                BrailleCssCascader.insertPseudoStyle(style, nd, pseudo, this.pageRules);
            }
            if (this.isBrailleCss) {
                boolean isRoot = context.getParentNode().getNodeType() != 1;
                Map pageRule = BrailleCssCascader.getPageRule(mainStyle, (Map<String, Map<String, RulePage>>)this.pageRules);
                if (pageRule != null) {
                    BrailleCssCascader.insertPageStyle(style, pageRule, true);
                } else if (isRoot && (pageRule = BrailleCssCascader.getPageRule("auto", (Map<String, Map<String, RulePage>>)this.pageRules)) != null) {
                    BrailleCssCascader.insertPageStyle(style, pageRule, true);
                }
                if (isRoot) {
                    Map volumeRule = BrailleCssCascader.getVolumeRule("auto", this.volumeRules);
                    if (volumeRule != null) {
                        BrailleCssCascader.insertVolumeStyle(style, volumeRule, (Map<String, Map<String, RulePage>>)this.pageRules);
                    }
                    for (RuleTextTransform ruleTextTransform : this.textTransformRules) {
                        BrailleCssCascader.insertTextTransformDefinition(style, ruleTextTransform);
                    }
                    for (RuleCounterStyle ruleCounterStyle : this.counterStyleRules) {
                        BrailleCssCascader.insertCounterStyleDefinition(style, ruleCounterStyle);
                    }
                    for (AnyAtRule anyAtRule : this.otherAtRules) {
                        if (style.length() > 0 && !style.toString().endsWith("} ")) {
                            style.insert(0, "{ ");
                            style.append("} ");
                        }
                        BrailleCssCascader.insertAtRule(style, anyAtRule);
                    }
                }
            }
            if (!style.toString().replaceAll("\\s+", "").isEmpty()) {
                return style.toString().trim();
            }
            return null;
        }

        protected String serializeValue(Term<?> value) {
            return BrailleCssSerializer.toString(value);
        }
    }
}

