/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xslt;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.URIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltTransformer;

public class ThreadUnsafeXslTransformer {
    private XsltTransformer transformer;

    public ThreadUnsafeXslTransformer(XsltTransformer transformer) {
        this.transformer = transformer;
    }

    public XdmNode transform(XdmNode xml) throws SaxonApiException {
        return this.transform(xml, null);
    }

    public String transformToString(XdmNode xml) throws SaxonApiException {
        return this.transformToString(xml, null);
    }

    public XdmNode transform(XdmNode xml, Map<String, Object> parameters) throws SaxonApiException {
        XdmDestination dest = new XdmDestination();
        this.genericTransform(xml, parameters, (Destination)dest);
        return dest.getXdmNode();
    }

    public String transformToString(XdmNode xml, Map<String, Object> parameters) throws SaxonApiException {
        Serializer dest = new Serializer();
        StringWriter sw = new StringWriter();
        dest.setOutputWriter((Writer)sw);
        this.genericTransform(xml, parameters, (Destination)dest);
        return sw.toString();
    }

    public void genericTransform(XdmNode input, Map<String, Object> parameters, Destination dest) throws SaxonApiException {
        if (parameters != null) {
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                this.transformer.setParameter(new QName(null, param.getKey()), (XdmValue)new XdmAtomicValue(param.getValue().toString()));
            }
        }
        this.transformer.setSource(input.asSource());
        this.transformer.setDestination(dest);
        this.transformer.transform();
        if (parameters != null) {
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                this.transformer.setParameter(new QName(null, param.getKey()), null);
            }
        }
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.transformer.setURIResolver(uriResolver);
    }
}

