/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.properties;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.daisy.common.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTracker {
    private HashMap<String, HashMap<String, Property>> propertiesIndex = new HashMap();
    private LinkedList<Property> properties = new LinkedList();
    private static Logger logger = LoggerFactory.getLogger((String)PropertyTracker.class.getName());

    public void activate() {
        logger.debug("Property tracker up");
    }

    public void deactivate() {
        logger.debug("Property tracker down");
    }

    public Collection<Property> getProperties() {
        return ImmutableList.copyOf(this.properties);
    }

    public Collection<Property> getProperties(String propertyName) {
        if (this.propertiesIndex.containsKey(propertyName)) {
            return ImmutableList.copyOf(this.propertiesIndex.get(propertyName).values());
        }
        logger.warn(String.format("Trying to get a property with no values %s=>null empty list returned", propertyName));
        return ImmutableList.copyOf(new LinkedList());
    }

    public Property getProperty(String propertyName, String bundleName) {
        if (this.propertiesIndex.containsKey(propertyName) && this.propertiesIndex.get(propertyName).containsKey(bundleName)) {
            return this.propertiesIndex.get(propertyName).get(bundleName);
        }
        logger.warn(String.format("Trying to access to a non exisiting property: %s=>%s=>null", propertyName, bundleName));
        return null;
    }

    public void addProperty(Property prop) {
        if (!this.propertiesIndex.containsKey(prop.getPropertyName())) {
            this.propertiesIndex.put(prop.getPropertyName(), new HashMap());
        }
        this.propertiesIndex.get(prop.getPropertyName()).put(prop.getBundleName(), prop);
        this.properties.add(prop);
        logger.debug(String.format("property tracked: %s", prop.toString()));
    }

    public void deleteProperty(Property prop) {
        String propName = prop.getPropertyName();
        String bundle = prop.getBundleName();
        if (this.propertiesIndex.containsKey(propName)) {
            if (this.propertiesIndex.get(propName).containsKey(bundle)) {
                this.propertiesIndex.get(propName).remove(bundle);
                if (this.propertiesIndex.get(propName).size() == 0) {
                    this.propertiesIndex.remove(propName);
                }
                this.properties.remove(prop);
                logger.debug("Property untracked " + prop);
            } else {
                logger.warn(String.format("Trying to delete a property (%s) from a non-existent bundle name %s", propName, bundle));
            }
        } else {
            logger.warn(String.format("Trying to delete a non-existent property name %s", propName));
        }
    }
}

