/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.priority.timetracking;

import com.google.common.base.Function;
import org.daisy.common.priority.timetracking.TimeFunctionFactory;
import org.daisy.common.priority.timetracking.TimeStats;

public class LinearTimeNormalizer
implements TimeFunctionFactory {
    @Override
    public Function<Long, Double> getFunction(final TimeStats stats) {
        final long[] minMax = this.findMinMax(stats.getReferencedTimes());
        return new Function<Long, Double>(){

            public Double apply(Long l) {
                long referencedTime = stats.reference(l);
                if (referencedTime < minMax[0]) {
                    return 0.0;
                }
                return (double)(stats.reference(l) - minMax[0]) / ((double)minMax[1] - (double)minMax[0]);
            }
        };
    }

    long[] findMinMax(long[] vals) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (long l : vals) {
            if (min > l) {
                min = l;
            }
            if (max >= l) continue;
            max = l;
        }
        return new long[]{min, max};
    }
}

