/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.priority;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ForwardingBlockingQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public class WrappingPriorityQueue<T, K extends T>
extends ForwardingBlockingQueue<T> {
    private PriorityBlockingQueue<K> delegate;
    private Function<T, K> wrapFunction;
    private Function<K, T> unwrapFunction;

    public WrappingPriorityQueue(PriorityBlockingQueue<K> delegate, Function<T, K> wrapFunction, Function<K, T> unwrapFunction) {
        this.delegate = delegate;
        this.wrapFunction = wrapFunction;
        this.unwrapFunction = unwrapFunction;
    }

    public PriorityBlockingQueue<T> delegate() {
        return this.delegate;
    }

    public Iterable<T> unwrap() {
        return Collections2.transform(this.delegate, this.unwrapFunction);
    }

    public Iterable<K> wrapped() {
        return this.delegate;
    }

    private K wrap(T element) {
        return (K)this.wrapFunction.apply(element);
    }

    private T unwrap(K element) {
        return (T)this.unwrapFunction.apply(element);
    }

    public boolean addAllBypass(Collection<K> collection) {
        return this.delegate.addAll(collection);
    }

    public boolean add(T e) {
        return this.delegate.add(this.wrap(e));
    }

    public boolean offer(T e) {
        return this.delegate.offer(this.wrap(e));
    }

    public T peek() {
        return this.unwrap(this.delegate.peek());
    }

    public T poll() {
        return this.unwrap(this.delegate.poll());
    }

    public void put(T e) {
        this.delegate.put(this.wrap(e));
    }

    public T take() throws InterruptedException {
        return this.unwrap(this.delegate.take());
    }

    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.offer(this.wrap(e), timeout, unit);
    }

    public int drainTo(Collection<? super T> c) {
        int size = this.delegate.size();
        c.addAll(Collections2.transform(this.delegate, this.unwrapFunction));
        this.delegate.clear();
        return size;
    }

    public int drainTo(Collection<? super T> c, int maxElements) {
        int i = 0;
        while (i < maxElements && this.size() > 0) {
            c.add(this.poll());
        }
        return i;
    }

    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.unwrap(this.delegate.poll(timeout, unit));
    }

    public boolean addAll(Collection<? extends T> collection) {
        for (T t : collection) {
            this.delegate.add(this.wrap(t));
        }
        return true;
    }

    public Iterator<T> iterator() {
        return Iterables.transform(this.delegate, this.unwrapFunction).iterator();
    }

    public T element() {
        return this.unwrap(this.delegate.element());
    }

    public T remove() {
        return this.unwrap(this.delegate.remove());
    }
}

