/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.priority;

import com.google.common.base.Function;
import org.daisy.common.priority.Prioritizable;
import org.daisy.common.priority.PriorityCalculator;

public class PrioritizableRunnable<T>
implements Prioritizable<T>,
Runnable {
    final long timestamp = System.currentTimeMillis();
    protected boolean dirty = true;
    protected double relativeWaitingTime;
    private Runnable runnable;
    private PriorityCalculator<T> priorityCalculator;

    public PrioritizableRunnable(Runnable runnable, PriorityCalculator<T> calculator) {
        this.runnable = runnable;
        this.priorityCalculator = calculator;
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    public PriorityCalculator<T> getPriorityCalculator() {
        return this.priorityCalculator;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public double getRelativeWaitingTime() {
        return this.relativeWaitingTime;
    }

    public void markDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setRelativeWaitingTime(Function<Long, Double> normalizer) {
        this.relativeWaitingTime = (Double)normalizer.apply((Object)this.getTimestamp());
        this.markDirty(true);
    }

    @Override
    public double getPriority() {
        return this.priorityCalculator.getPriority(this);
    }

    @Override
    public T prioritySource() {
        return this.priorityCalculator.prioritySource();
    }
}

