/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.util.ArrayList;
import java.util.List;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Property {
    public String name;
    public String value;
    public long bundleId;
    public String bundleName;

    public static List<Property> parsePropertiesXml(Node propertiesNode) {
        ArrayList<Property> properties = new ArrayList<Property>();
        try {
            if (propertiesNode instanceof Document) {
                propertiesNode = XPath.selectNode("/d:jobs", propertiesNode, XPath.dp2ns);
            }
            List<Node> propertyNodes = XPath.selectNodes("d:job", propertiesNode, XPath.dp2ns);
            for (Node propertyNode : propertyNodes) {
                Property property = new Property();
                property.name = XPath.selectText("@name", propertyNode, XPath.dp2ns);
                property.value = XPath.selectText("@value", propertyNode, XPath.dp2ns);
                property.bundleId = Long.valueOf(XPath.selectText("@bundleId", propertyNode, XPath.dp2ns));
                property.bundleName = XPath.selectText("@bundleName", propertyNode, XPath.dp2ns);
                properties.add(property);
            }
        }
        catch (Exception e) {
            Pipeline2Logger.logger().error("Failed to parse the properties XML", e);
        }
        return properties;
    }
}

