/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.daisy.pipeline.client.utils.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Message
implements Comparable<Message>,
Iterable<Message>,
Cloneable {
    public Level level;
    public Integer sequence;
    public String text;
    public Integer parentSequence;
    ProgressInfo progressInfo;
    public Integer line;
    public Integer column;
    public Long timeStamp;
    public String file;
    List<Message> children;
    Message parent;
    private static final Map<String, String> outputProps = new HashMap<String, String>();

    Message(long timeStamp) {
        outputProps.put("indent", "yes");
        outputProps.put("omit-xml-declaration", "yes");
        this.timeStamp = timeStamp;
    }

    @Override
    public int compareTo(Message other) {
        return this.sequence - other.sequence;
    }

    public void setTimeStamp(String timeStampString) {
        this.timeStamp = Long.parseLong(timeStampString);
    }

    public String formatTimeStamp() {
        return "" + this.timeStamp;
    }

    public int getDepth() {
        int depth = 0;
        Message parent = this.parent;
        while (parent != null) {
            ++depth;
            parent = parent.parent;
        }
        return depth;
    }

    public Level getInferredLevel() {
        Level inferredLevel = this.level;
        for (Message m : this) {
            Level childLevel = m.getInferredLevel();
            if (childLevel.compareTo(inferredLevel) >= 0) continue;
            inferredLevel = childLevel;
        }
        return inferredLevel;
    }

    public ProgressInfo getProgressInfo() {
        if (this.progressInfo != null && this.progressInfo.progress == null) {
            ProgressInfo sum;
            ProgressInfo p = new ProgressInfo();
            p.portion = this.progressInfo.portion;
            p.progress = BigDecimal.ZERO;
            if (this.children != null && (sum = (ProgressInfo)this.children.stream().map(Message::getProgressInfo).filter(o -> o != null).reduce((p1, p2) -> {
                if (p1 == null) {
                    return p2;
                }
                if (p2 == null) {
                    return p1;
                }
                ProgressInfo s = new ProgressInfo();
                s.portion = p1.portion.add(p2.portion);
                s.progress = s.portion.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : p1.progress.multiply(p1.portion).add(p2.progress.multiply(p2.portion)).divide(s.portion, MathContext.DECIMAL128);
                return s;
            }).orElse(null)) != null) {
                p.progress = sum.progress.multiply(sum.portion).min(BigDecimal.ONE);
            }
            return p;
        }
        return this.progressInfo;
    }

    @Override
    public Iterator<Message> iterator() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.emptyList().iterator();
    }

    void join(Message oldMessage) {
        if (oldMessage.sequence != null && this.sequence != null && oldMessage.sequence.intValue() != this.sequence.intValue()) {
            throw new IllegalArgumentException();
        }
        ProgressInfo progressInfo = this.getProgressInfo();
        if (progressInfo != null && progressInfo.equals(oldMessage.getProgressInfo())) {
            this.timeStamp = oldMessage.timeStamp;
        }
        HashMap<Integer, Message> index = new HashMap<Integer, Message>();
        for (Message m : this) {
            index.put(m.sequence, m);
        }
        int i = 0;
        for (Message oldChild : oldMessage) {
            Message newChild = (Message)index.get(oldChild.sequence);
            if (newChild != null) {
                newChild.join(oldChild);
                continue;
            }
            this.children.add(i++, oldChild);
            oldChild.parent = this;
        }
    }

    public Document toXml() {
        Document xml = XML.getXml("<message xmlns=\"http://www.daisy.org/ns/pipeline/data\"/>");
        this.toXml(xml.getDocumentElement(), true);
        return xml;
    }

    void toXml(Element target, boolean progress) {
        if (this.level != null) {
            target.setAttribute("level", this.level.toString());
        }
        if (this.sequence != null) {
            target.setAttribute("sequence", "" + this.sequence);
        }
        if (this.line != null) {
            target.setAttribute("line", "" + this.sequence);
        }
        if (this.column != null) {
            target.setAttribute("column", "" + this.sequence);
        }
        if (this.timeStamp != null) {
            target.setAttribute("timeStamp", this.formatTimeStamp());
        }
        if (this.file != null) {
            target.setAttribute("file", this.file);
        }
        if (this.text != null) {
            target.setAttribute("content", this.text);
        }
        if (progress) {
            ProgressInfo progressInfo = this.getProgressInfo();
            if (progressInfo != null && progressInfo.portion.compareTo(BigDecimal.ZERO) > 0) {
                target.setAttribute("portion", Float.toString(progressInfo.portion.floatValue()));
                target.setAttribute("progress", Float.toString(progressInfo.progress.floatValue()));
            } else {
                progress = false;
            }
        }
        for (Message m : this) {
            Element childElem = target.getOwnerDocument().createElementNS(target.getNamespaceURI(), target.getLocalName());
            m.toXml(childElem, progress);
            target.appendChild(childElem);
        }
    }

    public String toString() {
        Element elem = XML.getXml("<message/>").getDocumentElement();
        this.toXml(elem, true);
        return XML.toString(elem, outputProps);
    }

    public Object clone() {
        Message clone;
        try {
            clone = (Message)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("coding error");
        }
        if (this.progressInfo != null) {
            clone.progressInfo = new ProgressInfo();
            clone.progressInfo.portion = this.progressInfo.portion;
            clone.progressInfo.progress = this.progressInfo.progress;
        }
        if (this.children != null) {
            clone.children = new ArrayList<Message>();
            for (Message child : this.children) {
                child = (Message)child.clone();
                child.parent = clone;
                clone.children.add(child);
            }
        }
        return clone;
    }

    public static class ProgressInfo {
        public BigDecimal portion;
        public BigDecimal progress;

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ProgressInfo)) {
                return false;
            }
            ProgressInfo that = (ProgressInfo)o;
            if (this.portion.compareTo(that.portion) != 0) {
                return false;
            }
            if (this.progress == null) {
                return that.progress == null;
            }
            if (that.progress == null) {
                return false;
            }
            return this.progress.compareTo(that.progress) == 0;
        }
    }

    public static enum Level {
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }
}

