/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.daisy.pipeline.client.models.Message;

class JobMessages
extends AbstractList<Message> {
    private final Map<Integer, Message> messageIndex = new HashMap<Integer, Message>();
    private final List<Integer> messagesTree = new ArrayList<Integer>();
    final int msgSeq;
    private final List<Integer> messagesSequence = new ArrayList<Integer>();
    private Long jobStartTime = null;
    private BigDecimal progressFrom = BigDecimal.ZERO;
    private Long progressFromTime = null;
    private BigDecimal progressInterval = BigDecimal.ZERO;
    private int lastMessageCount = 0;
    private boolean dirty = true;

    public JobMessages(List<Message> messagesTree, int msgSeq) {
        for (Message m : messagesTree) {
            this.messagesTree.add(m.sequence);
            this.messageIndex.put(m.sequence, m);
        }
        this.msgSeq = msgSeq;
        this.addTree(this, messagesTree, msgSeq);
        JobMessages.indexTree(this.messageIndex, messagesTree);
    }

    private void addTree(List<Message> collect, Iterable<Message> messages, int newerThan) {
        for (Message m : messages) {
            if (m.sequence > newerThan) {
                Message old = this.messageIndex.get(m.sequence);
                if (old != null) {
                    collect.remove(old);
                }
                collect.add(m);
            }
            this.addTree(collect, m, newerThan);
        }
    }

    private static void indexTree(Map<Integer, Message> index, Iterable<Message> messages) {
        for (Message m : messages) {
            index.put(m.sequence, m);
            JobMessages.indexTree(index, m);
        }
    }

    @Override
    public Message get(int index) {
        return this.messageIndex.get(this.messagesSequence.get(index));
    }

    @Override
    public int size() {
        return this.messagesSequence.size();
    }

    @Override
    public void add(int index, Message element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.messagesSequence.add(index, element.sequence);
        this.messageIndex.put(element.sequence, element);
        this.dirty = this.dirty || index < this.lastMessageCount;
        ++this.modCount;
        if (element.getProgressInfo() != null && (this.jobStartTime == null || element.timeStamp < this.jobStartTime)) {
            this.jobStartTime = element.timeStamp;
        }
    }

    @Override
    public Message set(int index, Message element) {
        if (element == null) {
            throw new NullPointerException();
        }
        Message prev = this.messageIndex.get(this.messagesSequence.set(index, element.sequence));
        this.messageIndex.put(element.sequence, element);
        this.dirty = this.dirty || index < this.lastMessageCount && !element.equals(prev);
        ++this.modCount;
        return prev;
    }

    @Override
    public Message remove(int index) {
        this.dirty = this.dirty || index < this.lastMessageCount;
        ++this.modCount;
        return this.messageIndex.get(this.messagesSequence.remove(index));
    }

    public void join(JobMessages messages) {
        Iterable<Message> tree = messages.asTree();
        for (Message m : tree) {
            Message old = this.messageIndex.get(m.sequence);
            if (old != null) {
                m.join(old);
                continue;
            }
            this.messagesTree.add(m.sequence);
        }
        this.addTree(this, tree, this.msgSeq);
        JobMessages.indexTree(this.messageIndex, tree);
    }

    public Iterable<Message> asTree() {
        return new Iterable<Message>(){

            @Override
            public Iterator<Message> iterator() {
                final Iterator i = JobMessages.this.messagesTree.iterator();
                return new Iterator<Message>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Message next() {
                        return (Message)JobMessages.this.messageIndex.get(i.next());
                    }
                };
            }
        };
    }

    public Long getJobStartTime() {
        return this.jobStartTime;
    }

    public BigDecimal getProgressFrom() {
        this.updateProgress();
        return this.progressFrom;
    }

    private BigDecimal computeProgressFrom() {
        return this.messagesTree.stream().map(i -> this.messageIndex.get(i)).map(Message::getProgressInfo).filter(o -> o != null).map(p -> p.portion.multiply(p.progress)).reduce(BigDecimal.ZERO, (d1, d2) -> d1.add((BigDecimal)d2)).min(BigDecimal.ONE);
    }

    public Long getProgressFromTime() {
        this.updateProgress();
        return this.progressFromTime;
    }

    private Long computeProgressFromTime() {
        try {
            return this.messagesTree.stream().map(i -> this.messageIndex.get(i)).filter(m -> m.progressInfo != null).mapToLong(m -> m.timeStamp).max().getAsLong();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public BigDecimal getProgressInterval() {
        this.updateProgress();
        return this.progressInterval;
    }

    public BigDecimal computeProgressInterval() {
        ArrayList<BigDecimal> uncompletedMessages = new ArrayList<BigDecimal>();
        JobMessages.getUncompletedMessages(uncompletedMessages, this.asTree());
        return uncompletedMessages.stream().reduce((d1, d2) -> d1.min((BigDecimal)d2)).orElse(BigDecimal.ZERO);
    }

    private static void getUncompletedMessages(List<BigDecimal> collect, Iterable<Message> messages) {
        for (Message message : messages) {
            Message.ProgressInfo progress = message.getProgressInfo();
            if (progress == null || progress.progress.compareTo(BigDecimal.ONE) >= 0) continue;
            ArrayList<BigDecimal> uncompletedChildren = new ArrayList<BigDecimal>();
            JobMessages.getUncompletedMessages(uncompletedChildren, message);
            if (uncompletedChildren.isEmpty()) {
                collect.add(progress.portion.multiply(BigDecimal.ONE.subtract(progress.progress)));
                continue;
            }
            for (BigDecimal p : uncompletedChildren) {
                collect.add(p.multiply(progress.portion));
            }
        }
    }

    private void updateProgress() {
        if (!this.dirty && this.lastMessageCount == this.size()) {
            return;
        }
        this.progressFrom = this.computeProgressFrom();
        this.progressFromTime = this.computeProgressFromTime();
        this.progressInterval = this.computeProgressInterval();
        this.lastMessageCount = this.size();
        this.dirty = false;
    }
}

