/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.utils.XML;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Callback
implements Comparable<Callback> {
    public String href;
    public Type type;
    public String frequency;

    public Callback(String href, Type type, String frequency) {
        this.href = href;
        this.type = type;
        this.frequency = frequency;
    }

    public Callback(Node callbackElement) {
        try {
            this.href = XPath.selectText("@href", callbackElement, XPath.dp2ns);
            String type = XPath.selectText("@href", callbackElement, XPath.dp2ns);
            for (Type t : Type.values()) {
                if (!t.toString().equals(type)) continue;
                this.type = t;
                break;
            }
            this.frequency = XPath.selectText("@frequency", callbackElement, XPath.dp2ns);
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Unable to parse callback XML", e);
        }
    }

    @Override
    public int compareTo(Callback other) {
        assert (this.href != null);
        assert (this.type != null);
        return ((Object)((Object)this.type) + this.href).compareTo((Object)((Object)other.type) + other.href);
    }

    public Document toXml() {
        Document callbackDocument = XML.getXml("<callback xmlns=\"http://www.daisy.org/ns/pipeline/data\"/>");
        Element callbackElement = callbackDocument.getDocumentElement();
        if (this.href != null) {
            callbackElement.setAttribute("href", this.href);
        }
        if (this.type != null) {
            callbackElement.setAttribute("type", this.type.toString());
        }
        if (this.frequency != null) {
            callbackElement.setAttribute("frequency", this.frequency);
        }
        return callbackDocument;
    }

    public static enum Type {
        messages,
        status;

    }
}

