/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client;

import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class Pipeline2Logger {
    private static Pipeline2Logger logger = new Pipeline2ConsoleLogger();

    public static Pipeline2Logger logger() {
        return logger;
    }

    public static void setLogger(Pipeline2Logger logger) {
        Pipeline2Logger.logger = logger;
    }

    public abstract void setLevel(LEVEL var1);

    public abstract LEVEL getLevel();

    public abstract boolean logsLevel(LEVEL var1);

    public abstract void trace(String var1);

    public abstract void trace(String var1, Exception var2);

    public abstract void debug(String var1);

    public abstract void debug(String var1, Exception var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Exception var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Exception var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Exception var2);

    public abstract void fatal(String var1);

    public abstract void fatal(String var1, Exception var2);

    public static class Pipeline2ConsoleLogger
    extends Pipeline2Logger {
        private LEVEL level = LEVEL.INFO;

        @Override
        public void setLevel(LEVEL level) {
            if (level != null) {
                this.level = level;
            }
        }

        @Override
        public LEVEL getLevel() {
            return this.level;
        }

        @Override
        public boolean logsLevel(LEVEL level) {
            return this.level.ordinal() <= level.ordinal();
        }

        @Override
        public void trace(String message) {
            if (!this.logsLevel(LEVEL.TRACE)) {
                return;
            }
            System.err.println("[trace] " + message);
        }

        @Override
        public void trace(String message, Exception e) {
            if (!this.logsLevel(LEVEL.TRACE)) {
                return;
            }
            System.err.println("[trace] " + message);
            System.err.println("[trace] " + this.stacktraceToString(e));
        }

        @Override
        public void debug(String message) {
            if (!this.logsLevel(LEVEL.DEBUG)) {
                return;
            }
            System.out.println("[debug] " + message);
        }

        @Override
        public void debug(String message, Exception e) {
            if (!this.logsLevel(LEVEL.DEBUG)) {
                return;
            }
            System.out.println("[debug] " + message);
            System.err.println("[debug] " + this.stacktraceToString(e));
        }

        @Override
        public void info(String message) {
            if (!this.logsLevel(LEVEL.INFO)) {
                return;
            }
            System.out.println("[info] " + message);
        }

        @Override
        public void info(String message, Exception e) {
            if (!this.logsLevel(LEVEL.INFO)) {
                return;
            }
            System.out.println("[info] " + message);
            System.err.println("[info] " + this.stacktraceToString(e));
        }

        @Override
        public void warn(String message) {
            if (!this.logsLevel(LEVEL.WARN)) {
                return;
            }
            System.out.println("[warn] " + message);
        }

        @Override
        public void warn(String message, Exception e) {
            if (!this.logsLevel(LEVEL.WARN)) {
                return;
            }
            System.out.println("[warn] " + message);
            System.err.println("[warn] " + this.stacktraceToString(e));
        }

        @Override
        public void error(String message) {
            if (!this.logsLevel(LEVEL.ERROR)) {
                return;
            }
            System.err.println("[error] " + message);
        }

        @Override
        public void error(String message, Exception e) {
            if (!this.logsLevel(LEVEL.ERROR)) {
                return;
            }
            System.err.println("[error] " + message);
            System.err.println("[error] " + this.stacktraceToString(e));
        }

        @Override
        public void fatal(String message) {
            if (!this.logsLevel(LEVEL.FATAL)) {
                return;
            }
            System.err.println("[fatal] " + message);
        }

        @Override
        public void fatal(String message, Exception e) {
            if (!this.logsLevel(LEVEL.FATAL)) {
                return;
            }
            System.err.println("[fatal] " + message);
            System.err.println("[fatal] " + this.stacktraceToString(e));
        }

        public String stacktraceToString(Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
    }

    public static enum LEVEL {
        ALL,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF;

    }
}

