/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import java.net.URISyntaxException;
import java.util.Objects;
import org.cyclonedx.gradle.utils.GitUtils;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ExternalReferencesUtil {
    private static final Logger LOGGER = Logging.getLogger(ExternalReferencesUtil.class);

    private ExternalReferencesUtil() {
    }

    public static void complementByEnvironment(Component component) {
        ExternalReferencesUtil.addGitReference(component);
    }

    private static void addGitReference(Component component) {
        if (component.getExternalReferences() != null && component.getExternalReferences().stream().filter(Objects::nonNull).anyMatch(er -> ExternalReference.Type.VCS == er.getType())) {
            return;
        }
        String gitUrl = GitUtils.getGitUrlFromEnvironmentVariable();
        if (gitUrl == null || gitUrl.isEmpty()) {
            gitUrl = GitUtils.getGitUrlFromGitRepo();
        }
        if (gitUrl == null) {
            return;
        }
        try {
            gitUrl = GitUtils.sanitizeGitUrl(gitUrl);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("{} Invalid Git URL identified from environment, ignoring it", (Object)"[CycloneDX]");
            return;
        }
        ExternalReference externalReference = new ExternalReference();
        externalReference.setType(ExternalReference.Type.VCS);
        externalReference.setUrl(gitUrl);
        component.addExternalReference(externalReference);
    }
}

