/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.License;
import org.cyclonedx.gradle.CyclonedxDirectTask;
import org.cyclonedx.gradle.DependencyGraphTraverser;
import org.cyclonedx.gradle.MavenProjectLookup;
import org.cyclonedx.gradle.model.ConfigurationScope;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.model.SbomGraph;
import org.cyclonedx.gradle.utils.DependencyUtils;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class SbomGraphProvider
implements Callable<SbomGraph> {
    private static final Logger LOGGER = Logging.getLogger(SbomGraphProvider.class);
    private static final ResolvedArtifactResult[] ARTIFACT_TYPE = new ResolvedArtifactResult[0];
    private final Project project;
    private final CyclonedxDirectTask task;
    private final MavenProjectLookup mavenLookup;

    SbomGraphProvider(Project project, CyclonedxDirectTask task) {
        this.project = project;
        this.task = task;
        this.mavenLookup = new MavenProjectLookup(project);
    }

    @Override
    public SbomGraph call() {
        if (this.project.getGroup().equals("") || this.project.getVersion().equals("")) {
            LOGGER.warn("{} Project group or version are not set for project [{}], will use \"unspecified\"", (Object)"[CycloneDX]", (Object)this.project.getName());
        }
        LOGGER.info("{} Resolving dependencies for project [{}]", (Object)"[CycloneDX]", (Object)this.project.getDisplayName());
        Map<SbomComponentId, SbomComponent> graph = this.traverseProject().reduce(new HashMap(), DependencyUtils::mergeGraphs);
        return this.buildSbomGraph(graph);
    }

    private SbomGraph buildSbomGraph(Map<SbomComponentId, SbomComponent> graph) {
        SbomComponentId projectBasedRootComponentId = new SbomComponentId(this.project.getGroup().toString(), this.project.getName(), this.project.getVersion().toString(), null, this.project.getPath());
        SbomComponentId configurationBasedRootComponentId = new SbomComponentId((String)this.task.getComponentGroup().get(), (String)this.task.getComponentName().get(), (String)this.task.getComponentVersion().get(), null, this.project.getPath());
        SbomComponent sbomComponentFromGraph = graph.get(projectBasedRootComponentId);
        if (sbomComponentFromGraph == null) {
            LOGGER.warn("{} Root component [{}] not found in the graph, constructing it, but dependency graph will be disconnected", (Object)"[CycloneDX]", (Object)projectBasedRootComponentId);
            SbomComponent configurationBasedSbomComponent = new SbomComponent.Builder().withId(configurationBasedRootComponentId).withDependencyComponents(new HashSet<SbomComponentId>()).withInScopeConfigurations(new HashSet<ConfigurationScope>()).withLicenses(new ArrayList<License>()).build();
            return new SbomGraph(graph, configurationBasedSbomComponent);
        }
        if (projectBasedRootComponentId.equals(configurationBasedRootComponentId)) {
            return new SbomGraph(graph, sbomComponentFromGraph);
        }
        SbomComponent configurationBasedSbomComponent = new SbomComponent.Builder().withId(configurationBasedRootComponentId).withArtifactFile(sbomComponentFromGraph.getArtifactFile().orElse(null)).withDependencyComponents(sbomComponentFromGraph.getDependencyComponents()).withInScopeConfigurations(sbomComponentFromGraph.getInScopeConfigurations()).withLicenses(sbomComponentFromGraph.getLicenses()).withMetaData(sbomComponentFromGraph.getSbomMetaData().orElse(null)).build();
        LOGGER.info("{} Replacing project based root component [{}] with configuration based [{}]", new Object[]{"[CycloneDX]", projectBasedRootComponentId, configurationBasedRootComponentId});
        graph.remove(projectBasedRootComponentId);
        graph.put(configurationBasedRootComponentId, configurationBasedSbomComponent);
        return new SbomGraph(graph, configurationBasedSbomComponent);
    }

    private Stream<Map<SbomComponentId, SbomComponent>> traverseProject() {
        DependencyGraphTraverser traverser = new DependencyGraphTraverser(this.getArtifacts(), this.mavenLookup, this.task);
        return this.getInScopeConfigurations().map(config -> traverser.traverseGraph(config.getIncoming().getResolutionResult().getRoot(), this.project.getName(), config.getName()));
    }

    private Map<ComponentIdentifier, File> getArtifacts() {
        return this.getInScopeConfigurations().flatMap(config -> {
            ResolvedArtifactResult[] resolvedArtifacts = config.getIncoming().artifactView(view -> view.lenient(true)).getArtifacts().getArtifacts().toArray(ARTIFACT_TYPE);
            LOGGER.debug("{} For project {} following artifacts have been resolved: {}", new Object[]{"[CycloneDX]", this.project.getName(), this.summarize(resolvedArtifacts, v -> v.getId().getDisplayName())});
            return Arrays.stream(resolvedArtifacts);
        }).collect(Collectors.toMap(artifact -> artifact.getId().getComponentIdentifier(), ResolvedArtifactResult::getFile, (v1, v2) -> v1));
    }

    private <T> String summarize(T[] data, Function<T, String> extractor) {
        return Arrays.stream(data).map(extractor).collect(Collectors.joining(","));
    }

    private boolean shouldSkipConfiguration(Configuration configuration) {
        return ((List)this.task.getSkipConfigs().get()).stream().anyMatch(configuration.getName()::matches);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldIncludeConfiguration(Configuration configuration) {
        if (((List)this.task.getIncludeConfigs().get()).isEmpty()) return true;
        if (!((List)this.task.getIncludeConfigs().get()).stream().anyMatch(configuration.getName()::matches)) return false;
        return true;
    }

    private boolean filterConfigurations(Project project, Configuration configuration) {
        boolean include = this.shouldIncludeConfiguration(configuration);
        boolean skip = this.shouldSkipConfiguration(configuration);
        boolean resolvable = configuration.isCanBeResolved();
        if (!include || skip || !resolvable) {
            LOGGER.debug("{}, Skipping configuration '{}' (project: {}, include: {}, skip: {}, canBeResolved: {})", new Object[]{"[CycloneDX]", configuration.getName(), project, include, skip, resolvable});
        }
        return include && !skip && resolvable;
    }

    private Stream<Configuration> getInScopeConfigurations() {
        Stream<Configuration> projectConfigs = this.project.getConfigurations().stream().filter(configuration -> this.filterConfigurations(this.project, (Configuration)configuration));
        Stream<Object> buildScriptConfigs = (Boolean)this.task.getIncludeBuildEnvironment().get() != false ? this.project.getBuildscript().getConfigurations().stream().filter(configuration -> this.filterConfigurations(this.project, (Configuration)configuration)) : Stream.empty();
        Configuration[] configs = (Configuration[])Stream.concat(projectConfigs, buildScriptConfigs).toArray(Configuration[]::new);
        LOGGER.info("{} For project {} following configurations are in scope to build the dependency graph: {}", new Object[]{"[CycloneDX]", this.project.getName(), this.summarize(configs, Named::getName)});
        return Arrays.stream(configs);
    }
}

