/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import com.github.packageurl.MalformedPackageURLException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.cyclonedx.Version;
import org.cyclonedx.gradle.BaseCyclonedxTask;
import org.cyclonedx.gradle.MavenHelper;
import org.cyclonedx.gradle.model.ComponentComparator;
import org.cyclonedx.gradle.model.DependencyComparator;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.model.SbomGraph;
import org.cyclonedx.gradle.utils.DependencyUtils;
import org.cyclonedx.gradle.utils.EnvironmentUtils;
import org.cyclonedx.gradle.utils.ExternalReferencesUtil;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.BomUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jspecify.annotations.Nullable;

class SbomBuilder<T extends BaseCyclonedxTask> {
    private static final Logger LOGGER = Logging.getLogger(SbomBuilder.class);
    private final Map<File, List<Hash>> artifactHashes;
    private final MavenHelper mavenHelper;
    private final Version version;
    private final T task;

    SbomBuilder(T task) {
        this.version = (Version)((BaseCyclonedxTask)((Object)task)).getSchemaVersion().get();
        this.artifactHashes = new HashMap<File, List<Hash>>();
        this.mavenHelper = new MavenHelper((Boolean)((BaseCyclonedxTask)((Object)task)).getIncludeLicenseText().get());
        this.task = task;
    }

    Bom buildBom(SbomGraph graph) {
        LOGGER.info("{} Creating BOM", (Object)"[CycloneDX]");
        TreeSet<Dependency> dependencies = new TreeSet<Dependency>(new DependencyComparator());
        TreeSet<Component> components = new TreeSet<Component>(new ComponentComparator());
        graph.getGraph().forEach((componentId, adjacentComponentIds) -> {
            this.addDependency((Set<Dependency>)dependencies, (SbomComponent)adjacentComponentIds);
            this.addComponent((Set<Component>)components, (SbomComponent)adjacentComponentIds, graph.getRootComponent());
        });
        Bom bom = new Bom();
        if (((Boolean)((BaseCyclonedxTask)((Object)this.task)).getIncludeBomSerialNumber().get()).booleanValue()) {
            bom.setSerialNumber("urn:uuid:" + UUID.randomUUID());
        }
        bom.setMetadata(this.buildMetadata(graph.getRootComponent()));
        bom.setComponents(new ArrayList<Component>(components));
        bom.setDependencies(new ArrayList<Dependency>(dependencies));
        return bom;
    }

    private Metadata buildMetadata(SbomComponent rootComponent) {
        Properties pluginProperties;
        Metadata metadata = new Metadata();
        try {
            metadata.setComponent(this.buildFinilizedRootComponent(rootComponent));
        }
        catch (MalformedPackageURLException e) {
            LOGGER.warn("{} Error constructing packageUrl for parent component {}. Skipping...", new Object[]{"[CycloneDX]", rootComponent.getId().getName(), e});
        }
        if (((BaseCyclonedxTask)((Object)this.task)).getLicenseChoice().isPresent()) {
            metadata.setLicenses((LicenseChoice)((BaseCyclonedxTask)((Object)this.task)).getLicenseChoice().get());
        }
        if (((BaseCyclonedxTask)((Object)this.task)).getOrganizationalEntity().isPresent() && !new OrganizationalEntity().equals(((BaseCyclonedxTask)((Object)this.task)).getOrganizationalEntity().get())) {
            if (this.version.compareTo((Enum)Version.VERSION_16) >= 0) {
                metadata.setManufacturer((OrganizationalEntity)((BaseCyclonedxTask)((Object)this.task)).getOrganizationalEntity().get());
            } else {
                metadata.setManufacture((OrganizationalEntity)((BaseCyclonedxTask)((Object)this.task)).getOrganizationalEntity().get());
            }
        }
        if (!(pluginProperties = this.readPluginProperties()).isEmpty()) {
            if (this.version.compareTo((Enum)Version.VERSION_15) >= 0) {
                Component component = new Component();
                component.setType(Component.Type.APPLICATION);
                component.setAuthor(pluginProperties.getProperty("vendor"));
                component.setName(pluginProperties.getProperty("name"));
                component.setVersion(pluginProperties.getProperty("version"));
                ToolInformation tool = new ToolInformation();
                tool.setComponents(Collections.singletonList(component));
                metadata.setToolChoice(tool);
            } else {
                Tool tool = new Tool();
                tool.setVendor(pluginProperties.getProperty("vendor"));
                tool.setName(pluginProperties.getProperty("name"));
                tool.setVersion(pluginProperties.getProperty("version"));
                metadata.addTool(tool);
            }
        }
        return metadata;
    }

    private Component buildFinilizedRootComponent(SbomComponent rootComponent) throws MalformedPackageURLException {
        Component component = this.toComponent(rootComponent, null, this.resolveProjectType());
        component.setProperties(null);
        component.setGroup((String)((BaseCyclonedxTask)((Object)this.task)).getComponentGroup().get());
        component.setName((String)((BaseCyclonedxTask)((Object)this.task)).getComponentName().get());
        component.setVersion((String)((BaseCyclonedxTask)((Object)this.task)).getComponentVersion().get());
        this.addBuildSystemMetaData(component);
        if (((BaseCyclonedxTask)((Object)this.task)).getExternalReferences().isPresent()) {
            ((List)((BaseCyclonedxTask)((Object)this.task)).getExternalReferences().get()).forEach(arg_0 -> ((Component)component).addExternalReference(arg_0));
        }
        ExternalReferencesUtil.complementByEnvironment(component);
        return component;
    }

    private void addBuildSystemMetaData(Component component) {
        String url;
        if (((Boolean)((BaseCyclonedxTask)((Object)this.task)).getIncludeBuildSystem().get()).booleanValue() && (url = ((BaseCyclonedxTask)((Object)this.task)).getBuildSystemEnvironmentVariable().isPresent() ? EnvironmentUtils.getBuildURI((String)((BaseCyclonedxTask)((Object)this.task)).getBuildSystemEnvironmentVariable().get()) : EnvironmentUtils.getBuildURI()) != null) {
            ExternalReference buildRef = new ExternalReference();
            buildRef.setType(ExternalReference.Type.BUILD_SYSTEM);
            buildRef.setUrl(url);
            component.addExternalReference(buildRef);
        }
    }

    private void addDependency(Set<Dependency> dependencies, SbomComponent component) {
        Dependency dependency;
        try {
            dependency = this.toDependency(component.getId());
        }
        catch (MalformedPackageURLException e) {
            LOGGER.warn("{} Error constructing packageUrl for component {}. Skipping...", new Object[]{"[CycloneDX]", component.getId().getName(), e});
            return;
        }
        component.getDependencyComponents().forEach(dependencyComponent -> {
            try {
                dependency.addDependency(this.toDependency((SbomComponentId)dependencyComponent));
            }
            catch (MalformedPackageURLException e) {
                LOGGER.warn("{} Error constructing packageUrl for component dependency {}. Skipping...", new Object[]{"[CycloneDX]", dependencyComponent.getName(), e});
            }
        });
        dependencies.add(dependency);
    }

    private Dependency toDependency(SbomComponentId componentId) throws MalformedPackageURLException {
        String ref = DependencyUtils.generatePackageUrl(componentId);
        return new Dependency(ref);
    }

    private void addComponent(Set<Component> components, SbomComponent component, SbomComponent rootComponent) {
        if (component.equals(rootComponent)) {
            return;
        }
        File artifactFile = component.getArtifactFile().orElse(null);
        try {
            components.add(this.toComponent(component, artifactFile, Component.Type.LIBRARY));
        }
        catch (MalformedPackageURLException e) {
            LOGGER.warn("{} Error constructing packageUrl for component {}. Skipping...", new Object[]{"[CycloneDX]", component.getId().getName(), e});
        }
    }

    private Component toComponent(SbomComponent component, @Nullable File artifactFile, Component.Type type) throws MalformedPackageURLException {
        String packageUrl = DependencyUtils.generatePackageUrl(component.getId());
        Component resultComponent = new Component();
        resultComponent.setGroup(component.getId().getGroup());
        resultComponent.setName(component.getId().getName());
        resultComponent.setVersion(component.getId().getVersion());
        resultComponent.setType(type);
        resultComponent.setPurl(packageUrl);
        resultComponent.setProperties(this.buildProperties(component));
        resultComponent.setModified(Boolean.valueOf(this.mavenHelper.isModified(null)));
        resultComponent.setBomRef(packageUrl);
        component.getSbomMetaData().ifPresent(metaData -> {
            resultComponent.setDescription(metaData.getDescription());
            resultComponent.setPublisher(metaData.getPublisher());
            metaData.getExternalReferences().forEach(arg_0 -> ((Component)resultComponent).addExternalReference(arg_0));
        });
        if (!component.getLicenses().isEmpty()) {
            LicenseChoice licenseChoice = this.mavenHelper.resolveMavenLicenses(component.getLicenses());
            resultComponent.setLicenses(licenseChoice);
        }
        LOGGER.debug("{} Calculating hashes", (Object)"[CycloneDX]");
        if (artifactFile != null) {
            resultComponent.setHashes(this.calculateHashes(artifactFile));
        }
        return resultComponent;
    }

    private List<Property> buildProperties(SbomComponent component) {
        Property isTestProperty = this.buildIsTestProperty(component);
        ArrayList<Property> resultProperties = new ArrayList<Property>();
        resultProperties.add(isTestProperty);
        return resultProperties;
    }

    private Property buildIsTestProperty(SbomComponent component) {
        boolean isTestComponent = component.getInScopeConfigurations().stream().allMatch(v -> v.getConfigName().startsWith("test"));
        Property property = new Property();
        property.setName("cdx:maven:package:test");
        property.setValue(Boolean.toString(isTestComponent));
        return property;
    }

    private List<Hash> calculateHashes(File artifactFile) {
        return this.artifactHashes.computeIfAbsent(artifactFile, f -> {
            try {
                return BomUtils.calculateHashes((File)f, (Version)this.version);
            }
            catch (IOException e) {
                LOGGER.error("{} Error encountered calculating hashes", (Object)"[CycloneDX]", (Object)e);
                return Collections.emptyList();
            }
        });
    }

    private Component.Type resolveProjectType() {
        for (Component.Type type : Component.Type.values()) {
            if (!type.equals(((BaseCyclonedxTask)((Object)this.task)).getProjectType().get())) continue;
            return type;
        }
        LOGGER.warn("{} Invalid project type. Defaulting to 'library'", (Object)"[CycloneDX]");
        LOGGER.warn("{} Valid types are:", (Object)"[CycloneDX]");
        for (Component.Type type : Component.Type.values()) {
            LOGGER.warn("{} {}", (Object)"[CycloneDX]", (Object)type.getTypeName());
        }
        return Component.Type.LIBRARY;
    }

    private Properties readPluginProperties() {
        Properties props = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("plugin.properties");){
            if (inputStream == null) {
                LOGGER.info("{} plugin.properties is not found on the classpath", (Object)"[CycloneDX]");
            } else {
                props.load(inputStream);
            }
        }
        catch (Exception e) {
            LOGGER.warn("{} Error whilst loading plugin.properties", (Object)"[CycloneDX]", (Object)e);
        }
        return props;
    }
}

