/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.gradle.CyclonedxDirectTask;
import org.cyclonedx.gradle.MavenHelper;
import org.cyclonedx.gradle.MavenProjectLookup;
import org.cyclonedx.gradle.model.ConfigurationScope;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.model.SbomMetaData;
import org.cyclonedx.gradle.utils.DependencyUtils;
import org.cyclonedx.model.Component;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jspecify.annotations.Nullable;

class DependencyGraphTraverser {
    private static final Logger LOGGER = Logging.getLogger(DependencyGraphTraverser.class);
    private final Map<ComponentIdentifier, File> resolvedArtifacts;
    private final MavenProjectLookup mavenLookup;
    private final boolean includeMetaData;
    private final MavenHelper mavenHelper;

    DependencyGraphTraverser(Map<ComponentIdentifier, File> resolvedArtifacts, MavenProjectLookup mavenLookup, CyclonedxDirectTask task) {
        this.resolvedArtifacts = resolvedArtifacts;
        this.mavenLookup = mavenLookup;
        this.includeMetaData = (Boolean)task.getIncludeMetadataResolution().get();
        this.mavenHelper = new MavenHelper((Boolean)task.getIncludeLicenseText().get());
    }

    Map<SbomComponentId, SbomComponent> traverseGraph(ResolvedComponentResult rootNode, String projectName, String configName) {
        HashMap<GraphNode, Set<GraphNode>> graph = new HashMap<GraphNode, Set<GraphNode>>();
        ArrayDeque<GraphNode> queue = new ArrayDeque<GraphNode>();
        GraphNode rootGraphNode = new GraphNode(rootNode);
        rootGraphNode.inScopeConfiguration(projectName, configName);
        queue.add(rootGraphNode);
        LOGGER.debug("{} CycloneDX: Traversal of graph for configuration {} of project {}", new Object[]{"[CycloneDX]", configName, projectName});
        while (!queue.isEmpty()) {
            GraphNode graphNode = (GraphNode)queue.poll();
            if (graph.containsKey(graphNode)) continue;
            graph.put(graphNode, new HashSet());
            LOGGER.debug("{} Traversing node with ID {}", (Object)"[CycloneDX]", (Object)graphNode.id);
            for (DependencyResult dep : graphNode.getResult().getDependencies()) {
                if (dep.isConstraint()) continue;
                if (dep instanceof ResolvedDependencyResult) {
                    ResolvedComponentResult dependencyComponent = ((ResolvedDependencyResult)dep).getSelected();
                    if (graphNode.id.equals((Object)dependencyComponent.getId())) continue;
                    LOGGER.debug("{} Node with ID {} has dependency with ID {}", new Object[]{"[CycloneDX]", graphNode.id, dependencyComponent});
                    GraphNode dependencyNode = new GraphNode(dependencyComponent);
                    dependencyNode.inScopeConfiguration(projectName, configName);
                    ((Set)graph.get(graphNode)).add(dependencyNode);
                    queue.add(dependencyNode);
                    continue;
                }
                if (!(dep instanceof UnresolvedDependencyResult)) continue;
                UnresolvedDependencyResult unresolved = (UnresolvedDependencyResult)dep;
                LOGGER.info("{} Unable to resolve artifact {} because {}", new Object[]{"[CycloneDX]", unresolved.getAttempted().getDisplayName(), unresolved.getFailure().toString()});
            }
        }
        return this.toSbomComponents(graph);
    }

    private Map<SbomComponentId, SbomComponent> toSbomComponents(Map<GraphNode, Set<GraphNode>> graph) {
        return graph.entrySet().stream().map(entry -> this.toSbomComponent((GraphNode)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toMap(SbomComponent::getId, v -> v));
    }

    private SbomComponent toSbomComponent(GraphNode node, Set<GraphNode> dependencyNodes) {
        File artifactFile = this.getArtifactFile(node);
        SbomComponentId id = DependencyUtils.toComponentId(node.getResult(), artifactFile);
        List<License> licenses = new ArrayList<License>();
        SbomMetaData metaData = null;
        if (this.includeMetaData && node.id instanceof ModuleComponentIdentifier) {
            LOGGER.debug("{}: Including meta data for node {}", (Object)"[CycloneDX]", (Object)node.id);
            Component component = new Component();
            this.extractMetaDataFromArtifactPom(artifactFile, component, node.getResult());
            licenses = this.extractMetaDataFromRepository(component, node.getResult());
            metaData = SbomMetaData.fromComponent(component);
        }
        return new SbomComponent.Builder().withId(id).withDependencyComponents(this.getSbomDependencies(dependencyNodes)).withInScopeConfigurations(node.getInScopeConfigurations()).withArtifactFile(artifactFile).withMetaData(metaData).withLicenses(licenses).build();
    }

    private void extractMetaDataFromArtifactPom(@Nullable File artifactFile, Component component, ResolvedComponentResult result) {
        if (artifactFile == null || result.getModuleVersion() == null) {
            return;
        }
        @Nullable MavenProject mavenProject = this.mavenHelper.extractPom(artifactFile, result.getModuleVersion());
        if (mavenProject != null) {
            LOGGER.debug("{} Parse artifact pom file of component {}", (Object)"[CycloneDX]", (Object)result.getId());
            this.mavenHelper.getClosestMetadata(artifactFile, mavenProject, component, result.getModuleVersion());
        }
    }

    private List<License> extractMetaDataFromRepository(Component component, ResolvedComponentResult result) {
        MavenProject mavenProject = this.mavenLookup.getResolvedMavenProject(result);
        if (mavenProject != null) {
            this.mavenHelper.extractMetadata(mavenProject, component);
            return mavenProject.getLicenses();
        }
        return new ArrayList<License>();
    }

    private Set<SbomComponentId> getSbomDependencies(Set<GraphNode> dependencyNodes) {
        return dependencyNodes.stream().map(dependency -> DependencyUtils.toComponentId(((GraphNode)dependency).getResult(), this.getArtifactFile((GraphNode)dependency))).collect(Collectors.toSet());
    }

    private @Nullable File getArtifactFile(GraphNode node) {
        return this.resolvedArtifacts.get(node.getResult().getId());
    }

    private static class GraphNode {
        private final ComponentIdentifier id;
        private final ResolvedComponentResult result;
        private final Set<ConfigurationScope> inScopeConfigurations;

        private GraphNode(ResolvedComponentResult result) {
            this.id = result.getId();
            this.result = result;
            this.inScopeConfigurations = new HashSet<ConfigurationScope>();
        }

        private ResolvedComponentResult getResult() {
            return this.result;
        }

        private void inScopeConfiguration(String projectName, String configName) {
            this.inScopeConfigurations.add(new ConfigurationScope(projectName, configName));
        }

        private Set<ConfigurationScope> getInScopeConfigurations() {
            return this.inScopeConfigurations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GraphNode graphNode = (GraphNode)o;
            return Objects.equals(this.id, graphNode.id);
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }
    }
}

