/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.cyclonedx.Version;
import org.cyclonedx.gradle.BaseCyclonedxTask;
import org.cyclonedx.gradle.SbomBuilder;
import org.cyclonedx.gradle.SbomGraphProvider;
import org.cyclonedx.gradle.model.SbomGraph;
import org.cyclonedx.gradle.utils.CyclonedxUtils;
import org.cyclonedx.model.Bom;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CyclonedxDirectTask
extends BaseCyclonedxTask {
    private static final Logger LOGGER = Logging.getLogger(CyclonedxDirectTask.class);
    private final Provider<SbomGraph> componentsProvider;

    @Input
    public abstract ListProperty<String> getIncludeConfigs();

    @Input
    public abstract ListProperty<String> getSkipConfigs();

    @Input
    public abstract Property<Boolean> getIncludeMetadataResolution();

    @Input
    public abstract Property<Boolean> getIncludeBuildEnvironment();

    public CyclonedxDirectTask() {
        this.getIncludeConfigs().convention(new ArrayList());
        this.getSkipConfigs().convention(new ArrayList());
        this.getIncludeMetadataResolution().convention((Object)true);
        this.getIncludeBuildEnvironment().convention((Object)false);
        this.componentsProvider = this.getProject().getProviders().provider((Callable)new SbomGraphProvider(this.getProject(), this));
    }

    @TaskAction
    public void createBom() {
        this.logParameters();
        Bom bom = new SbomBuilder<CyclonedxDirectTask>(this).buildBom((SbomGraph)this.componentsProvider.get());
        LOGGER.info("{} Writing BOM", (Object)"[CycloneDX]");
        if (this.getJsonOutput().isPresent()) {
            CyclonedxUtils.writeJsonBom((Version)this.getSchemaVersion().get(), bom, (File)this.getJsonOutput().getAsFile().get());
        }
        if (this.getXmlOutput().isPresent()) {
            CyclonedxUtils.writeXmlBom((Version)this.getSchemaVersion().get(), bom, (File)this.getXmlOutput().getAsFile().get());
        }
    }

    private void logParameters() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("CycloneDX: Parameters");
            LOGGER.info("------------------------------------------------------------------------");
            LOGGER.info("schemaVersion             : {}", this.getSchemaVersion().get());
            LOGGER.info("includeLicenseText        : {}", this.getIncludeLicenseText().get());
            LOGGER.info("includeBomSerialNumber    : {}", this.getIncludeBomSerialNumber().get());
            LOGGER.info("includeConfigs            : {}", this.getIncludeConfigs().get());
            LOGGER.info("skipConfigs               : {}", this.getSkipConfigs().get());
            LOGGER.info("includeMetadataResolution : {}", this.getIncludeMetadataResolution().get());
            LOGGER.info("includeBuildEnvironment   : {}", this.getIncludeBuildEnvironment().get());
            LOGGER.info("jsonOutput                : {}", this.getJsonOutput().getOrNull());
            LOGGER.info("xmlOutput                 : {}", this.getXmlOutput().getOrNull());
            LOGGER.info("componentGroup            : {}", this.getComponentGroup().get());
            LOGGER.info("componentName             : {}", this.getComponentName().get());
            LOGGER.info("componentVersion          : {}", this.getComponentVersion().get());
            LOGGER.info("projectType               : {}", this.getProjectType().get());
            LOGGER.info("------------------------------------------------------------------------");
        }
    }
}

