/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.jspecify.annotations.Nullable;

public class SbomMetaData
implements Serializable {
    private @Nullable String publisher;
    private @Nullable String description;
    private final List<ExternalReference> externalReferences = new ArrayList<ExternalReference>();

    private SbomMetaData() {
    }

    public @Nullable String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(@Nullable String publisher) {
        this.publisher = publisher;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void addExternalReference(String type, String url) {
        this.externalReferences.add(new ExternalReference(type, url));
    }

    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public static SbomMetaData fromComponent(Component component) {
        SbomMetaData metaData = new SbomMetaData();
        metaData.setDescription(component.getDescription());
        metaData.setPublisher(component.getPublisher());
        if (component.getExternalReferences() != null) {
            component.getExternalReferences().forEach(reference -> metaData.addExternalReference(reference.getType().toString(), reference.getUrl()));
        }
        return metaData;
    }

    public static class ExternalReference
    extends org.cyclonedx.model.ExternalReference
    implements Serializable {
        public ExternalReference(String type, String url) {
            super.setType(ExternalReference.Type.fromString((String)type));
            super.setUrl(url);
        }
    }
}

