/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.model;

import java.io.Serializable;
import java.util.Objects;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;

public class SbomComponentId
implements Serializable {
    private final String group;
    private final String name;
    private final String version;
    private final @Nullable String type;
    private final @Nullable String gradleProjectPath;

    public SbomComponentId(String group, String name, String version, @Nullable String type, @Nullable String gradleProjectPath) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.type = type;
        this.gradleProjectPath = gradleProjectPath;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGroup() {
        return this.group;
    }

    public @Nullable String getType() {
        return this.type;
    }

    public @Nullable String getGradleProjectPath() {
        return this.gradleProjectPath;
    }

    public TreeMap<String, String> getQualifiers() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (this.gradleProjectPath != null) {
            result.put("project_path", this.gradleProjectPath);
        }
        if (this.type != null) {
            result.put("type", this.type);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SbomComponentId that = (SbomComponentId)o;
        return Objects.equals(this.group, that.group) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name, this.version, this.type);
    }

    public String toString() {
        return "SbomComponentId{group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", type='" + this.type + '\'' + ", gradleProjectPath='" + this.gradleProjectPath + '\'' + '}';
    }
}

