/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.model;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.model.License;
import org.cyclonedx.gradle.model.ConfigurationScope;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.model.SbomMetaData;
import org.jspecify.annotations.Nullable;

public final class SbomComponent
implements Serializable {
    private final SbomComponentId id;
    private final Set<ConfigurationScope> inScopeConfigurations;
    private final Set<SbomComponentId> dependencyComponents;
    private final @Nullable File artifactFile;
    private final @Nullable SbomMetaData metaData;
    private final List<License> licenses;

    private SbomComponent(SbomComponentId id, Set<ConfigurationScope> inScopeConfigurations, Set<SbomComponentId> dependencyComponents, @Nullable File artifactFile, @Nullable SbomMetaData metaData, List<License> licenses) {
        this.id = id;
        this.inScopeConfigurations = inScopeConfigurations;
        this.dependencyComponents = dependencyComponents;
        this.artifactFile = artifactFile;
        this.metaData = metaData;
        this.licenses = licenses;
    }

    public SbomComponentId getId() {
        return this.id;
    }

    public Set<ConfigurationScope> getInScopeConfigurations() {
        return this.inScopeConfigurations;
    }

    public Set<SbomComponentId> getDependencyComponents() {
        return this.dependencyComponents;
    }

    public Optional<File> getArtifactFile() {
        return Optional.ofNullable(this.artifactFile);
    }

    public Optional<SbomMetaData> getSbomMetaData() {
        return Optional.ofNullable(this.metaData);
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SbomComponent that = (SbomComponent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.inScopeConfigurations, that.inScopeConfigurations) && Objects.equals(this.dependencyComponents, that.dependencyComponents) && Objects.equals(this.artifactFile, that.artifactFile) && Objects.equals(this.metaData, that.metaData) && Objects.equals(this.licenses, that.licenses);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.inScopeConfigurations, this.dependencyComponents, this.artifactFile, this.metaData, this.licenses);
    }

    public static class Builder {
        private @Nullable SbomComponentId id;
        private Set<ConfigurationScope> inScopeConfigurations = Collections.emptySet();
        private Set<SbomComponentId> dependencyComponents = Collections.emptySet();
        private @Nullable File artifactFile;
        private @Nullable SbomMetaData metaData;
        private List<License> licenses = Collections.emptyList();

        public Builder withId(SbomComponentId id) {
            this.id = id;
            return this;
        }

        public Builder withInScopeConfigurations(Set<ConfigurationScope> inScopeConfigurations) {
            this.inScopeConfigurations = inScopeConfigurations;
            return this;
        }

        public Builder withDependencyComponents(Set<SbomComponentId> dependencyComponents) {
            this.dependencyComponents = dependencyComponents;
            return this;
        }

        public Builder withArtifactFile(@Nullable File artifactFile) {
            this.artifactFile = artifactFile;
            return this;
        }

        public Builder withMetaData(@Nullable SbomMetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder withLicenses(List<License> licenses) {
            this.licenses = licenses;
            return this;
        }

        public SbomComponent build() {
            return new SbomComponent(Objects.requireNonNull(this.id), this.inScopeConfigurations, this.dependencyComponents, this.artifactFile, this.metaData, this.licenses);
        }
    }
}

