/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.cyclonedx.gradle.CyclonedxAggregateTask;
import org.cyclonedx.gradle.CyclonedxDirectTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class CyclonedxPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(CyclonedxPlugin.class);
    public static final String LOG_PREFIX = "[CycloneDX]";
    protected final String cyclonedxDirectTaskName;
    protected final String cyclonedxDirectConfigurationName;
    protected final String cyclonedxAggregateTaskName;
    protected final String cyclonedxAggregateConfigurationName;
    protected final String cyclonedxDirectReportDir;
    protected final String cyclonedxAggregateReportDir;

    @Inject
    public CyclonedxPlugin() {
        this("cyclonedxDirectBom", "cyclonedxDirectBom", "cyclonedxBom", "cyclonedxBom", "reports/cyclonedx-direct", "reports/cyclonedx");
    }

    protected CyclonedxPlugin(String cyclonedxDirectTaskName, String cyclonedxDirectConfigurationName, String cyclonedxAggregateTaskName, String cyclonedxAggregateConfigurationName, String cyclonedxDirectReportDir, String cyclonedxAggregateReportDir) {
        this.cyclonedxDirectTaskName = cyclonedxDirectTaskName;
        this.cyclonedxDirectConfigurationName = cyclonedxDirectConfigurationName;
        this.cyclonedxAggregateTaskName = cyclonedxAggregateTaskName;
        this.cyclonedxAggregateConfigurationName = cyclonedxAggregateConfigurationName;
        this.cyclonedxDirectReportDir = cyclonedxDirectReportDir;
        this.cyclonedxAggregateReportDir = cyclonedxAggregateReportDir;
    }

    public void apply(Project project) {
        if (!JavaVersion.current().isCompatibleWith(JavaVersion.VERSION_17)) {
            LOGGER.warn("warning: {} Support of Java versions prior to 17 is deprecated and will be removed in a future release.", (Object)LOG_PREFIX);
        }
        CyclonedxPlugin.getProjectAndSubprojects(project).forEach(this::configureProject);
        Configuration cyclonedxBomAggregateConfiguration = (Configuration)project.getConfigurations().maybeCreate(this.cyclonedxAggregateConfigurationName);
        cyclonedxBomAggregateConfiguration.setCanBeResolved(true);
        cyclonedxBomAggregateConfiguration.setCanBeConsumed(false);
        this.registerCyclonedxAggregateBomTask(project, cyclonedxBomAggregateConfiguration);
        CyclonedxPlugin.getProjectAndSubprojects(project).forEach(subProject -> subProject.afterEvaluate(evaluatedProject -> {
            if (this.shouldSkipProject((Project)evaluatedProject)) {
                LOGGER.info("{} Project [{}] skipped because direct BOM task [{}] not found or disabled in the project", new Object[]{LOG_PREFIX, evaluatedProject.getDisplayName(), this.cyclonedxDirectTaskName});
                return;
            }
            evaluatedProject.getTasksByName(this.cyclonedxDirectTaskName, false).forEach(task -> task.getOutputs().getFiles().getFiles().forEach(file -> evaluatedProject.getArtifacts().add(this.cyclonedxDirectConfigurationName, file, a -> a.builtBy(new Object[]{task}))));
            project.getDependencies().add(this.cyclonedxAggregateConfigurationName, (Object)project.getDependencies().project((Map)ImmutableMap.of((Object)"path", (Object)evaluatedProject.getPath(), (Object)"configuration", (Object)this.cyclonedxDirectConfigurationName)));
        }));
    }

    private static Stream<Project> getProjectAndSubprojects(Project project) {
        return Stream.concat(Stream.of(project), project.getSubprojects().stream());
    }

    private void configureProject(Project project) {
        Configuration cyclonedxBomConfiguration = (Configuration)project.getConfigurations().maybeCreate(this.cyclonedxDirectConfigurationName);
        cyclonedxBomConfiguration.setCanBeConsumed(true);
        cyclonedxBomConfiguration.setCanBeResolved(false);
        this.registerCyclonedxDirectBomTask(project);
    }

    private void registerCyclonedxAggregateBomTask(Project project, Configuration cyclonedxBomAggregateConfiguration) {
        project.getTasks().register(this.cyclonedxAggregateTaskName, CyclonedxAggregateTask.class, task -> {
            task.dependsOn(CyclonedxPlugin.getProjectAndSubprojects(project).map(p -> p.getPath() + ":" + p.getTasks().named(this.cyclonedxDirectTaskName).getName()).toArray(Object[]::new));
            Provider aggregateReportDir = project.getLayout().getBuildDirectory().dir(this.cyclonedxAggregateReportDir);
            task.getXmlOutput().convention(((Directory)aggregateReportDir.get()).file("bom.xml"));
            task.getJsonOutput().convention(((Directory)aggregateReportDir.get()).file("bom.json"));
            Provider files = project.getProviders().provider(() -> project.getObjects().fileCollection().from(new Object[]{cyclonedxBomAggregateConfiguration}));
            task.getInputSboms().from(new Object[]{files});
        });
    }

    private void registerCyclonedxDirectBomTask(Project project) {
        if (!project.getTasks().withType(CyclonedxDirectTask.class).isEmpty()) {
            LOGGER.info("{} Task [{}] already exists in project [{}], skipping creation", new Object[]{LOG_PREFIX, this.cyclonedxDirectTaskName, project.getDisplayName()});
            return;
        }
        project.getTasks().register(this.cyclonedxDirectTaskName, CyclonedxDirectTask.class, task -> {
            Provider dir = project.getLayout().getBuildDirectory().dir(this.cyclonedxDirectReportDir);
            task.getXmlOutput().convention(((Directory)dir.get()).file("bom.xml"));
            task.getJsonOutput().convention(((Directory)dir.get()).file("bom.json"));
        });
    }

    private boolean shouldSkipProject(Project project) {
        TaskProvider directTask = project.getTasks().named(this.cyclonedxDirectTaskName);
        return !directTask.isPresent() || !((Task)directTask.get()).getEnabled();
    }
}

