/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.cyclonedx.Version;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.gradle.BaseCyclonedxTask;
import org.cyclonedx.gradle.SbomBuilder;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.model.SbomGraph;
import org.cyclonedx.gradle.utils.CyclonedxUtils;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.BomReference;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.parsers.BomParserFactory;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CyclonedxAggregateTask
extends BaseCyclonedxTask {
    private static final Logger LOGGER = Logging.getLogger(CyclonedxAggregateTask.class);
    protected final Provider<String> getProjectPath = this.getProject().getProviders().provider(() -> this.getProject().getPath());

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    abstract ConfigurableFileCollection getInputSboms();

    @TaskAction
    public void aggregate() throws Exception {
        this.logParameters();
        Bom merged = this.mergeAll(this.getInputSboms().getFiles());
        LOGGER.info("{} Writing BOM", (Object)"[CycloneDX]");
        if (this.getJsonOutput().isPresent()) {
            CyclonedxUtils.writeJsonBom((Version)this.getSchemaVersion().get(), merged, (File)this.getJsonOutput().getAsFile().get());
        }
        if (this.getXmlOutput().isPresent()) {
            CyclonedxUtils.writeXmlBom((Version)this.getSchemaVersion().get(), merged, (File)this.getXmlOutput().getAsFile().get());
        }
    }

    private Bom mergeAll(Set<File> files) throws ParseException {
        LOGGER.info("{} Received files: {}", (Object)"[CycloneDX]", files);
        Bom aggregateBom = this.getRootProjectBom();
        TreeMap<String, Component> componentsByBomRef = new TreeMap<String, Component>();
        TreeMap<String, Set> dependenciesByBomRef = new TreeMap<String, Set>();
        for (File subProjectBomFile : files) {
            Bom subProjectBom = BomParserFactory.createParser((File)subProjectBomFile).parse(subProjectBomFile);
            if (!aggregateBom.getMetadata().getComponent().getBomRef().equals(subProjectBom.getMetadata().getComponent().getBomRef())) {
                LOGGER.info("{} Adding sub-project component:[{}] {}", new Object[]{"[CycloneDX]", aggregateBom.getMetadata().getComponent().getBomRef(), subProjectBom.getMetadata().getComponent().getBomRef()});
                componentsByBomRef.putIfAbsent(subProjectBom.getMetadata().getComponent().getBomRef(), subProjectBom.getMetadata().getComponent());
            }
            if (subProjectBom.getComponents() == null) continue;
            for (Component component : subProjectBom.getComponents()) {
                componentsByBomRef.putIfAbsent(component.getBomRef(), component);
            }
            if (subProjectBom.getDependencies() == null) continue;
            for (Dependency dependency : subProjectBom.getDependencies()) {
                String bomRef = dependency.getRef();
                if (dependency.getDependencies() == null || bomRef == null) continue;
                dependenciesByBomRef.compute(bomRef, (key, existingDeps) -> {
                    List nextLevelDeps = dependency.getDependencies().stream().map(BomReference::getRef).filter(ref -> !ref.equals(key)).collect(Collectors.toList());
                    if (existingDeps == null) {
                        return new TreeSet(nextLevelDeps);
                    }
                    existingDeps.addAll(nextLevelDeps);
                    return existingDeps;
                });
            }
        }
        aggregateBom.setComponents(new ArrayList(componentsByBomRef.values()));
        aggregateBom.setDependencies(dependenciesByBomRef.entrySet().stream().map(entry -> {
            Dependency dependency = new Dependency((String)entry.getKey());
            dependency.setDependencies(((Set)entry.getValue()).stream().map(Dependency::new).collect(Collectors.toList()));
            return dependency;
        }).collect(Collectors.toList()));
        return aggregateBom;
    }

    private Bom getRootProjectBom() {
        SbomComponent updatedRootComponent = new SbomComponent.Builder().withId(new SbomComponentId((String)this.getComponentGroup().get(), (String)this.getComponentName().get(), (String)this.getComponentVersion().get(), null, (String)this.getProjectPath.get())).build();
        return new SbomBuilder<CyclonedxAggregateTask>(this).buildBom(new SbomGraph(Collections.emptyMap(), updatedRootComponent));
    }

    private void logParameters() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("CycloneDX Aggregate: Parameters");
            LOGGER.info("------------------------------------------------------------------------");
            LOGGER.info("schemaVersion             : {}", this.getSchemaVersion().get());
            LOGGER.info("includeLicenseText        : {}", this.getIncludeLicenseText().get());
            LOGGER.info("includeBomSerialNumber    : {}", this.getIncludeBomSerialNumber().get());
            LOGGER.info("jsonOutput                : {}", this.getJsonOutput().getOrNull());
            LOGGER.info("xmlOutput                 : {}", this.getXmlOutput().getOrNull());
            LOGGER.info("componentGroup            : {}", this.getComponentGroup().get());
            LOGGER.info("componentName             : {}", this.getComponentName().get());
            LOGGER.info("componentVersion          : {}", this.getComponentVersion().get());
            LOGGER.info("projectType               : {}", this.getProjectType().get());
            LOGGER.info("------------------------------------------------------------------------");
        }
    }
}

