/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import org.cyclonedx.Version;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalEntity;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

@CacheableTask
public abstract class BaseCyclonedxTask
extends DefaultTask {
    @Input
    public abstract Property<String> getComponentGroup();

    @Input
    public abstract Property<String> getComponentName();

    @Input
    public abstract Property<String> getComponentVersion();

    @Input
    public abstract Property<Version> getSchemaVersion();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getXmlOutput();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getJsonOutput();

    @Input
    public abstract Property<Boolean> getIncludeBomSerialNumber();

    @Input
    public abstract Property<Component.Type> getProjectType();

    @Input
    public abstract Property<Boolean> getIncludeBuildSystem();

    @Input
    @Optional
    public abstract Property<String> getBuildSystemEnvironmentVariable();

    @Internal
    public abstract Property<OrganizationalEntity> getOrganizationalEntity();

    @Internal
    public abstract Property<LicenseChoice> getLicenseChoice();

    @Internal
    public abstract ListProperty<ExternalReference> getExternalReferences();

    @Input
    public abstract Property<Boolean> getIncludeLicenseText();

    public BaseCyclonedxTask() {
        this.getComponentGroup().convention(this.getProject().getProviders().provider(() -> this.getProject().getGroup().toString()));
        this.getComponentName().convention(this.getProject().getProviders().provider(() -> this.getProject().getName()));
        this.getComponentVersion().convention(this.getProject().getProviders().provider(() -> this.getProject().getVersion().toString()));
        this.getSchemaVersion().convention((Object)Version.VERSION_16);
        this.getIncludeLicenseText().convention((Object)false);
        this.getIncludeBomSerialNumber().convention((Object)true);
        this.getProjectType().convention((Object)Component.Type.LIBRARY);
        this.getIncludeBuildSystem().convention((Object)true);
        this.getOrganizationalEntity().convention((Provider)this.getProject().getObjects().property(OrganizationalEntity.class));
        this.getLicenseChoice().convention((Provider)this.getProject().getObjects().property(LicenseChoice.class));
        this.getExternalReferences().convention((Provider)this.getProject().getObjects().listProperty(ExternalReference.class));
    }
}

