/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public final class GitUtils {
    private GitUtils() {
    }

    @Nullable
    public static String getGitUrlFromEnvironmentVariable() {
        return System.getenv("GIT_URL");
    }

    @Nullable
    public static String getGitUrlFromGitRepo() {
        String string;
        Process process = Runtime.getRuntime().exec(new String[]{"git", "remote", "get-url", "origin"});
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ignore) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    public static String sanitizeGitUrl(String gitUrl) throws URISyntaxException {
        if (gitUrl.startsWith("git@")) {
            return new URI("ssh://" + gitUrl).toString();
        }
        if (gitUrl.startsWith("ssh://")) {
            return new URI(gitUrl).toString();
        }
        URI uri = new URI(gitUrl);
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment()).toString();
    }
}

