/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import java.net.URISyntaxException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.cyclonedx.gradle.utils.GitUtils;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.gradle.api.logging.Logger;

public class ExternalReferencesUtil {
    private ExternalReferencesUtil() {
    }

    public static void complementByEnvironment(@Nonnull Component component, @Nonnull Logger logger) {
        ExternalReferencesUtil.addGitReference(component, logger);
    }

    private static void addGitReference(@Nonnull Component component, @Nonnull Logger logger) {
        if (component.getExternalReferences() != null && component.getExternalReferences().stream().filter(Objects::nonNull).anyMatch(er -> ExternalReference.Type.VCS == er.getType())) {
            return;
        }
        String gitUrl = GitUtils.getGitUrlFromEnvironmentVariable();
        if (gitUrl == null || gitUrl.isEmpty()) {
            gitUrl = GitUtils.getGitUrlFromGitRepo();
        }
        if (gitUrl == null) {
            return;
        }
        try {
            gitUrl = GitUtils.sanitizeGitUrl(gitUrl);
        }
        catch (URISyntaxException e) {
            logger.warn("Invalid Git URL identified from environment, ignoring it");
            return;
        }
        ExternalReference externalReference = new ExternalReference();
        externalReference.setType(ExternalReference.Type.VCS);
        externalReference.setUrl(gitUrl);
        component.addExternalReference(externalReference);
    }
}

