/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.cyclonedx.Version;
import org.cyclonedx.gradle.SbomBuilder;
import org.cyclonedx.gradle.SbomGraphProvider;
import org.cyclonedx.gradle.model.SbomGraph;
import org.cyclonedx.gradle.utils.CycloneDxUtils;
import org.cyclonedx.gradle.utils.GitUtils;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class CycloneDxTask
extends DefaultTask {
    private static final String MESSAGE_WRITING_BOM_OUTPUT = "CycloneDX: Writing BOM output";
    private static final Component.Type DEFAULT_PROJECT_TYPE = Component.Type.LIBRARY;
    final Property<String> outputName;
    final Property<String> outputFormat;
    final Property<File> destination;
    public final Property<Version> schemaVersion;
    private final Property<String> schemaVersionAsString;
    public final Property<String> componentName;
    public final Property<String> componentVersion;
    public final Property<Boolean> includeBomSerialNumber;
    public final ListProperty<String> skipConfigs;
    public final ListProperty<String> includeConfigs;
    public final Property<Boolean> includeMetadataResolution;
    public final Property<Boolean> includeLicenseText;
    public final Property<Component.Type> projectType;
    private final Property<String> projectTypeAsString;
    private final ListProperty<String> skipProjects;
    public final Property<Boolean> includeBuildSystem;
    public final Property<String> buildSystemEnvironmentVariable;
    public final Property<OrganizationalEntity> organizationalEntity;
    public final Property<LicenseChoice> licenseChoice;
    public final ListProperty<ExternalReference> externalReferences;
    private final Provider<SbomGraph> componentsProvider = this.getProject().getProviders().provider((Callable)new SbomGraphProvider(this.getProject(), this));

    @OutputFile
    @Optional
    public abstract RegularFileProperty getXmlOutput();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getJsonOutput();

    public CycloneDxTask() {
        this.outputName = this.getProject().getObjects().property(String.class);
        this.outputName.convention((Object)"bom");
        this.schemaVersion = this.getProject().getObjects().property(Version.class);
        this.schemaVersion.convention((Object)CycloneDxUtils.DEFAULT_SCHEMA_VERSION);
        this.schemaVersionAsString = this.getProject().getObjects().property(String.class);
        this.schemaVersionAsString.convention(this.getProject().getProviders().provider(() -> ((Version)this.schemaVersion.get()).getVersionString()));
        this.componentName = this.getProject().getObjects().property(String.class);
        this.componentName.convention((Object)this.getProject().getName());
        this.componentVersion = this.getProject().getObjects().property(String.class);
        this.componentVersion.convention(this.getProject().getProviders().provider(() -> this.getProject().getVersion().toString()));
        this.outputFormat = this.getProject().getObjects().property(String.class);
        this.outputFormat.convention((Object)"all");
        this.includeBomSerialNumber = this.getProject().getObjects().property(Boolean.class);
        this.includeBomSerialNumber.convention((Object)true);
        this.skipConfigs = this.getProject().getObjects().listProperty(String.class);
        this.includeConfigs = this.getProject().getObjects().listProperty(String.class);
        this.includeMetadataResolution = this.getProject().getObjects().property(Boolean.class);
        this.includeMetadataResolution.convention((Object)true);
        this.includeLicenseText = this.getProject().getObjects().property(Boolean.class);
        this.includeLicenseText.convention((Object)true);
        this.projectType = this.getProject().getObjects().property(Component.Type.class);
        this.projectType.convention((Object)DEFAULT_PROJECT_TYPE);
        this.projectTypeAsString = this.getProject().getObjects().property(String.class);
        this.projectTypeAsString.convention(this.getProject().getProviders().provider(() -> ((Component.Type)this.projectType.get()).getTypeName()));
        this.skipProjects = this.getProject().getObjects().listProperty(String.class);
        this.organizationalEntity = this.getProject().getObjects().property(OrganizationalEntity.class);
        this.licenseChoice = this.getProject().getObjects().property(LicenseChoice.class);
        this.externalReferences = this.getProject().getObjects().listProperty(ExternalReference.class);
        this.destination = this.getProject().getObjects().property(File.class);
        this.destination.convention((Object)((Directory)this.getProject().getLayout().getBuildDirectory().dir("reports").get()).getAsFile());
        this.includeBuildSystem = this.getProject().getObjects().property(Boolean.class);
        this.includeBuildSystem.convention((Object)false);
        this.buildSystemEnvironmentVariable = this.getProject().getObjects().property(String.class);
    }

    @Input
    @Deprecated
    public Property<String> getOutputName() {
        return this.outputName;
    }

    @Deprecated
    public void setOutputName(String output) {
        this.outputName.set((Object)output);
    }

    @Input
    public Property<String> getSchemaVersion() {
        return this.schemaVersionAsString;
    }

    @Deprecated
    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion.set((Object)Version.fromVersionString((String)schemaVersion));
    }

    @Deprecated
    public void setSchemaVersion(Version schemaVersion) {
        this.schemaVersion.set((Object)schemaVersion);
    }

    @Input
    public Property<String> getComponentName() {
        return this.componentName;
    }

    @Deprecated
    public void setComponentName(String componentName) {
        this.componentName.set((Object)componentName);
    }

    @Input
    public Property<String> getComponentVersion() {
        return this.componentVersion;
    }

    @Deprecated
    public void setComponentVersion(String componentVersion) {
        this.componentVersion.set((Object)componentVersion);
    }

    @Input
    @Deprecated
    public Property<String> getOutputFormat() {
        return this.outputFormat;
    }

    @Deprecated
    public void setOutputFormat(String format) {
        this.outputFormat.set((Object)format);
    }

    @Input
    public Property<Boolean> getIncludeBomSerialNumber() {
        return this.includeBomSerialNumber;
    }

    @Deprecated
    public void setIncludeBomSerialNumber(boolean includeBomSerialNumber) {
        this.includeBomSerialNumber.set((Object)includeBomSerialNumber);
    }

    @Input
    public ListProperty<String> getSkipConfigs() {
        return this.skipConfigs;
    }

    @Deprecated
    public void setSkipConfigs(Collection<String> skipConfigs) {
        this.skipConfigs.addAll(skipConfigs);
    }

    @Input
    public ListProperty<String> getIncludeConfigs() {
        return this.includeConfigs;
    }

    @Deprecated
    public void setIncludeConfigs(Collection<String> includeConfigs) {
        this.includeConfigs.addAll(includeConfigs);
    }

    @Input
    public Property<Boolean> getIncludeMetadataResolution() {
        return this.includeMetadataResolution;
    }

    @Deprecated
    public void setIncludeMetadataResolution(boolean includeMetadataResolution) {
        this.includeMetadataResolution.set((Object)includeMetadataResolution);
    }

    @Input
    public Property<Boolean> getIncludeLicenseText() {
        return this.includeLicenseText;
    }

    @Deprecated
    public void setIncludeLicenseText(boolean includeLicenseText) {
        this.includeLicenseText.set((Object)includeLicenseText);
    }

    @Input
    public Property<String> getProjectType() {
        return this.projectTypeAsString;
    }

    @Deprecated
    public void setProjectType(String projectType) {
        this.projectType.set((Object)Component.Type.valueOf((String)projectType.toUpperCase(Locale.ROOT)));
    }

    @Deprecated
    public void setProjectType(Component.Type projectType) {
        this.projectType.set((Object)projectType);
    }

    @Input
    public ListProperty<String> getSkipProjects() {
        return this.skipProjects;
    }

    @Deprecated
    public void setSkipProjects(Collection<String> skipProjects) {
        this.skipProjects.addAll(skipProjects);
    }

    @Input
    public Property<Boolean> getIncludeBuildSystem() {
        return this.includeBuildSystem;
    }

    @Deprecated
    public void setIncludeBuildSystem(boolean includeBuildSystem) {
        this.includeBuildSystem.set((Object)includeBuildSystem);
    }

    @Input
    @Optional
    public Property<String> getBuildSystemEnvironmentVariable() {
        return this.buildSystemEnvironmentVariable;
    }

    @Deprecated
    public void setBuildSystemEnvironmentVariable(String buildSystemEnvironmentVariable) {
        this.buildSystemEnvironmentVariable.set((Object)buildSystemEnvironmentVariable);
    }

    @Internal
    @Nullable
    OrganizationalEntity getOrganizationalEntity() {
        return (OrganizationalEntity)this.organizationalEntity.getOrNull();
    }

    @Internal
    @Nullable
    LicenseChoice getLicenseChoice() {
        return (LicenseChoice)this.licenseChoice.getOrNull();
    }

    @Internal
    List<ExternalReference> getExternalReferences() {
        return (List)this.externalReferences.get();
    }

    @Internal
    @Deprecated
    @Nullable
    ExternalReference getGitVCS() {
        return (ExternalReference)((List)this.externalReferences.get()).get(0);
    }

    @Internal
    @Deprecated
    public Property<File> getDestination() {
        return this.destination;
    }

    @Deprecated
    public void setDestination(File destination) {
        this.destination.set((Object)destination);
    }

    @TaskAction
    public void createBom() {
        this.logParameters();
        SbomBuilder builder = new SbomBuilder(this.getLogger(), this);
        SbomGraph components = (SbomGraph)this.componentsProvider.get();
        Bom bom = builder.buildBom(components.getGraph(), components.getRootComponent());
        this.getLogger().info(MESSAGE_WRITING_BOM_OUTPUT);
        if (this.getJsonOutput().isPresent()) {
            CycloneDxUtils.writeJSONBom((Version)this.schemaVersion.get(), bom, (File)this.getJsonOutput().getAsFile().get());
        }
        if (this.getXmlOutput().isPresent()) {
            CycloneDxUtils.writeXmlBom((Version)this.schemaVersion.get(), bom, (File)this.getXmlOutput().getAsFile().get());
        }
    }

    @Deprecated
    public void setOrganizationalEntity(Consumer<OrganizationalEntity> customizer) {
        int i;
        OrganizationalEntity origin = new OrganizationalEntity();
        customizer.accept(origin);
        this.organizationalEntity.set((Object)origin);
        HashMap<String, String> organizationalEntity = new HashMap<String, String>();
        organizationalEntity.put("name", origin.getName());
        if (origin.getUrls() != null) {
            for (i = 0; i < origin.getUrls().size(); ++i) {
                organizationalEntity.put("url" + i, (String)origin.getUrls().get(i));
            }
        }
        if (origin.getContacts() != null) {
            for (i = 0; i < origin.getContacts().size(); ++i) {
                organizationalEntity.put("contact_name" + i, ((OrganizationalContact)origin.getContacts().get(i)).getName());
                organizationalEntity.put("contact_email" + i, ((OrganizationalContact)origin.getContacts().get(i)).getEmail());
                organizationalEntity.put("contact_phone" + i, ((OrganizationalContact)origin.getContacts().get(i)).getPhone());
            }
        }
        this.getInputs().property("OrganizationalEntity", organizationalEntity);
    }

    @Deprecated
    public void setLicenseChoice(Consumer<LicenseChoice> customizer) {
        LicenseChoice origin = new LicenseChoice();
        customizer.accept(origin);
        this.licenseChoice.set((Object)origin);
        HashMap<String, String> licenseChoice = new HashMap<String, String>();
        if (origin.getLicenses() != null) {
            for (int i = 0; i < origin.getLicenses().size(); ++i) {
                if (((License)origin.getLicenses().get(i)).getName() != null) {
                    licenseChoice.put("licenseChoice" + i + "name", ((License)origin.getLicenses().get(i)).getName());
                }
                if (((License)origin.getLicenses().get(i)).getId() != null) {
                    licenseChoice.put("licenseChoice" + i + "id", ((License)origin.getLicenses().get(i)).getId());
                }
                licenseChoice.put("licenseChoice" + i + "text", ((License)origin.getLicenses().get(i)).getAttachmentText().getText());
                licenseChoice.put("licenseChoice" + i + "url", ((License)origin.getLicenses().get(i)).getUrl());
            }
        }
        if (origin.getExpression() != null) {
            licenseChoice.put("licenseChoice_Expression", origin.getExpression().getValue());
        }
        this.getInputs().property("LicenseChoice", licenseChoice);
    }

    @Deprecated
    public void setVCSGit(Consumer<ExternalReference> customizer) {
        ExternalReference origin = new ExternalReference();
        customizer.accept(origin);
        try {
            origin.setUrl(GitUtils.sanitizeGitUrl(origin.getUrl()));
        }
        catch (URISyntaxException e) {
            this.getLogger().warn("CycloneDX: Invalid Git URL provided, ignoring it");
            return;
        }
        origin.setType(ExternalReference.Type.VCS);
        this.externalReferences.add((Object)origin);
        HashMap<String, String> externalReference = new HashMap<String, String>();
        externalReference.put("type", origin.getType().toString());
        externalReference.put("url", origin.getUrl());
        externalReference.put("comment", origin.getComment());
        this.getInputs().property("GitVCS", externalReference);
    }

    private void logParameters() {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("CycloneDX: Parameters");
            this.getLogger().info("------------------------------------------------------------------------");
            this.getLogger().info("schemaVersion             : " + this.schemaVersion.get());
            this.getLogger().info("includeLicenseText        : " + this.includeLicenseText.get());
            this.getLogger().info("includeBomSerialNumber    : " + this.includeBomSerialNumber.get());
            this.getLogger().info("includeConfigs            : " + this.includeConfigs.get());
            this.getLogger().info("skipConfigs               : " + this.skipConfigs.get());
            this.getLogger().info("skipProjects              : " + this.skipProjects.get());
            this.getLogger().info("includeMetadataResolution : " + this.includeMetadataResolution.get());
            this.getLogger().info("componentName             : " + (String)this.componentName.get());
            this.getLogger().info("componentVersion          : " + (String)this.componentVersion.get());
            this.getLogger().info("projectType               : " + this.projectType.get());
            this.getLogger().info("jsonOutput                : {}", this.getJsonOutput().getOrNull());
            this.getLogger().info("xmlOutput                 : {}", this.getXmlOutput().getOrNull());
            this.getLogger().info("------------------------------------------------------------------------");
        }
    }
}

