/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import org.cyclonedx.gradle.CycloneDxTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;

public class CycloneDxPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().register("cyclonedxBom", CycloneDxTask.class, task -> {
            task.setGroup("Reporting");
            task.setDescription("Generates a CycloneDX compliant Software Bill of Materials (SBOM)");
            task.getJsonOutput().convention(project.getProviders().provider(() -> {
                if (!((String)task.outputFormat.get()).equals("all") && !((String)task.outputFormat.get()).equals("json")) {
                    return null;
                }
                return (RegularFile)project.getLayout().file(project.getProviders().provider(() -> new File((File)task.destination.get(), String.format("%s.json", task.outputName.get())))).get();
            }));
            task.getXmlOutput().convention(project.getProviders().provider(() -> {
                if (!((String)task.outputFormat.get()).equals("all") && !((String)task.outputFormat.get()).equals("xml")) {
                    return null;
                }
                return (RegularFile)project.getLayout().file(project.getProviders().provider(() -> new File((File)task.destination.get(), String.format("%s.xml", task.outputName.get())))).get();
            }));
        });
    }
}

