/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;

public class DependencyUtils {
    private static final String UNSPECIFIED = "unspecified";

    public static Map<SbomComponentId, SbomComponent> mergeGraphs(Map<SbomComponentId, SbomComponent> firstGraph, Map<SbomComponentId, SbomComponent> secondGraph) {
        HashMap<SbomComponentId, SbomComponent> mergedGraph = new HashMap<SbomComponentId, SbomComponent>(firstGraph);
        secondGraph.keySet().stream().forEach(id -> {
            if (firstGraph.containsKey(id)) {
                SbomComponent resultComponent = (SbomComponent)mergedGraph.get(id);
                SbomComponent targetComponent = (SbomComponent)secondGraph.get(id);
                resultComponent.getDependencyComponents().addAll(targetComponent.getDependencyComponents());
                resultComponent.getInScopeConfigurations().addAll(targetComponent.getInScopeConfigurations());
            } else {
                mergedGraph.put((SbomComponentId)id, (SbomComponent)secondGraph.get(id));
            }
        });
        return mergedGraph;
    }

    public static SbomComponentId toComponentId(ResolvedComponentResult node, File file) {
        String type = null;
        String projectPath = null;
        if (node.getId() instanceof ModuleComponentIdentifier) {
            type = file != null ? DependencyUtils.getType(file) : "pom";
        } else if (node.getId() instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier id = (ProjectComponentIdentifier)node.getId();
            projectPath = id.getProjectPath();
        }
        if (node.getModuleVersion() != null) {
            return new SbomComponentId(node.getModuleVersion().getGroup(), node.getModuleVersion().getName(), node.getModuleVersion().getVersion(), type, projectPath);
        }
        return new SbomComponentId(UNSPECIFIED, node.getId().getDisplayName(), UNSPECIFIED, type, projectPath);
    }

    private static String getType(File file) {
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        if (StringUtils.isBlank((CharSequence)fileExtension)) {
            return "pom";
        }
        return fileExtension;
    }

    public static String generatePackageUrl(SbomComponentId componentId) throws MalformedPackageURLException {
        return new PackageURL("maven", componentId.getGroup().isEmpty() ? UNSPECIFIED : componentId.getGroup(), componentId.getName(), componentId.getVersion().isEmpty() ? UNSPECIFIED : componentId.getVersion(), componentId.getQualifiers(), null).canonicalize();
    }
}

