/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.cyclonedx.Version;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.Parser;
import org.cyclonedx.parsers.XmlParser;
import org.gradle.api.GradleException;

public class CycloneDxUtils {
    public static final Version DEFAULT_SCHEMA_VERSION = Version.VERSION_16;

    public static Version schemaVersion(String version) {
        switch (version) {
            case "1.0": {
                return Version.VERSION_10;
            }
            case "1.1": {
                return Version.VERSION_11;
            }
            case "1.2": {
                return Version.VERSION_12;
            }
            case "1.3": {
                return Version.VERSION_13;
            }
            case "1.4": {
                return Version.VERSION_14;
            }
            case "1.5": {
                return Version.VERSION_15;
            }
            case "1.6": {
                return Version.VERSION_16;
            }
        }
        return DEFAULT_SCHEMA_VERSION;
    }

    public static void writeBom(Bom bom, File destination, String outputName, Version version, String formats) {
        if (formats.equals("all") || formats.equals("json")) {
            File jsonFile = new File(destination, String.format("%s.json", outputName));
            CycloneDxUtils.writeJSONBom(version, bom, jsonFile);
        }
        if (formats.equals("all") || formats.equals("xml")) {
            File xmlFile = new File(destination, String.format("%s.xml", outputName));
            CycloneDxUtils.writeXmlBom(version, bom, xmlFile);
        }
    }

    private static void writeJSONBom(Version schemaVersion, Bom bom, File destination) {
        BomJsonGenerator bomGenerator = BomGeneratorFactory.createJson((Version)schemaVersion, (Bom)bom);
        try {
            String bomString = bomGenerator.toJsonString();
            FileUtils.write((File)destination, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (Exception e) {
            throw new GradleException("Error writing json bom file", (Throwable)e);
        }
        CycloneDxUtils.validateBom((Parser)new JsonParser(), schemaVersion, destination);
    }

    private static void writeXmlBom(Version schemaVersion, Bom bom, File destination) {
        BomXmlGenerator bomGenerator = BomGeneratorFactory.createXml((Version)schemaVersion, (Bom)bom);
        try {
            String bomString = bomGenerator.toXmlString();
            FileUtils.write((File)destination, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (Exception e) {
            throw new GradleException("Error writing xml bom file", (Throwable)e);
        }
        CycloneDxUtils.validateBom((Parser)new XmlParser(), schemaVersion, destination);
    }

    private static void validateBom(Parser bomParser, Version schemaVersion, File destination) {
        try {
            List exceptions = bomParser.validate(destination, schemaVersion);
            if (!exceptions.isEmpty()) {
                throw (ParseException)exceptions.get(0);
            }
        }
        catch (Exception e) {
            throw new GradleException("Error whilst validating XML BOM", (Throwable)e);
        }
    }
}

