/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.cyclonedx.model.Component;

public class SbomMetaData
implements Serializable {
    @Nullable
    private String publisher;
    @Nullable
    private String description;
    private final List<ExternalReference> externalReferences = new ArrayList<ExternalReference>();

    private SbomMetaData() {
    }

    @Nullable
    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(@Nullable String publisher) {
        this.publisher = publisher;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void addExternalReference(String type, String url) {
        this.externalReferences.add(new ExternalReference(type, url));
    }

    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public static SbomMetaData fromComponent(Component component) {
        SbomMetaData metaData = new SbomMetaData();
        metaData.setDescription(component.getDescription());
        metaData.setPublisher(component.getPublisher());
        if (component.getExternalReferences() != null) {
            component.getExternalReferences().forEach(reference -> metaData.addExternalReference(reference.getType().toString(), reference.getUrl()));
        }
        return metaData;
    }

    public static class ExternalReference
    implements Serializable {
        private final String type;
        private final String url;

        private ExternalReference(String type, String url) {
            this.type = type;
            this.url = url;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

