/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.License;
import org.cyclonedx.gradle.CycloneDxTask;
import org.cyclonedx.gradle.DependencyGraphTraverser;
import org.cyclonedx.gradle.MavenProjectLookup;
import org.cyclonedx.gradle.model.ConfigurationScope;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.model.SbomGraph;
import org.cyclonedx.gradle.utils.DependencyUtils;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;

class SbomGraphProvider
implements Callable<SbomGraph> {
    private static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    private static final ResolvedArtifactResult[] ARTIFACT_TYPE = new ResolvedArtifactResult[0];
    private final Project project;
    private final CycloneDxTask task;
    private final MavenProjectLookup mavenLookup;

    SbomGraphProvider(Project project, CycloneDxTask task) {
        this.project = project;
        this.task = task;
        this.mavenLookup = new MavenProjectLookup(project);
    }

    @Override
    public SbomGraph call() throws Exception {
        if (this.project.getGroup().equals("") || this.project.getVersion().equals("")) {
            this.project.getLogger().warn("Project group or version are not set for project [{}], will use \"unspecified\"", (Object)this.project.getName());
        }
        this.project.getLogger().info(MESSAGE_RESOLVING_DEPS);
        Map graph = Stream.concat(Stream.of(this.project), this.project.getSubprojects().stream()).filter(this::filterProjects).flatMap(this::traverseProject).reduce(new HashMap(), DependencyUtils::mergeGraphs);
        return this.buildSbomGraph(graph);
    }

    private SbomGraph buildSbomGraph(Map<SbomComponentId, SbomComponent> graph) {
        Optional<SbomComponent> rootProject = this.findRootComponent(graph, (String)this.task.getComponentVersion().get());
        if (!rootProject.isPresent()) {
            this.project.getLogger().debug("CycloneDX: root project not found. Constructing it.");
            SbomComponentId rootProjectId = new SbomComponentId(this.project.getGroup().toString(), this.project.getName(), (String)this.task.getComponentVersion().get(), null, this.project.getPath());
            SbomComponent sbomComponent = new SbomComponent.Builder().withId(rootProjectId).withDependencyComponents(new HashSet<SbomComponentId>()).withInScopeConfigurations(new HashSet<ConfigurationScope>()).withLicenses(new ArrayList<License>()).build();
            graph.put(rootProjectId, sbomComponent);
            this.connectRootWithSubProjects(rootProjectId, graph);
            return new SbomGraph(graph, sbomComponent);
        }
        this.connectRootWithSubProjects(rootProject.get().getId(), graph);
        return new SbomGraph(graph, rootProject.get());
    }

    private Stream<Map<SbomComponentId, SbomComponent>> traverseProject(Project project) {
        DependencyGraphTraverser traverser = new DependencyGraphTraverser(project.getLogger(), this.getArtifacts(), this.mavenLookup, this.task);
        return this.getInScopeConfigurations(project).map(config -> traverser.traverseGraph(config.getIncoming().getResolutionResult().getRoot(), project.getName(), config.getName()));
    }

    private Map<ComponentIdentifier, File> getArtifacts() {
        return Stream.concat(Stream.of(this.project), this.project.getSubprojects().stream()).filter(this::filterProjects).flatMap(this::getInScopeConfigurations).flatMap(config -> {
            ResolvedArtifactResult[] resolvedArtifacts = config.getIncoming().artifactView(view -> view.lenient(true)).getArtifacts().getArtifacts().toArray(ARTIFACT_TYPE);
            this.project.getLogger().debug("For project {} following artifacts have been resolved: {}", (Object)this.project.getName(), (Object)this.summarize(resolvedArtifacts, v -> v.getId().getDisplayName()));
            return Arrays.stream(resolvedArtifacts);
        }).collect(Collectors.toMap(artifact -> artifact.getId().getComponentIdentifier(), ResolvedArtifactResult::getFile, (v1, v2) -> v1));
    }

    private <T> String summarize(T[] data, Function<T, String> extractor) {
        return Arrays.stream(data).map(extractor).collect(Collectors.joining(","));
    }

    private boolean shouldSkipConfiguration(Configuration configuration) {
        return ((List)this.task.getSkipConfigs().get()).stream().anyMatch(configuration.getName()::matches);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldIncludeConfiguration(Configuration configuration) {
        if (((List)this.task.getIncludeConfigs().get()).isEmpty()) return true;
        if (!((List)this.task.getIncludeConfigs().get()).stream().anyMatch(configuration.getName()::matches)) return false;
        return true;
    }

    private boolean shouldSkipProject(Project project) {
        return ((List)this.task.getSkipProjects().get()).contains(project.getName());
    }

    private boolean filterConfigurations(Project project, Configuration configuration) {
        boolean include = this.shouldIncludeConfiguration(configuration);
        boolean skip = this.shouldSkipConfiguration(configuration);
        boolean resolvable = configuration.isCanBeResolved();
        if (!include || skip || !resolvable) {
            project.getLogger().debug("Skipping configuration '{}' (project: {}, include: {}, skip: {}, canBeResolved: {})", new Object[]{configuration.getName(), project, include, skip, resolvable});
        }
        return include && !skip && resolvable;
    }

    private boolean filterProjects(Project project) {
        boolean skip = this.shouldSkipProject(project);
        if (skip) {
            this.project.getLogger().debug("Skipping project '{}'", (Object)project.getName());
        }
        return !skip;
    }

    private Stream<Configuration> getInScopeConfigurations(Project project) {
        Configuration[] configs = (Configuration[])project.getConfigurations().stream().filter(configuration -> this.filterConfigurations(project, (Configuration)configuration)).toArray(Configuration[]::new);
        this.project.getLogger().info("For project {} following configurations are in scope to build the dependency graph: {}", (Object)project.getName(), (Object)this.summarize(configs, Named::getName));
        return Arrays.stream(configs);
    }

    private void connectRootWithSubProjects(SbomComponentId rootProjectId, Map<SbomComponentId, SbomComponent> graph) {
        if (this.project.getSubprojects().isEmpty()) {
            return;
        }
        Set dependencyComponentIds = this.project.getSubprojects().stream().map(subProject -> new SbomComponentId(subProject.getGroup().toString(), subProject.getName(), subProject.getVersion().toString(), null, subProject.getPath())).filter(id -> {
            boolean exists = graph.containsKey(id);
            if (!exists) {
                this.project.getLogger().debug("Subproject not found in graph: {}", id);
            }
            return exists;
        }).collect(Collectors.toSet());
        this.project.getLogger().debug("Connecting root project {} with subprojects {}", (Object)rootProjectId, dependencyComponentIds);
        graph.get(rootProjectId).getDependencyComponents().addAll(dependencyComponentIds);
    }

    private Optional<SbomComponent> findRootComponent(Map<SbomComponentId, SbomComponent> graph, String configuredComponentVersion) {
        SbomComponentId rootProjectId = new SbomComponentId(this.project.getGroup().toString(), this.project.getName(), configuredComponentVersion, null, this.project.getPath());
        if (!graph.containsKey(rootProjectId)) {
            return Optional.empty();
        }
        return Optional.of(graph.get(rootProjectId));
    }
}

