/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.model;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.maven.model.License;
import org.cyclonedx.gradle.model.ConfigurationScope;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.model.SbomMetaData;

public final class SbomComponent
implements Serializable {
    private final SbomComponentId id;
    private final Set<ConfigurationScope> inScopeConfigurations;
    private final Set<SbomComponentId> dependencyComponents;
    @Nullable
    private final File artifactFile;
    @Nullable
    private final SbomMetaData metaData;
    private final List<License> licenses;

    private SbomComponent(SbomComponentId id, Set<ConfigurationScope> inScopeConfigurations, Set<SbomComponentId> dependencyComponents, @Nullable File artifactFile, @Nullable SbomMetaData metaData, List<License> licenses) {
        this.id = id;
        this.inScopeConfigurations = inScopeConfigurations;
        this.dependencyComponents = dependencyComponents;
        this.artifactFile = artifactFile;
        this.metaData = metaData;
        this.licenses = licenses;
    }

    public SbomComponentId getId() {
        return this.id;
    }

    public Set<ConfigurationScope> getInScopeConfigurations() {
        return this.inScopeConfigurations;
    }

    public Set<SbomComponentId> getDependencyComponents() {
        return this.dependencyComponents;
    }

    public Optional<File> getArtifactFile() {
        return Optional.ofNullable(this.artifactFile);
    }

    public Optional<SbomMetaData> getSbomMetaData() {
        return Optional.ofNullable(this.metaData);
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public static class Builder {
        private SbomComponentId id;
        private Set<ConfigurationScope> inScopeConfigurations;
        private Set<SbomComponentId> dependencyComponents;
        private File artifactFile;
        private SbomMetaData metaData;
        private List<License> licenses;

        public Builder withId(SbomComponentId id) {
            this.id = id;
            return this;
        }

        public Builder withInScopeConfigurations(Set<ConfigurationScope> inScopeConfigurations) {
            this.inScopeConfigurations = inScopeConfigurations;
            return this;
        }

        public Builder withDependencyComponents(Set<SbomComponentId> dependencyComponents) {
            this.dependencyComponents = dependencyComponents;
            return this;
        }

        public Builder withArtifactFile(@Nullable File artifactFile) {
            this.artifactFile = artifactFile;
            return this;
        }

        public Builder withMetaData(@Nullable SbomMetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder withLicenses(List<License> licenses) {
            this.licenses = licenses;
            return this;
        }

        public SbomComponent build() {
            return new SbomComponent(this.id, this.inScopeConfigurations, this.dependencyComponents, this.artifactFile, this.metaData, this.licenses);
        }
    }
}

