/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import com.github.packageurl.MalformedPackageURLException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.cyclonedx.Version;
import org.cyclonedx.gradle.CycloneDxTask;
import org.cyclonedx.gradle.MavenHelper;
import org.cyclonedx.gradle.model.ComponentComparator;
import org.cyclonedx.gradle.model.DependencyComparator;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.cyclonedx.gradle.utils.CycloneDxUtils;
import org.cyclonedx.gradle.utils.DependencyUtils;
import org.cyclonedx.gradle.utils.EnvironmentUtils;
import org.cyclonedx.gradle.utils.ExternalReferencesUtil;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.BomUtils;
import org.gradle.api.logging.Logger;

class SbomBuilder {
    private static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    private static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    private final Logger logger;
    private final Map<File, List<Hash>> artifactHashes;
    private final MavenHelper mavenHelper;
    private final Version version;
    private final CycloneDxTask task;

    SbomBuilder(Logger logger, CycloneDxTask task) {
        this.logger = logger;
        this.version = CycloneDxUtils.schemaVersion((String)task.getSchemaVersion().get());
        this.artifactHashes = new HashMap<File, List<Hash>>();
        this.mavenHelper = new MavenHelper(logger, (Boolean)task.getIncludeLicenseText().get());
        this.task = task;
    }

    Bom buildBom(Map<SbomComponentId, SbomComponent> resultGraph, SbomComponent rootComponent) {
        this.task.getLogger().info(MESSAGE_CREATING_BOM);
        TreeSet<Dependency> dependencies = new TreeSet<Dependency>(new DependencyComparator());
        TreeSet<Component> components = new TreeSet<Component>(new ComponentComparator());
        resultGraph.keySet().forEach(componentId -> {
            this.addDependency(dependencies, (SbomComponent)resultGraph.get(componentId));
            this.addComponent(components, (SbomComponent)resultGraph.get(componentId), rootComponent);
        });
        Bom bom = new Bom();
        if (((Boolean)this.task.getIncludeBomSerialNumber().get()).booleanValue()) {
            bom.setSerialNumber("urn:uuid:" + UUID.randomUUID());
        }
        bom.setMetadata(this.buildMetadata(rootComponent));
        bom.setComponents(new ArrayList<Component>(components));
        bom.setDependencies(new ArrayList<Dependency>(dependencies));
        return bom;
    }

    private Metadata buildMetadata(SbomComponent parentComponent) {
        Properties pluginProperties;
        Metadata metadata = new Metadata();
        try {
            Component component = this.toComponent(parentComponent, null, this.resolveProjectType());
            component.setProperties(null);
            component.setName((String)this.task.getComponentName().get());
            component.setVersion((String)this.task.getComponentVersion().get());
            this.addBuildSystemMetaData(component);
            component.addExternalReference(this.task.getGitVCS());
            ExternalReferencesUtil.complementByEnvironment(component);
            metadata.setComponent(component);
        }
        catch (MalformedPackageURLException e) {
            this.logger.warn("Error constructing packageUrl for parent component {}. Skipping...", (Object)parentComponent.getId().getName(), (Object)e);
        }
        metadata.setLicenseChoice(this.task.getLicenseChoice());
        if (!new OrganizationalEntity().equals((Object)this.task.getOrganizationalEntity())) {
            metadata.setManufacturer(this.task.getOrganizationalEntity());
        }
        if (!(pluginProperties = this.readPluginProperties()).isEmpty()) {
            if (this.version.compareTo((Enum)Version.VERSION_15) >= 0) {
                Component component = new Component();
                component.setType(Component.Type.APPLICATION);
                component.setAuthor(pluginProperties.getProperty("vendor"));
                component.setName(pluginProperties.getProperty("name"));
                component.setVersion(pluginProperties.getProperty("version"));
                ToolInformation tool = new ToolInformation();
                tool.setComponents(Collections.singletonList(component));
                metadata.setToolChoice(tool);
            } else {
                Tool tool = new Tool();
                tool.setVendor(pluginProperties.getProperty("vendor"));
                tool.setName(pluginProperties.getProperty("name"));
                tool.setVersion(pluginProperties.getProperty("version"));
                metadata.addTool(tool);
            }
        }
        return metadata;
    }

    private void addBuildSystemMetaData(Component component) {
        String url;
        if (((Boolean)this.task.getIncludeBuildSystem().get()).booleanValue() && (url = this.task.getBuildSystemEnvironmentVariable().isPresent() && this.task.getBuildSystemEnvironmentVariable().get() != null ? EnvironmentUtils.getBuildURI((String)this.task.getBuildSystemEnvironmentVariable().get()) : EnvironmentUtils.getBuildURI()) != null) {
            ExternalReference buildRef = new ExternalReference();
            buildRef.setType(ExternalReference.Type.BUILD_SYSTEM);
            buildRef.setUrl(url);
            component.addExternalReference(buildRef);
        }
    }

    private void addDependency(Set<Dependency> dependencies, SbomComponent component) {
        Dependency dependency;
        try {
            dependency = this.toDependency(component.getId());
        }
        catch (MalformedPackageURLException e) {
            this.logger.warn("Error constructing packageUrl for component {}. Skipping...", (Object)component.getId().getName(), (Object)e);
            return;
        }
        component.getDependencyComponents().forEach(dependencyComponent -> {
            try {
                dependency.addDependency(this.toDependency((SbomComponentId)dependencyComponent));
            }
            catch (MalformedPackageURLException e) {
                this.logger.warn("Error constructing packageUrl for component dependency {}. Skipping...", (Object)dependencyComponent.getName(), (Object)e);
            }
        });
        dependencies.add(dependency);
    }

    private Dependency toDependency(SbomComponentId componentId) throws MalformedPackageURLException {
        String ref = DependencyUtils.generatePackageUrl(componentId);
        return new Dependency(ref);
    }

    private void addComponent(Set<Component> components, SbomComponent component, SbomComponent parentComponent) {
        if (!component.equals(parentComponent)) {
            File artifactFile = component.getArtifactFile().orElse(null);
            try {
                components.add(this.toComponent(component, artifactFile, Component.Type.LIBRARY));
            }
            catch (MalformedPackageURLException e) {
                this.logger.warn("Error constructing packageUrl for component {}. Skipping...", (Object)component.getId().getName(), (Object)e);
            }
        }
    }

    private Component toComponent(SbomComponent component, File artifactFile, Component.Type type) throws MalformedPackageURLException {
        String packageUrl = DependencyUtils.generatePackageUrl(component.getId());
        Component resultComponent = new Component();
        resultComponent.setGroup(component.getId().getGroup());
        resultComponent.setName(component.getId().getName());
        resultComponent.setVersion(component.getId().getVersion());
        resultComponent.setType(type);
        resultComponent.setPurl(packageUrl);
        resultComponent.setProperties(this.buildProperties(component));
        resultComponent.setModified(Boolean.valueOf(this.mavenHelper.isModified(null)));
        resultComponent.setBomRef(packageUrl);
        component.getSbomMetaData().ifPresent(metaData -> {
            resultComponent.setDescription(metaData.getDescription());
            resultComponent.setPublisher(metaData.getPublisher());
            metaData.getExternalReferences().forEach(reference -> {
                ExternalReference ref = new ExternalReference();
                ref.setType(ExternalReference.Type.valueOf((String)reference.getType()));
                ref.setUrl(reference.getUrl());
                resultComponent.addExternalReference(ref);
            });
        });
        if (!component.getLicenses().isEmpty()) {
            LicenseChoice licenseChoice = this.mavenHelper.resolveMavenLicenses(component.getLicenses());
            resultComponent.setLicenses(licenseChoice);
        }
        this.logger.debug(MESSAGE_CALCULATING_HASHES);
        if (artifactFile != null) {
            resultComponent.setHashes(this.calculateHashes(artifactFile));
        }
        return resultComponent;
    }

    private List<Property> buildProperties(SbomComponent component) {
        Property isTestProperty = this.buildIsTestProperty(component);
        ArrayList<Property> resultProperties = new ArrayList<Property>();
        resultProperties.add(isTestProperty);
        return resultProperties;
    }

    private Property buildIsTestProperty(SbomComponent component) {
        boolean isTestComponent = component.getInScopeConfigurations().stream().allMatch(v -> v.getConfigName().startsWith("test"));
        Property property = new Property();
        property.setName("cdx:maven:package:test");
        property.setValue(Boolean.toString(isTestComponent));
        return property;
    }

    private List<Hash> calculateHashes(File artifactFile) {
        return this.artifactHashes.computeIfAbsent(artifactFile, f -> {
            try {
                return BomUtils.calculateHashes((File)f, (Version)this.version);
            }
            catch (IOException e) {
                this.logger.error("Error encountered calculating hashes", (Throwable)e);
                return Collections.emptyList();
            }
        });
    }

    private Component.Type resolveProjectType() {
        for (Component.Type type : Component.Type.values()) {
            if (!type.getTypeName().equalsIgnoreCase((String)this.task.getProjectType().get())) continue;
            return type;
        }
        this.logger.warn("Invalid project type. Defaulting to 'library'");
        this.logger.warn("Valid types are:");
        for (Component.Type type : Component.Type.values()) {
            this.logger.warn("  " + type.getTypeName());
        }
        return Component.Type.LIBRARY;
    }

    private Properties readPluginProperties() {
        Properties props = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("plugin.properties");){
            if (inputStream == null) {
                this.logger.info("plugin.properties is not found on the classpath");
            } else {
                props.load(inputStream);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error whilst loading plugin.properties", (Throwable)e);
        }
        return props;
    }
}

