/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.cyclonedx.gradle.GradleAssistedMavenModelResolverImpl;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.util.LicenseResolver;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.logging.Logger;

class MavenHelper {
    private final Logger logger;
    private final Boolean includeLicenseText;

    public MavenHelper(Logger logger, Boolean includeLicenseText) {
        this.logger = logger;
        this.includeLicenseText = includeLicenseText;
    }

    void getClosestMetadata(File artifact, MavenProject project, Component component, ModuleVersionIdentifier mid) {
        MavenProject parentProject;
        this.extractMetadata(project, component);
        if (project.getParent() != null) {
            this.getClosestMetadata(artifact, project.getParent(), component, mid);
        } else if (project.getModel().getParent() != null && (parentProject = this.retrieveParentProject(artifact, project, mid)) != null) {
            this.getClosestMetadata(artifact, parentProject, component, mid);
        }
    }

    public void extractMetadata(MavenProject project, Component component) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if (project.getOrganization() != null && project.getOrganization().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.WEBSITE)) {
            this.addExternalReference(ExternalReference.Type.WEBSITE, project.getOrganization().getUrl(), component);
        }
        if (project.getCiManagement() != null && project.getCiManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.BUILD_SYSTEM)) {
            this.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, project.getCiManagement().getUrl(), component);
        }
        if (project.getDistributionManagement() != null && project.getDistributionManagement().getDownloadUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
            this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getDownloadUrl(), component);
        }
        if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
            this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getRepository().getUrl(), component);
        }
        if (project.getIssueManagement() != null && project.getIssueManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.ISSUE_TRACKER)) {
            this.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, project.getIssueManagement().getUrl(), component);
        }
        if (project.getMailingLists() != null && project.getMailingLists().size() > 0) {
            for (MailingList list : project.getMailingLists()) {
                if (list.getArchive() != null) {
                    if (this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                    this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getArchive(), component);
                    continue;
                }
                if (list.getSubscribe() == null || this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getSubscribe(), component);
            }
        }
        if (project.getScm() != null && project.getScm().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.VCS)) {
            this.addExternalReference(ExternalReference.Type.VCS, project.getScm().getUrl(), component);
        }
    }

    private void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        try {
            URI uri = new URI(url.trim());
            ExternalReference ref = new ExternalReference();
            ref.setType(referenceType);
            ref.setUrl(uri.toString());
            component.addExternalReference(ref);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type type) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (type != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    LicenseChoice resolveMavenLicenses(List<License> projectLicenses) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            LicenseChoice resolvedByUrl;
            LicenseChoice resolvedByName;
            boolean resolved = false;
            if (artifactLicense.getName() != null && (resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)this.includeLicenseText)) != null) {
                if (resolvedByName.getLicenses() != null && !resolvedByName.getLicenses().isEmpty()) {
                    resolved = true;
                    licenseChoice.addLicense((org.cyclonedx.model.License)resolvedByName.getLicenses().get(0));
                } else if (resolvedByName.getExpression() != null) {
                    resolved = true;
                    licenseChoice.setExpression(resolvedByName.getExpression());
                }
            }
            if (artifactLicense.getUrl() != null && !resolved && (resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)this.includeLicenseText)) != null) {
                if (resolvedByUrl.getLicenses() != null && !resolvedByUrl.getLicenses().isEmpty()) {
                    resolved = true;
                    licenseChoice.addLicense((org.cyclonedx.model.License)resolvedByUrl.getLicenses().get(0));
                } else if (resolvedByUrl.getExpression() != null) {
                    resolved = true;
                    licenseChoice.setExpression(resolvedByUrl.getExpression());
                }
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (StringUtils.isNotBlank((CharSequence)artifactLicense.getUrl())) {
                try {
                    URI uri = new URI(artifactLicense.getUrl().trim());
                    license.setUrl(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        if (licenseChoice.getLicenses() == null) {
            return null;
        }
        return licenseChoice;
    }

    @Nullable
    private MavenProject retrieveParentProject(File artifact, MavenProject project, ModuleVersionIdentifier mid) {
        if (artifact == null || artifact.getParentFile() == null) {
            return null;
        }
        Model model = project.getModel();
        if (model.getParent() != null) {
            Parent parent = model.getParent();
            StringBuilder getout = new StringBuilder("../../../");
            int periods = mid.getGroup().length() - mid.getGroup().replace(".", "").length();
            for (int i = 0; i < periods; ++i) {
                getout.append("../");
            }
            File parentFile = new File(artifact.getParentFile(), getout + parent.getGroupId().replace(".", "/") + "/" + parent.getArtifactId() + "/" + parent.getVersion() + "/" + parent.getArtifactId() + "-" + parent.getVersion() + ".pom");
            if (parentFile.exists() && parentFile.isFile()) {
                try {
                    return MavenHelper.readPom(parentFile.getCanonicalFile());
                }
                catch (Exception e) {
                    this.logger.error("An error occurred retrieving an artifacts parent pom", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    MavenProject extractPom(File artifact, ModuleVersionIdentifier mid) {
        if (artifact == null) return null;
        if (!artifact.exists()) return null;
        try {
            JarFile jarFile = new JarFile(artifact);
            JarEntry entry = jarFile.getJarEntry("META-INF/maven/" + mid.getGroup() + "/" + mid.getName() + "/pom.xml");
            if (entry == null) return null;
            try (InputStream input = jarFile.getInputStream(entry);){
                MavenProject mavenProject = MavenHelper.readPom(input);
                return mavenProject;
            }
        }
        catch (IOException e) {
            this.logger.error("An error occurred attempting to extract POM from artifact", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static MavenProject readPom(File file) {
        if (file == null) {
            return null;
        }
        try {
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);){
                Model model = mavenreader.read((Reader)reader);
                MavenProject mavenProject = new MavenProject(model);
                return mavenProject;
            }
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("An error occurred attempting to read POM", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static MavenProject readPom(InputStream in) {
        try {
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            try (XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);){
                Model model = mavenreader.read((Reader)reader);
                MavenProject mavenProject = new MavenProject(model);
                return mavenProject;
            }
        }
        catch (IOException | XmlPullParserException throwable6) {
            return null;
        }
    }

    static Model resolveEffectivePom(File pomFile, Project gradleProject) {
        GradleAssistedMavenModelResolverImpl modelResolver = new GradleAssistedMavenModelResolverImpl(gradleProject);
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setModelResolver((ModelResolver)modelResolver);
        req.setPomFile(pomFile);
        req.getSystemProperties().putAll((Map<?, ?>)System.getProperties());
        req.setValidationLevel(0);
        DefaultModelBuilderFactory factory = new DefaultModelBuilderFactory();
        DefaultModelBuilder builder = factory.newInstance();
        Model effectiveModel = null;
        try {
            effectiveModel = builder.build((ModelBuildingRequest)req).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new IllegalStateException("An error occurred attempting to resolve effective POM", e);
        }
        return effectiveModel;
    }

    boolean isDescribedArtifact(Artifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    static boolean isDescribedArtifact(ResolvedArtifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    boolean isModified(ResolvedArtifact artifact) {
        return false;
    }
}

