/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;

public class ExternalReferencesUtil {
    private ExternalReferencesUtil() {
    }

    public static void complementByEnvironment(@Nonnull Component component) {
        ExternalReferencesUtil.addGitReference(component);
    }

    private static void addGitReference(@Nonnull Component component) {
        if (component.getExternalReferences() != null && component.getExternalReferences().stream().filter(Objects::nonNull).anyMatch(er -> ExternalReference.Type.VCS == er.getType())) {
            return;
        }
        String gitUrl = ExternalReferencesUtil.fromEnvironment();
        if (gitUrl == null || gitUrl.isEmpty()) {
            gitUrl = ExternalReferencesUtil.fromGitRepo();
        }
        if (gitUrl != null) {
            if (gitUrl.startsWith("git@")) {
                gitUrl = "ssh://" + gitUrl;
            }
            ExternalReference externalReference = new ExternalReference();
            externalReference.setType(ExternalReference.Type.VCS);
            externalReference.setUrl(gitUrl);
            component.addExternalReference(externalReference);
        }
    }

    @Nullable
    private static String fromEnvironment() {
        return System.getenv("GIT_URL");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String fromGitRepo() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"git", "remote", "get-url", "origin"});
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String string = reader.readLine();
                return string;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

