/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class EnvironmentUtils {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    private static final String JENKINS_BUILD_URL = "BUILD_URL";
    private static final String TRAVIS_BUILD_WEB_URL = "TRAVIS_BUILD_WEB_URL";
    private static final String CIRCLE_BUILD_URL = "CIRCLE_BUILD_URL";
    private static final String DRONE_BUILD_LINK = "DRONE_BUILD_LINK";

    @Nullable
    public static String getBuildURI() {
        return Optional.ofNullable(EnvironmentUtils.fromGithubActions()).orElseGet(() -> Optional.ofNullable(EnvironmentUtils.fromGitlabCI()).orElseGet(() -> Optional.ofNullable(EnvironmentUtils.fromEnvironment(JENKINS_BUILD_URL)).orElseGet(() -> Optional.ofNullable(EnvironmentUtils.fromEnvironment(CIRCLE_BUILD_URL)).orElseGet(() -> Optional.ofNullable(EnvironmentUtils.fromEnvironment(TRAVIS_BUILD_WEB_URL)).orElseGet(() -> Optional.ofNullable(EnvironmentUtils.fromEnvironment(DRONE_BUILD_LINK)).orElse(null))))));
    }

    @Nullable
    public static String getBuildURI(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        if (str.contains("${")) {
            return EnvironmentUtils.getBuildUriFromPattern(str);
        }
        return System.getenv(str);
    }

    @Nullable
    private static String fromGithubActions() {
        String githubServerUrl = System.getenv("GITHUB_SERVER_URL");
        String githubRepository = System.getenv("GITHUB_REPOSITORY");
        String githubRunId = System.getenv("GITHUB_RUN_ID");
        if (!(StringUtils.isBlank((CharSequence)githubServerUrl) || StringUtils.isBlank((CharSequence)githubRepository) || StringUtils.isBlank((CharSequence)githubRunId))) {
            return String.format("%s/%s/actions/runs/%s", githubServerUrl, githubRepository, githubRunId);
        }
        return null;
    }

    @Nullable
    private static String fromGitlabCI() {
        String ciProjectUrl = System.getenv("CI_PROJECT_URL");
        String ciJobId = System.getenv("CI_JOB_ID");
        if (!StringUtils.isBlank((CharSequence)ciProjectUrl) && !StringUtils.isBlank((CharSequence)ciJobId)) {
            return String.format("%s/-/jobs/%s", ciProjectUrl, ciJobId);
        }
        return null;
    }

    @Nullable
    private static String fromEnvironment(String name) {
        String url = System.getenv(name);
        if (!StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        return null;
    }

    @Nullable
    private static String getBuildUriFromPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(pattern);
        Matcher matcher = VARIABLE_PATTERN.matcher(pattern);
        while (matcher.find()) {
            String varName = matcher.group(1);
            if (StringUtils.isBlank((CharSequence)varName)) {
                return null;
            }
            String value = System.getenv(varName);
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            int start = result.indexOf("${" + varName + "}");
            int end = start + varName.length() + 3;
            result.replace(start, end, value);
        }
        return result.toString();
    }
}

