/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle.utils;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.gradle.model.SbomComponent;
import org.cyclonedx.gradle.model.SbomComponentId;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;

public class DependencyUtils {
    public static Map<SbomComponentId, SbomComponent> mergeGraphs(Map<SbomComponentId, SbomComponent> firstGraph, Map<SbomComponentId, SbomComponent> secondGraph) {
        HashMap<SbomComponentId, SbomComponent> mergedGraph = new HashMap<SbomComponentId, SbomComponent>(firstGraph);
        secondGraph.keySet().stream().forEach(id -> {
            if (firstGraph.containsKey(id)) {
                SbomComponent resultComponent = (SbomComponent)mergedGraph.get(id);
                SbomComponent targetComponent = (SbomComponent)secondGraph.get(id);
                resultComponent.getDependencyComponents().addAll(targetComponent.getDependencyComponents());
                resultComponent.getInScopeConfigurations().addAll(targetComponent.getInScopeConfigurations());
            } else {
                mergedGraph.put((SbomComponentId)id, (SbomComponent)secondGraph.get(id));
            }
        });
        return mergedGraph;
    }

    public static void connectRootWithSubProjects(Project project, SbomComponentId rootProjectId, Map<SbomComponentId, SbomComponent> graph) {
        if (project.getSubprojects().isEmpty()) {
            return;
        }
        Set dependencyComponentIds = project.getSubprojects().stream().map(subProject -> new SbomComponentId(subProject.getGroup().toString(), subProject.getName(), subProject.getVersion().toString(), "")).filter(graph::containsKey).collect(Collectors.toSet());
        graph.get(rootProjectId).getDependencyComponents().addAll(dependencyComponentIds);
    }

    public static Optional<SbomComponent> findRootComponent(Project project, Map<SbomComponentId, SbomComponent> graph, String configuredComponentVersion) {
        SbomComponentId rootProjectId = new SbomComponentId(project.getGroup().toString(), project.getName(), configuredComponentVersion, "");
        if (!graph.containsKey(rootProjectId)) {
            return Optional.empty();
        }
        return Optional.of(graph.get(rootProjectId));
    }

    public static SbomComponentId toComponentId(ResolvedComponentResult node, File file) {
        String type = "";
        if (node.getId() instanceof ModuleComponentIdentifier) {
            type = file != null ? DependencyUtils.getType(file) : "pom";
        }
        if (node.getModuleVersion() != null) {
            return new SbomComponentId(node.getModuleVersion().getGroup(), node.getModuleVersion().getName(), node.getModuleVersion().getVersion(), type);
        }
        return new SbomComponentId("undefined", node.getId().getDisplayName(), "undefined", type);
    }

    private static String getType(File file) {
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        if (StringUtils.isBlank((CharSequence)fileExtension)) {
            return "pom";
        }
        return fileExtension;
    }

    public static String generatePackageUrl(SbomComponentId componentId, TreeMap<String, String> qualifiers) throws MalformedPackageURLException {
        return new PackageURL("maven", componentId.getGroup(), componentId.getName(), componentId.getVersion(), qualifiers, null).canonicalize();
    }
}

