/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.gradle.MavenHelper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.maven.MavenModule;
import org.gradle.maven.MavenPomArtifact;

class MavenProjectLookup {
    private final Project project;
    private final Map<ComponentIdentifier, MavenProject> cache;

    MavenProjectLookup(Project project) {
        this.project = project;
        this.cache = new HashMap<ComponentIdentifier, MavenProject>();
    }

    @Nullable
    MavenProject getResolvedMavenProject(@Nullable ResolvedComponentResult result) {
        if (result == null) {
            return null;
        }
        if (this.cache.containsKey(result.getId())) {
            return this.cache.get(result.getId());
        }
        try {
            File pomFile = this.buildMavenProject(result.getId());
            MavenProject mavenProject = MavenHelper.readPom(pomFile);
            if (mavenProject != null) {
                this.project.getLogger().debug("CycloneDX: parse queried pom file for component {}", (Object)result.getId());
                Model model = MavenHelper.resolveEffectivePom(pomFile, this.project);
                if (model != null) {
                    mavenProject.setLicenses(model.getLicenses());
                }
                this.cache.put(result.getId(), mavenProject);
                return mavenProject;
            }
        }
        catch (Exception err) {
            this.project.getLogger().error("Unable to resolve POM for {}", (Object)result.getId(), (Object)err);
        }
        return null;
    }

    @Nullable
    File buildMavenProject(ComponentIdentifier id) {
        ArtifactResolutionResult result = this.project.getDependencies().createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{id}).withArtifacts(MavenModule.class, new Class[]{MavenPomArtifact.class}).execute();
        Iterator componentIt = result.getResolvedComponents().iterator();
        if (!componentIt.hasNext()) {
            return null;
        }
        Iterator artifactIt = ((ComponentArtifactsResult)componentIt.next()).getArtifacts(MavenPomArtifact.class).iterator();
        if (!artifactIt.hasNext()) {
            return null;
        }
        ArtifactResult artifact = (ArtifactResult)artifactIt.next();
        if (artifact instanceof ResolvedArtifactResult) {
            this.project.getLogger().debug("CycloneDX: found pom file for component {}", (Object)id);
            ResolvedArtifactResult resolvedArtifact = (ResolvedArtifactResult)artifact;
            return resolvedArtifact.getFile();
        }
        return null;
    }
}

