/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.cyclonedx.gradle.SbomBuilder;
import org.cyclonedx.gradle.SbomGraphProvider;
import org.cyclonedx.gradle.model.SbomGraph;
import org.cyclonedx.gradle.utils.CycloneDxUtils;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class CycloneDxTask
extends DefaultTask {
    private static final String MESSAGE_WRITING_BOM_OUTPUT = "CycloneDX: Writing BOM output";
    private static final String DEFAULT_PROJECT_TYPE = "library";
    private final Property<String> outputName;
    private final Property<String> schemaVersion;
    private final Property<String> componentName;
    private final Property<String> componentVersion;
    private final Property<String> outputFormat;
    private final Property<Boolean> includeBomSerialNumber;
    private final ListProperty<String> skipConfigs;
    private final ListProperty<String> includeConfigs;
    private final Property<Boolean> includeMetadataResolution;
    private final Property<Boolean> includeLicenseText;
    private final Property<String> projectType;
    private final ListProperty<String> skipProjects;
    private final Property<File> destination;
    private final Provider<SbomGraph> componentsProvider = this.getProject().getProviders().provider((Callable)new SbomGraphProvider(this.getProject(), this));
    private final Property<Boolean> includeBuildSystem;
    private final Property<String> buildSystemEnvironmentVariable;
    @Nullable
    private OrganizationalEntity organizationalEntity;
    @Nullable
    private LicenseChoice licenseChoice;
    @Nullable
    private ExternalReference gitVCS;

    public CycloneDxTask() {
        this.outputName = this.getProject().getObjects().property(String.class);
        this.outputName.convention((Object)"bom");
        this.schemaVersion = this.getProject().getObjects().property(String.class);
        this.schemaVersion.convention((Object)CycloneDxUtils.DEFAULT_SCHEMA_VERSION.getVersionString());
        this.componentName = this.getProject().getObjects().property(String.class);
        this.componentName.convention((Object)this.getProject().getName());
        this.componentVersion = this.getProject().getObjects().property(String.class);
        this.componentVersion.convention((Object)this.getProject().getVersion().toString());
        this.outputFormat = this.getProject().getObjects().property(String.class);
        this.outputFormat.convention((Object)"all");
        this.includeBomSerialNumber = this.getProject().getObjects().property(Boolean.class);
        this.includeBomSerialNumber.convention((Object)true);
        this.skipConfigs = this.getProject().getObjects().listProperty(String.class);
        this.includeConfigs = this.getProject().getObjects().listProperty(String.class);
        this.includeMetadataResolution = this.getProject().getObjects().property(Boolean.class);
        this.includeMetadataResolution.convention((Object)true);
        this.includeLicenseText = this.getProject().getObjects().property(Boolean.class);
        this.includeLicenseText.convention((Object)true);
        this.projectType = this.getProject().getObjects().property(String.class);
        this.projectType.convention((Object)DEFAULT_PROJECT_TYPE);
        this.skipProjects = this.getProject().getObjects().listProperty(String.class);
        this.organizationalEntity = new OrganizationalEntity();
        this.licenseChoice = new LicenseChoice();
        this.gitVCS = new ExternalReference();
        this.destination = this.getProject().getObjects().property(File.class);
        this.destination.convention((Object)((Directory)this.getProject().getLayout().getBuildDirectory().dir("reports").get()).getAsFile());
        this.includeBuildSystem = this.getProject().getObjects().property(Boolean.class);
        this.includeBuildSystem.convention((Object)false);
        this.buildSystemEnvironmentVariable = this.getProject().getObjects().property(String.class);
    }

    @Input
    public Property<String> getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String output) {
        this.outputName.set((Object)output);
    }

    @Input
    public Property<String> getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion.set((Object)schemaVersion);
    }

    @Input
    public Property<String> getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName.set((Object)componentName);
    }

    @Input
    public Property<String> getComponentVersion() {
        return this.componentVersion;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion.set((Object)componentVersion);
    }

    @Input
    public Property<String> getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String format) {
        this.outputFormat.set((Object)format);
    }

    @Input
    public Property<Boolean> getIncludeBomSerialNumber() {
        return this.includeBomSerialNumber;
    }

    public void setIncludeBomSerialNumber(boolean includeBomSerialNumber) {
        this.includeBomSerialNumber.set((Object)includeBomSerialNumber);
    }

    @Input
    public ListProperty<String> getSkipConfigs() {
        return this.skipConfigs;
    }

    public void setSkipConfigs(Collection<String> skipConfigs) {
        this.skipConfigs.addAll(skipConfigs);
    }

    @Input
    public ListProperty<String> getIncludeConfigs() {
        return this.includeConfigs;
    }

    public void setIncludeConfigs(Collection<String> includeConfigs) {
        this.includeConfigs.addAll(includeConfigs);
    }

    @Input
    public Property<Boolean> getIncludeMetadataResolution() {
        return this.includeMetadataResolution;
    }

    public void setIncludeMetadataResolution(boolean includeMetadataResolution) {
        this.includeMetadataResolution.set((Object)includeMetadataResolution);
    }

    @Input
    public Property<Boolean> getIncludeLicenseText() {
        return this.includeLicenseText;
    }

    public void setIncludeLicenseText(boolean includeLicenseText) {
        this.includeLicenseText.set((Object)includeLicenseText);
    }

    @Input
    public Property<String> getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType.set((Object)projectType);
    }

    @Input
    public ListProperty<String> getSkipProjects() {
        return this.skipProjects;
    }

    public void setSkipProjects(Collection<String> skipProjects) {
        this.skipProjects.addAll(skipProjects);
    }

    @Input
    public Property<Boolean> getIncludeBuildSystem() {
        return this.includeBuildSystem;
    }

    public void setIncludeBuildSystem(boolean includeBuildSystem) {
        this.includeBuildSystem.set((Object)includeBuildSystem);
    }

    @Input
    @Optional
    public Property<String> getBuildSystemEnvironmentVariable() {
        return this.buildSystemEnvironmentVariable;
    }

    public void setBuildSystemEnvironmentVariable(String buildSystemEnvironmentVariable) {
        this.buildSystemEnvironmentVariable.set((Object)buildSystemEnvironmentVariable);
    }

    @Internal
    @Nullable
    OrganizationalEntity getOrganizationalEntity() {
        return this.organizationalEntity;
    }

    @Internal
    @Nullable
    LicenseChoice getLicenseChoice() {
        return this.licenseChoice;
    }

    @Internal
    @Nullable
    ExternalReference getGitVCS() {
        return this.gitVCS;
    }

    @OutputDirectory
    public Property<File> getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination.set((Object)destination);
    }

    @TaskAction
    public void createBom() {
        this.logParameters();
        SbomBuilder builder = new SbomBuilder(this.getLogger(), this);
        SbomGraph components = (SbomGraph)this.componentsProvider.get();
        Bom bom = builder.buildBom(components.getGraph(), components.getRootComponent());
        this.getLogger().info(MESSAGE_WRITING_BOM_OUTPUT);
        CycloneDxUtils.writeBom(bom, (File)this.getDestination().get(), (String)this.getOutputName().get(), CycloneDxUtils.schemaVersion((String)this.getSchemaVersion().get()), (String)this.getOutputFormat().get());
    }

    public void setOrganizationalEntity(Consumer<OrganizationalEntity> customizer) {
        int i;
        OrganizationalEntity origin = new OrganizationalEntity();
        customizer.accept(origin);
        this.organizationalEntity = origin;
        HashMap<String, String> organizationalEntity = new HashMap<String, String>();
        organizationalEntity.put("name", this.organizationalEntity.getName());
        if (this.organizationalEntity.getUrls() != null) {
            for (i = 0; i < this.organizationalEntity.getUrls().size(); ++i) {
                organizationalEntity.put("url" + i, (String)this.organizationalEntity.getUrls().get(i));
            }
        }
        if (this.organizationalEntity.getContacts() != null) {
            for (i = 0; i < this.organizationalEntity.getContacts().size(); ++i) {
                organizationalEntity.put("contact_name" + i, ((OrganizationalContact)this.organizationalEntity.getContacts().get(i)).getName());
                organizationalEntity.put("contact_email" + i, ((OrganizationalContact)this.organizationalEntity.getContacts().get(i)).getEmail());
                organizationalEntity.put("contact_phone" + i, ((OrganizationalContact)this.organizationalEntity.getContacts().get(i)).getPhone());
            }
        }
        this.getInputs().property("OrganizationalEntity", organizationalEntity);
    }

    public void setLicenseChoice(Consumer<LicenseChoice> customizer) {
        LicenseChoice origin = new LicenseChoice();
        customizer.accept(origin);
        this.licenseChoice = origin;
        HashMap<String, String> licenseChoice = new HashMap<String, String>();
        if (this.licenseChoice.getLicenses() != null) {
            for (int i = 0; i < this.licenseChoice.getLicenses().size(); ++i) {
                if (((License)this.licenseChoice.getLicenses().get(i)).getName() != null) {
                    licenseChoice.put("licenseChoice" + i + "name", ((License)this.licenseChoice.getLicenses().get(i)).getName());
                }
                if (((License)this.licenseChoice.getLicenses().get(i)).getId() != null) {
                    licenseChoice.put("licenseChoice" + i + "id", ((License)this.licenseChoice.getLicenses().get(i)).getId());
                }
                licenseChoice.put("licenseChoice" + i + "text", ((License)this.licenseChoice.getLicenses().get(i)).getAttachmentText().getText());
                licenseChoice.put("licenseChoice" + i + "url", ((License)this.licenseChoice.getLicenses().get(i)).getUrl());
            }
        }
        if (this.licenseChoice.getExpression() != null) {
            licenseChoice.put("licenseChoice_Expression", this.licenseChoice.getExpression().getValue());
        }
        this.getInputs().property("LicenseChoice", licenseChoice);
    }

    public void setVCSGit(Consumer<ExternalReference> customizer) {
        ExternalReference origin = new ExternalReference();
        customizer.accept(origin);
        this.gitVCS = origin;
        this.gitVCS.setType(ExternalReference.Type.VCS);
        HashMap<String, String> externalReference = new HashMap<String, String>();
        externalReference.put("type", this.gitVCS.getType().toString());
        externalReference.put("url", this.gitVCS.getUrl());
        externalReference.put("comment", this.gitVCS.getComment());
        this.getInputs().property("GitVCS", externalReference);
    }

    private void logParameters() {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("CycloneDX: Parameters");
            this.getLogger().info("------------------------------------------------------------------------");
            this.getLogger().info("schemaVersion             : " + (String)this.schemaVersion.get());
            this.getLogger().info("includeLicenseText        : " + this.includeLicenseText.get());
            this.getLogger().info("includeBomSerialNumber    : " + this.includeBomSerialNumber.get());
            this.getLogger().info("includeConfigs            : " + this.includeConfigs.get());
            this.getLogger().info("skipConfigs               : " + this.skipConfigs.get());
            this.getLogger().info("skipProjects              : " + this.skipProjects.get());
            this.getLogger().info("includeMetadataResolution : " + this.includeMetadataResolution.get());
            this.getLogger().info("destination               : " + this.destination.get());
            this.getLogger().info("outputName                : " + (String)this.outputName.get());
            this.getLogger().info("componentName             : " + (String)this.componentName.get());
            this.getLogger().info("componentVersion          : " + (String)this.componentVersion.get());
            this.getLogger().info("outputFormat              : " + (String)this.outputFormat.get());
            this.getLogger().info("projectType               : " + (String)this.projectType.get());
            this.getLogger().info("------------------------------------------------------------------------");
        }
    }
}

