/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.Version;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.gradle.MavenHelper;
import org.cyclonedx.gradle.utils.CycloneDxUtils;
import org.cyclonedx.gradle.utils.DependencyUtils;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Tool;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.XmlParser;
import org.cyclonedx.util.BomUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class CycloneDxTask
extends DefaultTask {
    private static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    private static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    private static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    private static final String MESSAGE_WRITING_BOM_XML = "CycloneDX: Writing BOM XML";
    private static final String MESSAGE_WRITING_BOM_JSON = "CycloneDX: Writing BOM JSON";
    private static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM";
    private static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard";
    private static final String DEFAULT_PROJECT_TYPE = "library";
    private MavenHelper mavenHelper;
    private final Property<String> schemaVersion;
    private final Property<String> componentName;
    private final Property<String> componentVersion;
    private final Property<String> outputName;
    private final Property<String> outputFormat;
    private final Property<String> projectType;
    private final Property<Boolean> includeLicenseText;
    private final Property<Boolean> includeBomSerialNumber;
    private final ListProperty<String> includeConfigs;
    private final ListProperty<String> skipConfigs;
    private final ListProperty<String> skipProjects;
    private final Property<File> destination;
    private OrganizationalEntity organizationalEntity;
    private LicenseChoice licenseChoice;
    private final Map<File, List<Hash>> artifactHashes = Collections.synchronizedMap(new HashMap());
    private final Map<String, MavenProject> resolvedMavenProjects = Collections.synchronizedMap(new HashMap());

    public CycloneDxTask() {
        this.schemaVersion = this.getProject().getObjects().property(String.class);
        this.schemaVersion.convention((Object)CycloneDxUtils.DEFAULT_SCHEMA_VERSION.getVersionString());
        this.outputName = this.getProject().getObjects().property(String.class);
        this.outputName.convention((Object)"bom");
        this.outputFormat = this.getProject().getObjects().property(String.class);
        this.outputFormat.convention((Object)"all");
        this.projectType = this.getProject().getObjects().property(String.class);
        this.projectType.convention((Object)DEFAULT_PROJECT_TYPE);
        this.includeLicenseText = this.getProject().getObjects().property(Boolean.class);
        this.includeLicenseText.convention((Object)true);
        this.includeBomSerialNumber = this.getProject().getObjects().property(Boolean.class);
        this.includeBomSerialNumber.convention((Object)true);
        this.componentName = this.getProject().getObjects().property(String.class);
        this.componentName.convention((Object)this.getProject().getName());
        this.componentVersion = this.getProject().getObjects().property(String.class);
        this.componentVersion.convention((Object)this.getProject().getVersion().toString());
        this.includeConfigs = this.getProject().getObjects().listProperty(String.class);
        this.skipConfigs = this.getProject().getObjects().listProperty(String.class);
        this.skipProjects = this.getProject().getObjects().listProperty(String.class);
        this.destination = this.getProject().getObjects().property(File.class);
        this.destination.convention((Object)((Directory)this.getProject().getLayout().getBuildDirectory().dir("reports").get()).getAsFile());
        this.organizationalEntity = new OrganizationalEntity();
        this.licenseChoice = new LicenseChoice();
    }

    @Input
    public Property<String> getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String output) {
        this.outputName.set((Object)output);
    }

    @Input
    public Property<String> getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String format) {
        this.outputFormat.set((Object)format);
    }

    @Input
    public ListProperty<String> getIncludeConfigs() {
        return this.includeConfigs;
    }

    public void setIncludeConfigs(Collection<String> includeConfigs) {
        this.includeConfigs.addAll(includeConfigs);
    }

    @Input
    public Property<String> getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName.set((Object)componentName);
    }

    @Input
    public Property<String> getComponentVersion() {
        return this.componentVersion;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion.set((Object)componentVersion);
    }

    @Input
    public ListProperty<String> getSkipConfigs() {
        return this.skipConfigs;
    }

    public void setSkipConfigs(Collection<String> skipConfigs) {
        this.skipConfigs.addAll(skipConfigs);
    }

    @Input
    public ListProperty<String> getSkipProjects() {
        return this.skipProjects;
    }

    public void setSkipProjects(Collection<String> skipProjects) {
        this.skipProjects.addAll(skipProjects);
    }

    @Input
    public Property<String> getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion.set((Object)schemaVersion);
    }

    @Input
    public Property<String> getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType.set((Object)projectType);
    }

    @Input
    public Property<Boolean> getIncludeLicenseText() {
        return this.includeLicenseText;
    }

    public void setIncludeLicenseText(boolean includeLicenseText) {
        this.includeLicenseText.set((Object)includeLicenseText);
    }

    @Input
    public Property<Boolean> getIncludeBomSerialNumber() {
        return this.includeBomSerialNumber;
    }

    public void setIncludeBomSerialNumber(boolean includeBomSerialNumber) {
        this.includeBomSerialNumber.set((Object)includeBomSerialNumber);
    }

    @OutputDirectory
    public Property<File> getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination.set((Object)destination);
    }

    public void setOrganizationalEntity(Consumer<OrganizationalEntity> customizer) {
        int i;
        OrganizationalEntity origin = new OrganizationalEntity();
        customizer.accept(origin);
        this.organizationalEntity = origin;
        HashMap<String, String> organizationalEntity = new HashMap<String, String>();
        organizationalEntity.put("name", this.organizationalEntity.getName());
        if (this.organizationalEntity.getUrls() != null) {
            for (i = 0; i < this.organizationalEntity.getUrls().size(); ++i) {
                organizationalEntity.put("url" + i, (String)this.organizationalEntity.getUrls().get(i));
            }
        }
        if (this.organizationalEntity.getContacts() != null) {
            for (i = 0; i < this.organizationalEntity.getContacts().size(); ++i) {
                organizationalEntity.put("contact_name" + i, ((OrganizationalContact)this.organizationalEntity.getContacts().get(i)).getName());
                organizationalEntity.put("contact_email" + i, ((OrganizationalContact)this.organizationalEntity.getContacts().get(i)).getEmail());
                organizationalEntity.put("contact_phone" + i, ((OrganizationalContact)this.organizationalEntity.getContacts().get(i)).getPhone());
            }
        }
        this.getInputs().property("OrganizationalEntity", organizationalEntity);
    }

    public void setLicenseChoice(Consumer<LicenseChoice> customizer) {
        LicenseChoice origin = new LicenseChoice();
        customizer.accept(origin);
        this.licenseChoice = origin;
        HashMap<String, String> licenseChoice = new HashMap<String, String>();
        if (this.licenseChoice.getLicenses() != null) {
            for (int i = 0; i < this.licenseChoice.getLicenses().size(); ++i) {
                if (((License)this.licenseChoice.getLicenses().get(i)).getName() != null) {
                    licenseChoice.put("licenseChoice" + i + "name", ((License)this.licenseChoice.getLicenses().get(i)).getName());
                }
                if (((License)this.licenseChoice.getLicenses().get(i)).getId() != null) {
                    licenseChoice.put("licenseChoice" + i + "id", ((License)this.licenseChoice.getLicenses().get(i)).getId());
                }
                licenseChoice.put("licenseChoice" + i + "text", ((License)this.licenseChoice.getLicenses().get(i)).getAttachmentText().getText());
                licenseChoice.put("licenseChoice" + i + "url", ((License)this.licenseChoice.getLicenses().get(i)).getUrl());
            }
        }
        if (this.licenseChoice.getExpression() != null) {
            licenseChoice.put("licenseChoice_Expression", this.licenseChoice.getExpression().getValue());
        }
        this.getInputs().property("LicenseChoice", licenseChoice);
    }

    @TaskAction
    public void createBom() {
        if (!(((String)this.outputFormat.get()).trim().equalsIgnoreCase("all") || ((String)this.outputFormat.get()).trim().equalsIgnoreCase("xml") || ((String)this.outputFormat.get()).trim().equalsIgnoreCase("json"))) {
            throw new GradleException("Unsupported output format. Must be one of all, xml, or json");
        }
        if (this.getProject().getGroup().equals("") || this.getProject().getName().isEmpty() || this.getProject().getVersion().equals("")) {
            throw new GradleException("Project group, name, and version must be set for the root project");
        }
        Version version = this.computeSchemaVersion();
        this.logParameters();
        this.getLogger().info(MESSAGE_RESOLVING_DEPS);
        Set builtDependencies = this.getProject().getSubprojects().stream().map(p -> p.getGroup() + ":" + p.getName() + ":" + p.getVersion()).collect(Collectors.toSet());
        HashSet<Component> components = new HashSet<Component>();
        HashMap<String, org.cyclonedx.model.Dependency> dependencies = new HashMap<String, org.cyclonedx.model.Dependency>();
        Metadata metadata = this.createMetadata();
        Project rootProject = this.getProject();
        org.cyclonedx.model.Dependency rootDependency = new org.cyclonedx.model.Dependency(this.generatePackageUrl(rootProject));
        dependencies.put(this.generatePackageUrl(rootProject), rootDependency);
        HashSet<Project> projectsToScan = new HashSet<Project>();
        projectsToScan.add(rootProject);
        projectsToScan.addAll(rootProject.getSubprojects());
        projectsToScan.stream().filter(p -> !this.shouldSkipProject((Project)p)).forEach(project -> {
            Set configurations = project.getConfigurations().stream().filter(configuration -> this.shouldIncludeConfiguration((Configuration)configuration) && !this.shouldSkipConfiguration((Configuration)configuration) && DependencyUtils.canBeResolved(configuration)).collect(Collectors.toSet());
            String projectReference = this.generatePackageUrl((Project)project);
            if (!rootProject.equals(project)) {
                rootDependency.addDependency(new org.cyclonedx.model.Dependency(projectReference));
                components.add(this.generateProjectComponent((Project)project, version));
            }
            for (Configuration configuration2 : configurations) {
                this.addLocalProjectDependenciesToBuiltDependencies(builtDependencies, configuration2);
                Set componentsFromConfig = Collections.synchronizedSet(new LinkedHashSet());
                ResolvedConfiguration resolvedConfiguration = configuration2.getResolvedConfiguration();
                List depsFromConfig = Collections.synchronizedList(new ArrayList());
                org.cyclonedx.model.Dependency moduleDependency = new org.cyclonedx.model.Dependency(projectReference);
                Set directModuleDependencies = configuration2.getResolvedConfiguration().getFirstLevelModuleDependencies();
                while (directModuleDependencies.stream().anyMatch(this::dependencyWithoutJarArtifact)) {
                    Set<ResolvedDependency> depWithNoArtifacts = directModuleDependencies.stream().filter(this::dependencyWithoutJarArtifact).collect(Collectors.toSet());
                    directModuleDependencies.removeAll(depWithNoArtifacts);
                    depWithNoArtifacts.forEach(dmd -> directModuleDependencies.addAll(dmd.getChildren()));
                }
                for (ResolvedDependency directModuleDependency : directModuleDependencies) {
                    ResolvedArtifact directJarArtifact = this.getJarOrZipArtifact(directModuleDependency);
                    if (directJarArtifact == null) continue;
                    moduleDependency.addDependency(new org.cyclonedx.model.Dependency(this.generatePackageUrl(directJarArtifact)));
                    this.buildDependencyGraph(dependencies, directModuleDependency, directJarArtifact);
                }
                dependencies.compute(projectReference, (k, v) -> {
                    if (v == null) {
                        return moduleDependency;
                    }
                    if (moduleDependency.getDependencies() != null) {
                        moduleDependency.getDependencies().stream().forEach(arg_0 -> ((org.cyclonedx.model.Dependency)v).addDependency(arg_0));
                    }
                    return v;
                });
                resolvedConfiguration.getResolvedArtifacts().forEach(artifact -> {
                    String dependencyName = DependencyUtils.getDependencyName(artifact);
                    if (builtDependencies.contains(dependencyName)) {
                        return;
                    }
                    depsFromConfig.add(dependencyName);
                    Component component = this.convertArtifact((ResolvedArtifact)artifact, version);
                    this.augmentComponentMetadata(component, dependencyName);
                    componentsFromConfig.add(component);
                });
                Collections.sort(depsFromConfig);
                components.addAll(componentsFromConfig);
            }
        });
        this.writeBom(metadata, components, dependencies.values(), version);
    }

    private void addLocalProjectDependenciesToBuiltDependencies(Set<String> builtDependencies, Configuration configuration) {
        for (Dependency dependency : configuration.getAllDependencies()) {
            if (!(dependency instanceof ProjectDependency)) continue;
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            Project project = projectDependency.getDependencyProject();
            String dependencyId = projectDependency.getGroup() + ":" + projectDependency.getName() + ":" + project.getVersion();
            builtDependencies.add(dependencyId);
        }
    }

    private boolean dependencyWithoutJarArtifact(ResolvedDependency dependency) {
        return this.getJarOrZipArtifact(dependency) == null;
    }

    private Version computeSchemaVersion() {
        Version version = CycloneDxUtils.schemaVersion((String)this.getSchemaVersion().get());
        this.mavenHelper = new MavenHelper(this.getLogger(), version, (Boolean)this.getIncludeLicenseText().get());
        if (version == Version.VERSION_10) {
            this.setIncludeBomSerialNumber(false);
        }
        return version;
    }

    private Map<String, org.cyclonedx.model.Dependency> buildDependencyGraph(Map<String, org.cyclonedx.model.Dependency> dependenciesSoFar, ResolvedDependency resolvedDependency, ResolvedArtifact jarArtifact) {
        String dependencyPurl = this.generatePackageUrl(jarArtifact);
        org.cyclonedx.model.Dependency dependency = new org.cyclonedx.model.Dependency(dependencyPurl);
        if (dependenciesSoFar.containsKey(dependencyPurl)) {
            return dependenciesSoFar;
        }
        dependenciesSoFar.put(dependencyPurl, dependency);
        for (ResolvedDependency childDependency : resolvedDependency.getChildren()) {
            ResolvedArtifact childJarArtifact = this.getJarOrZipArtifact(childDependency);
            if (childJarArtifact == null) continue;
            dependency.addDependency(new org.cyclonedx.model.Dependency(this.generatePackageUrl(childJarArtifact)));
            this.buildDependencyGraph(dependenciesSoFar, childDependency, childJarArtifact);
        }
        return dependenciesSoFar;
    }

    private ResolvedArtifact getJarOrZipArtifact(ResolvedDependency dependency) {
        for (ResolvedArtifact artifact : dependency.getModuleArtifacts()) {
            if (!Objects.equals(artifact.getType(), "jar") && !Objects.equals(artifact.getType(), "aar") && !Objects.equals(artifact.getType(), "zip")) continue;
            return artifact;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenProject getResolvedMavenProject(String dependencyName) {
        Map<String, MavenProject> map = this.resolvedMavenProjects;
        synchronized (map) {
            if (this.resolvedMavenProjects.containsKey(dependencyName)) {
                return this.resolvedMavenProjects.get(dependencyName);
            }
        }
        Dependency pomDep = this.getProject().getDependencies().create((Object)(dependencyName + "@pom"));
        Configuration pomCfg = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{pomDep});
        try {
            File pomFile = pomCfg.resolve().stream().findFirst().orElse(null);
            if (pomFile != null) {
                MavenProject project = this.mavenHelper.readPom(pomFile);
                this.resolvedMavenProjects.put(dependencyName, project);
                if (project != null) {
                    Model model = this.mavenHelper.resolveEffectivePom(pomFile, this.getProject());
                    if (model != null) {
                        project.setLicenses(model.getLicenses());
                    }
                    return project;
                }
            }
        }
        catch (Exception err) {
            this.getLogger().error("Unable to resolve POM for " + dependencyName + ": " + err);
        }
        this.resolvedMavenProjects.put(dependencyName, null);
        return null;
    }

    private void augmentComponentMetadata(Component component, String dependencyName) {
        MavenProject project = this.getResolvedMavenProject(dependencyName);
        if (project != null) {
            if (project.getOrganization() != null) {
                component.setPublisher(project.getOrganization().getName());
            }
            component.setDescription(project.getDescription());
            component.setLicenseChoice(this.mavenHelper.resolveMavenLicenses(project.getLicenses()));
            this.mavenHelper.extractMetadata(project, component);
        }
    }

    protected Metadata createMetadata() {
        Project project = this.getProject();
        Properties properties = this.readPluginProperties();
        Metadata metadata = new Metadata();
        Tool tool = new Tool();
        tool.setVendor(properties.getProperty("vendor"));
        tool.setName(properties.getProperty("name"));
        tool.setVersion(properties.getProperty("version"));
        metadata.addTool(tool);
        Component component = new Component();
        component.setGroup(StringUtils.trimToNull((String)project.getGroup().toString()) != null ? project.getGroup().toString() : null);
        component.setName((String)this.componentName.get());
        component.setVersion((String)this.componentVersion.get());
        component.setType(this.resolveProjectType());
        component.setPurl(this.generatePackageUrl(project));
        component.setBomRef(component.getPurl());
        metadata.setComponent(component);
        if (this.organizationalEntity.getName() != null || this.organizationalEntity.getUrls() != null || this.organizationalEntity.getContacts() != null) {
            metadata.setManufacture(this.organizationalEntity);
        }
        if (this.licenseChoice.getLicenses() != null || this.licenseChoice.getExpression() != null) {
            metadata.setLicenseChoice(this.licenseChoice);
        }
        return metadata;
    }

    private Properties readPluginProperties() {
        Properties props = new Properties();
        try {
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("plugin.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.getLogger().warn("Unable to load plugin.properties", (Throwable)e);
        }
        return props;
    }

    private Component.Type resolveProjectType() {
        for (Component.Type type : Component.Type.values()) {
            if (!type.getTypeName().equalsIgnoreCase((String)this.getProjectType().get())) continue;
            return type;
        }
        this.getLogger().warn("Invalid project type. Defaulting to 'library'");
        this.getLogger().warn("Valid types are:");
        for (Component.Type type : Component.Type.values()) {
            this.getLogger().warn("  " + type.getTypeName());
        }
        return Component.Type.LIBRARY;
    }

    private Component generateProjectComponent(Project project, Version schemaVersion) {
        Component component = new Component();
        component.setGroup(project.getGroup().toString());
        component.setName(project.getName());
        component.setVersion(project.getVersion().toString());
        component.setType(Component.Type.LIBRARY);
        String projectReference = this.generatePackageUrl(project);
        component.setPurl(projectReference);
        if (schemaVersion.getVersion() >= 1.1) {
            component.setBomRef(projectReference);
        }
        return component;
    }

    private Component convertArtifact(ResolvedArtifact artifact, Version schemaVersion) {
        MavenProject project;
        Component component = new Component();
        component.setGroup(artifact.getModuleVersion().getId().getGroup());
        component.setName(artifact.getModuleVersion().getId().getName());
        component.setVersion(artifact.getModuleVersion().getId().getVersion());
        component.setType(Component.Type.LIBRARY);
        this.getLogger().debug(MESSAGE_CALCULATING_HASHES);
        List hashes = this.artifactHashes.computeIfAbsent(artifact.getFile(), f -> {
            try {
                return BomUtils.calculateHashes((File)f, (Version)schemaVersion);
            }
            catch (IOException e) {
                this.getLogger().error("Error encountered calculating hashes", (Throwable)e);
                return Collections.emptyList();
            }
        });
        component.setHashes(hashes);
        String packageUrl = this.generatePackageUrl(artifact);
        component.setPurl(packageUrl);
        if (schemaVersion.getVersion() >= 1.1) {
            component.setModified(Boolean.valueOf(this.mavenHelper.isModified(artifact)));
            component.setBomRef(packageUrl);
        }
        if (this.mavenHelper.isDescribedArtifact(artifact) && (project = this.mavenHelper.extractPom(artifact)) != null) {
            this.mavenHelper.getClosestMetadata(artifact, project, component);
        }
        return component;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldIncludeConfiguration(Configuration configuration) {
        if (((List)this.getIncludeConfigs().get()).isEmpty()) return true;
        if (!((List)this.getIncludeConfigs().get()).stream().anyMatch(configuration.getName()::matches)) return false;
        return true;
    }

    private boolean shouldSkipConfiguration(Configuration configuration) {
        return ((List)this.getSkipConfigs().get()).stream().anyMatch(configuration.getName()::matches);
    }

    private boolean shouldSkipProject(Project project) {
        return ((List)this.getSkipProjects().get()).contains(project.getName());
    }

    private String generatePackageUrl(ResolvedArtifact artifact) {
        TreeMap<String, String> qualifiers = new TreeMap<String, String>();
        qualifiers.put("type", artifact.getType());
        if (artifact.getClassifier() != null) {
            qualifiers.put("classifier", artifact.getClassifier());
        }
        return this.generatePackageUrl(artifact.getModuleVersion().getId().getGroup(), artifact.getModuleVersion().getId().getName(), artifact.getModuleVersion().getId().getVersion(), qualifiers);
    }

    private String generatePackageUrl(Project project) {
        TreeMap<String, String> qualifiers = new TreeMap<String, String>();
        if (project.getChildProjects().isEmpty()) {
            qualifiers.put("type", "jar");
        } else {
            qualifiers.put("type", "pom");
        }
        return this.generatePackageUrl(project.getGroup().toString(), project.getName(), project.getVersion().toString(), qualifiers);
    }

    private String generatePackageUrl(String groupId, String artifactId, String version, TreeMap<String, String> qualifiers) {
        try {
            return new PackageURL("maven", groupId, artifactId, version, qualifiers, null).canonicalize();
        }
        catch (MalformedPackageURLException e) {
            this.getLogger().warn("An unexpected issue occurred attempting to create a PackageURL for " + groupId + ":" + artifactId + ":" + version);
            return null;
        }
    }

    protected void writeBom(Metadata metadata, Set<Component> components, Collection<org.cyclonedx.model.Dependency> dependencies, Version version) throws GradleException {
        try {
            this.getLogger().info(MESSAGE_CREATING_BOM);
            Bom bom = new Bom();
            boolean includeSerialNumber = this.getBooleanParameter("cyclonedx.includeBomSerialNumber", (Boolean)this.getIncludeBomSerialNumber().get());
            if (Version.VERSION_10 != version && includeSerialNumber) {
                bom.setSerialNumber("urn:uuid:" + UUID.randomUUID());
            }
            bom.setMetadata(metadata);
            bom.setComponents(new ArrayList<Component>(components));
            bom.setDependencies(new ArrayList<org.cyclonedx.model.Dependency>(dependencies));
            if (((String)this.outputFormat.get()).equals("all") || ((String)this.outputFormat.get()).equals("xml")) {
                this.writeXMLBom(version, bom);
            }
            if (CycloneDxUtils.schemaVersion((String)this.getSchemaVersion().get()).getVersion() >= 1.2 && (((String)this.outputFormat.get()).equals("all") || ((String)this.outputFormat.get()).equals("json"))) {
                this.writeJSONBom(version, bom);
            }
        }
        catch (IOException | ParserConfigurationException | GeneratorException e) {
            throw new GradleException("An error occurred executing " + ((Object)((Object)this)).getClass().getName(), e);
        }
    }

    private void writeXMLBom(Version schemaVersion, Bom bom) throws GeneratorException, ParserConfigurationException, IOException {
        BomXmlGenerator bomGenerator = BomGeneratorFactory.createXml((Version)schemaVersion, (Bom)bom);
        bomGenerator.generate();
        String bomString = bomGenerator.toXmlString();
        File bomFile = new File((File)this.getDestination().get(), (String)this.getOutputName().get() + ".xml");
        this.getLogger().info(MESSAGE_WRITING_BOM_XML);
        FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        this.getLogger().info(MESSAGE_VALIDATING_BOM);
        XmlParser bomParser = new XmlParser();
        try {
            List exceptions = bomParser.validate(bomFile, schemaVersion);
            exceptions.forEach(it -> this.getLogger().error(it.getMessage()));
            if (!exceptions.isEmpty()) {
                throw (ParseException)exceptions.get(0);
            }
        }
        catch (Exception e) {
            throw new GradleException(MESSAGE_VALIDATION_FAILURE, (Throwable)e);
        }
    }

    private void writeJSONBom(Version schemaVersion, Bom bom) throws IOException {
        BomJsonGenerator bomGenerator = BomGeneratorFactory.createJson((Version)schemaVersion, (Bom)bom);
        String bomString = bomGenerator.toJsonString();
        File bomFile = new File((File)this.getDestination().get(), (String)this.getOutputName().get() + ".json");
        this.getLogger().info(MESSAGE_WRITING_BOM_JSON);
        FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        this.getLogger().info(MESSAGE_VALIDATING_BOM);
        JsonParser bomParser = new JsonParser();
        try {
            List exceptions = bomParser.validate(bomFile, schemaVersion);
            exceptions.forEach(it -> this.getLogger().error(it.getMessage()));
            if (!exceptions.isEmpty()) {
                throw (ParseException)exceptions.get(0);
            }
        }
        catch (Exception e) {
            throw new GradleException(MESSAGE_VALIDATION_FAILURE, (Throwable)e);
        }
    }

    private boolean getBooleanParameter(String parameter, boolean defaultValue) {
        Object o;
        Project project = super.getProject();
        if (project.hasProperty(parameter) && (o = project.getProperties().get(parameter)) instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        return defaultValue;
    }

    protected void logParameters() {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("CycloneDX: Parameters");
            this.getLogger().info("------------------------------------------------------------------------");
            this.getLogger().info("schemaVersion          : " + (String)this.schemaVersion.get());
            this.getLogger().info("includeLicenseText     : " + this.includeLicenseText.get());
            this.getLogger().info("includeBomSerialNumber : " + this.includeBomSerialNumber.get());
            this.getLogger().info("includeConfigs         : " + this.includeConfigs.get());
            this.getLogger().info("skipConfigs            : " + this.skipConfigs.get());
            this.getLogger().info("skipProjects           : " + this.skipProjects.get());
            this.getLogger().info("destination            : " + this.destination.get());
            this.getLogger().info("outputName             : " + (String)this.outputName.get());
            this.getLogger().info("------------------------------------------------------------------------");
        }
    }
}

