/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.cyclonedx.model.formulation.common.InputType;
import org.cyclonedx.util.serializer.EnvironmentVarsSerializer;
import org.cyclonedx.util.serializer.SerializerUtils;

public class InputTypeSerializer
extends StdSerializer<InputType> {
    private final boolean isXml;

    public InputTypeSerializer(boolean isXml) {
        this(null, isXml);
    }

    public InputTypeSerializer(Class<InputType> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(InputType value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createInputChoice(value, (JsonGenerator)xmlGenerator, serializerProvider);
        } else {
            this.createInputChoice(value, jsonGenerator, serializerProvider);
        }
    }

    private void createInputChoice(InputType input, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (input.getResource() != null) {
            jsonGenerator.writeFieldName("resource");
            jsonGenerator.writeObject((Object)input.getResource());
        } else if (input.getParameters() != null && !input.getParameters().isEmpty()) {
            jsonGenerator.writeFieldName("parameters");
            jsonGenerator.writeObject(input.getParameters());
        } else if (input.getEnvironmentVars() != null) {
            new EnvironmentVarsSerializer(this.isXml).serialize(input.getEnvironmentVars(), jsonGenerator, serializerProvider);
        } else if (input.getData() != null) {
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeObject((Object)input.getData());
        }
        SerializerUtils.writeField(jsonGenerator, "source", input.getSource());
        SerializerUtils.writeField(jsonGenerator, "target", input.getTarget());
        SerializerUtils.writeField(jsonGenerator, "properties", input.getProperties());
        jsonGenerator.writeEndObject();
    }

    public Class<InputType> handledType() {
        return InputType.class;
    }
}

