/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.Property;
import org.cyclonedx.util.deserializer.DeserializerUtils;
import org.cyclonedx.util.deserializer.PropertyDeserializer;

public class PropertiesDeserializer
extends JsonDeserializer<List<Property>> {
    private final PropertyDeserializer propertyDeserializer = new PropertyDeserializer();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<Property> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        return this.parseProperties(node.has("property") ? node.get("property") : node, p, ctxt);
    }

    private List<Property> parseProperties(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, this.objectMapper);
        for (JsonNode propertyNode : nodes) {
            properties.add(this.parseProperty(propertyNode, p, ctxt));
        }
        return properties;
    }

    private Property parseProperty(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonParser propertyParser = node.traverse(p.getCodec());
        propertyParser.nextToken();
        return this.propertyDeserializer.deserialize(propertyParser, ctxt);
    }
}

