/*
 * This file is part of CycloneDX Core (Java).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) OWASP Foundation. All Rights Reserved.
 */
package org.cyclonedx.model.vulnerability;

import java.net.URL;
import java.util.List;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import org.cyclonedx.model.ExtensibleType;

@Deprecated
@JsonRootName(Vulnerability10.NAME)
public class Vulnerability10
    extends ExtensibleType implements Serializable
{
  public static final String NAMESPACE_URI = "http://cyclonedx.org/schema/ext/vulnerability/1.0";
  public static final String PREFIX = "v";
  public static final String NAME = "vulnerability";
  public static final String ID = "id";
  public static final String SOURCE = "source";
  public static final String SOURCE_NAME = "name";
  public static final String URL = "url";
  public static final String VULNERABILITIES = "vulnerabilities";
  public static final String RATINGS = "ratings";
  public static final String RATING = "rating";
  public static final String REF = "ref";
  public static final String CWES = "cwes";
  public static final String CWE = "cwe";
  public static final String DESCRIPTION = "description";
  public static final String ADVISORIES = "advisories";
  public static final String ADVISORY = "advisory";
  public static final String RECOMMENDATIONS = "recommendations";
  public static final String RECOMMENDATION = "recommendation";
  public static final String SCORE = "score";
  public static final String BASE = "base";
  public static final String IMPACT = "impact";
  public static final String EXPLOITABILITY = "exploitability";
  public static final String SEVERITY = "severity";
  public static final String METHOD = "method";
  public static final String VECTOR = "vector";

  public Vulnerability10() {
    super(PREFIX, NAME);
  }

  public Vulnerability10(final String namespace, final String name) {
    super(namespace, name);
  }

  public enum Severity {
    NONE("None"),
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High"),
    CRITICAL("Critical"),
    UNKNOWN("Unknown");

    private final String name;

    public String getSeverityName() {
      return this.name;
    }

    Severity(String name) {
      this.name = name;
    }

    public static Severity fromString(String text) {
      for (Severity s : Severity.values()) {
        if (s.name.equals(text)) {
          return s;

        }
      }
      return null;
    }
  }

  public enum ScoreSource {
    CVSSv3("CVSSv3"),
    CVSSv2("CVSSv2"),
    OWASP("OWASP Risk"),
    FAIR("Open FAIR"),
    OTHER("Other");

    private final String name;

    public String getScoreSourceName() {
      return this.name;
    }

    ScoreSource(String name) {
      this.name = name;
    }

    public static ScoreSource fromString(String text) {
      for (ScoreSource s : ScoreSource.values()) {
        if (s.name.equals(text)) {
          return s;
        }
      }
      return null;
    }
  }

  private String id;
  @JsonProperty(Vulnerability10.REF)
  private String ref;
  private Source source;
  private List<Rating> ratings;
  private List<Cwe> cwes;
  private String description;
  private List<Recommendation> recommendations;
  private List<Advisory> advisories;

  public List<Advisory> getAdvisories() {
    return advisories;
  }

  public void setAdvisories(final List<Advisory> advisories) {
    this.advisories = advisories;
  }

  public List<Recommendation> getRecommendations() {
    return recommendations;
  }

  public void setRecommendations(final List<Recommendation> recommendations) {
    this.recommendations = recommendations;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(final String description) {
    this.description = description;
  }

  public List<Cwe> getCwes() {
    return cwes;
  }

  public void setCwes(final List<Cwe> cwes) {
    this.cwes = cwes;
  }

  @JacksonXmlElementWrapper(localName = RATINGS)
  @JacksonXmlProperty(localName = RATING)
  public List<Rating> getRatings() {
    return ratings;
  }

  public void setRatings(final List<Rating> ratings) {
    this.ratings = ratings;
  }

  public Source getSource() {
    return source;
  }

  public void setSource(final Source source) {
    this.source = source;
  }

  public String getRef() {
    return ref;
  }

  public void setRef(final String ref) {
    this.ref = ref;
  }

  public String getId() {
    return id;
  }

  public void setId(final String id) {
    this.id = id;
  }

  @JsonIgnoreProperties(ignoreUnknown = true)
  @JsonInclude(JsonInclude.Include.NON_NULL)
  public static class Source {
    @JacksonXmlProperty(localName = "name", isAttribute = true)
    private String name;
    private java.net.URL url;

    public URL getUrl() {
      return url;
    }

    public void setUrl(final URL url) {
      this.url = url;
    }

    public String getName() {
      return name;
    }

    public void setName(final String name) {
      this.name = name;
    }
  }

  public static class Score {
    private Double base;
    private Double impact;
    private Double exploitability;

    public Double getBase() {
      return base;
    }

    public void setBase(final Double base) {
      this.base = base;
    }

    public Double getImpact() {
      return impact;
    }

    public void setImpact(final Double impact) {
      this.impact = impact;
    }

    public Double getExploitability() {
      return exploitability;
    }

    public void setExploitability(final Double exploitability) {
      this.exploitability = exploitability;
    }
  }

  public static class Cwe {
    private Integer text;

    public Integer getText() {
      return text;
    }

    public void setText(final Integer text) {
      this.text = text;
    }
  }

  public static class Advisory {
    private String text;

    public String getText() {
      return text;
    }

    public void setText(final String text) {
      this.text = text;
    }
  }

  public static class Recommendation implements Comparable<Recommendation> {
    private String text;

    public String getText() {
      return text;
    }

    public void setText(final String text) {
      this.text = text;
    }

    @Override
    public int compareTo(final Recommendation r) {
      return text.compareTo(r.getText());
    }
  }
}
