package org.cyclonedx.model.vulnerability;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import org.cyclonedx.model.AttachmentText;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonPropertyOrder({
    "reproductionSteps",
    "environment",
    "supportingMaterial"
})
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class ProofOfConcept
{
  private String reproductionSteps;

  private String environment;

  private List<AttachmentText> supportingMaterial;

  public String getEnvironment() {
    return environment;
  }

  public void setEnvironment(final String environment) {
    this.environment = environment;
  }

  @JacksonXmlElementWrapper(localName = "supportingMaterial")
  @JacksonXmlProperty(localName = "attachment")
  @JsonProperty("supportingMaterial")
  public List<AttachmentText> getSupportingMaterial() {
    return supportingMaterial;
  }

  public void setSupportingMaterial(final List<AttachmentText> supportingMaterial) {
    this.supportingMaterial = supportingMaterial;
  }

  public String getReproductionSteps() {
    return reproductionSteps;
  }

  public void setReproductionSteps(final String reproductionSteps) {
    this.reproductionSteps = reproductionSteps;
  }

  @Override
  public boolean equals(final Object object) {
    if (this == object) {
      return true;
    }
    if (!(object instanceof ProofOfConcept)) {
      return false;
    }
    ProofOfConcept that = (ProofOfConcept) object;
    return Objects.equals(reproductionSteps, that.reproductionSteps) &&
        Objects.equals(environment, that.environment) &&
        Objects.equals(supportingMaterial, that.supportingMaterial);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reproductionSteps, environment, supportingMaterial);
  }
}
