/*
 * This file is part of CycloneDX Core (Java).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) OWASP Foundation. All Rights Reserved.
 */
package org.cyclonedx.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import org.cyclonedx.util.deserializer.AttachmentTextDeserializer;

@SuppressWarnings("unused")
@JsonPropertyOrder({
    "contentType",
    "content-type",
    "encoding"})
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonDeserialize(using = AttachmentTextDeserializer.class)
public class AttachmentText {

    @JacksonXmlProperty(isAttribute = true)
    private String encoding;

    @JacksonXmlProperty(localName = "content-type", isAttribute = true)
    @JsonProperty("contentType")
    private String contentType;

    @JacksonXmlText
    @JsonProperty("content")
    private String text;

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AttachmentText attachmentText = (AttachmentText) o;
        return Objects.equals(contentType, attachmentText.contentType) &&
                Objects.equals(encoding, attachmentText.encoding) &&
                Objects.equals(text, attachmentText.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(contentType, encoding, text);
    }
}
