/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.model.Property;

public class PropertiesSerializer
extends JsonSerializer<List<Property>> {
    private boolean isXml;

    public PropertiesSerializer(boolean isXml) {
        this.isXml = isXml;
    }

    public PropertiesSerializer() {
    }

    public void serialize(List<Property> properties, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        if (this.isXml) {
            PropertiesSerializer.serializeXml(properties, (ToXmlGenerator)jsonGenerator);
        } else {
            this.serializerJson(properties, jsonGenerator);
        }
    }

    private void serializerJson(List<Property> properties, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
        for (Property property : properties) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("name", (Object)property.getName());
            jsonGenerator.writeObjectField("value", (Object)property.getValue());
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
    }

    private static void serializeXml(List<Property> properties, ToXmlGenerator xmlGenerator) throws IOException {
        xmlGenerator.writeStartArray();
        for (Property property : properties) {
            xmlGenerator.writeStartObject((Object)"property");
            xmlGenerator.setNextIsAttribute(true);
            xmlGenerator.writeFieldName("name");
            xmlGenerator.writeString(property.getName());
            xmlGenerator.setNextIsAttribute(false);
            xmlGenerator.setNextIsUnwrapped(true);
            xmlGenerator.writeStringField("", property.getValue());
            xmlGenerator.writeEndObject();
        }
        xmlGenerator.writeEndArray();
    }

    public Class<List<Property>> handledType() {
        return List.class;
    }
}

